/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.Locale;
import org.mpxj.DataType;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.UniqueIdObjectSequenceProvider;

public final class UserDefinedField
implements FieldType {
    private final Integer m_uniqueID;
    private final FieldTypeClass m_fieldTypeClass;
    private final boolean m_summaryTaskOnly;
    private final String m_externalName;
    private final String m_internalName;
    private final DataType m_dataType;

    private UserDefinedField(Builder builder) {
        this.m_uniqueID = builder.m_sequenceProvider.getUniqueIdObjectSequence(UserDefinedField.class).syncOrGetNext(builder.m_uniqueID);
        this.m_internalName = builder.m_internalName == null || builder.m_internalName.isEmpty() ? (builder.m_internalName = "user_field_" + this.m_uniqueID) : builder.m_internalName;
        this.m_externalName = builder.m_externalName;
        this.m_fieldTypeClass = builder.m_fieldTypeClass;
        this.m_summaryTaskOnly = builder.m_summaryTaskOnly;
        this.m_dataType = builder.m_dataType;
    }

    @Override
    public int getValue() {
        return this.m_uniqueID;
    }

    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public boolean getSummaryTaskOnly() {
        return this.m_summaryTaskOnly;
    }

    @Override
    public FieldTypeClass getFieldTypeClass() {
        return this.m_fieldTypeClass;
    }

    @Override
    public String getName() {
        return this.m_externalName;
    }

    @Override
    public String name() {
        return this.m_internalName;
    }

    @Override
    public String getName(Locale locale) {
        return this.getName();
    }

    @Override
    public DataType getDataType() {
        return this.m_dataType;
    }

    @Override
    public FieldType getUnitsType() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public static class Builder {
        private final UniqueIdObjectSequenceProvider m_sequenceProvider;
        private Integer m_uniqueID;
        private FieldTypeClass m_fieldTypeClass;
        private boolean m_summaryTaskOnly;
        private String m_externalName;
        private String m_internalName;
        private DataType m_dataType;

        public Builder(UniqueIdObjectSequenceProvider sequenceProvider) {
            this.m_sequenceProvider = sequenceProvider;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder fieldTypeClass(FieldTypeClass value) {
            this.m_fieldTypeClass = value;
            return this;
        }

        public Builder summaryTaskOnly(boolean value) {
            this.m_summaryTaskOnly = value;
            return this;
        }

        public Builder externalName(String value) {
            this.m_externalName = value;
            return this;
        }

        public Builder internalName(String value) {
            this.m_internalName = value;
            return this;
        }

        public Builder dataType(DataType value) {
            this.m_dataType = value;
            return this;
        }

        public UserDefinedField build() {
            return new UserDefinedField(this);
        }
    }
}

