/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.stream.DoubleStream;
import org.mpxj.ProjectEntityWithUniqueID;

public final class WorkContour
implements ProjectEntityWithUniqueID {
    private final String m_name;
    private final boolean m_default;
    private final Integer m_uniqueID;
    private final double[] m_curveValues;
    public static final WorkContour FLAT = new WorkContour(1, "FLAT", true, 0.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0);
    public static final WorkContour BACK_LOADED = new WorkContour(2, "BACK_LOADED", true, 0.0, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5);
    public static final WorkContour FRONT_LOADED = new WorkContour(3, "FRONT_LOADED", true, 0.0, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5);
    public static final WorkContour DOUBLE_PEAK = new WorkContour(4, "DOUBLE_PEAK", true, 0.0, 1.3, 2.5, 3.8, 5.1, 7.6, 10.1, 7.6, 5.1, 3.8, 2.5, 2.5, 2.5, 3.8, 5.1, 7.6, 10.1, 7.6, 5.1, 3.8, 2.5);
    public static final WorkContour EARLY_PEAK = new WorkContour(5, "EARLY_PEAK", true, 0.0, 1.2, 2.5, 3.8, 5.0, 7.5, 10.1, 10.1, 10.1, 8.8, 7.5, 6.3, 5.0, 5.0, 5.0, 3.8, 2.5, 2.0, 1.5, 1.3, 1.0);
    public static final WorkContour LATE_PEAK = new WorkContour(6, "LATE_PEAK", true, 0.0, 1.0, 1.3, 1.5, 2.0, 2.5, 3.8, 5.0, 5.0, 5.0, 6.3, 7.5, 8.8, 10.1, 10.1, 10.1, 7.5, 5.0, 3.8, 2.5, 1.2);
    public static final WorkContour BELL = new WorkContour(7, "BELL", true, 0.0, 0.5, 0.5, 1.5, 1.5, 4.0, 4.0, 7.5, 7.5, 11.5, 11.5, 11.5, 11.5, 7.5, 7.5, 4.0, 4.0, 1.5, 1.5, 0.5, 0.5);
    public static final WorkContour TURTLE = new WorkContour(8, "TURTLE", true, 0.0, 1.0, 1.0, 3.5, 3.5, 5.5, 5.5, 7.5, 7.5, 7.5, 7.5, 7.5, 7.5, 7.5, 7.5, 5.5, 5.5, 3.5, 3.5, 1.0, 1.0);
    public static final WorkContour CONTOURED = new WorkContour(9, "CONTOURED", false, (double[])null);

    public WorkContour(Integer uniqueID, String name, boolean isDefault, double ... curveValues) {
        this.m_uniqueID = uniqueID;
        this.m_name = name;
        this.m_default = isDefault;
        this.m_curveValues = curveValues;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public double[] getCurveValues() {
        return this.m_curveValues;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isContourManual() {
        return this.m_curveValues == null;
    }

    public boolean isContourFlat() {
        return this.m_curveValues != null && this.m_curveValues[0] == 0.0 && DoubleStream.of(this.m_curveValues).skip(1L).distinct().count() == 1L;
    }

    public boolean isContourDefault() {
        return this.m_default;
    }

    public String toString() {
        return this.m_name;
    }
}

