/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.asta;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.asta.AstaSqliteReader;
import org.mpxj.asta.AstaTextFileReader;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.reader.AbstractProjectReader;
import org.mpxj.reader.AbstractProjectStreamReader;

public final class AstaFileReader
extends AbstractProjectStreamReader {
    private static final String SQLITE_TEXT = "SQLite format";

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            BufferedInputStream is = new BufferedInputStream(inputStream);
            is.mark(100);
            byte[] buffer = InputStreamHelper.read((InputStream)is, SQLITE_TEXT.length());
            is.reset();
            String actualText = new String(buffer);
            AbstractProjectReader reader = SQLITE_TEXT.equals(actualText) ? new AstaSqliteReader() : new AstaTextFileReader();
            this.addListenersToReader(reader);
            return reader.read(is);
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to read file", ex);
        }
    }
}

