/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.asta;

import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mpxj.asta.AbstractAstaDatabaseReader;
import org.mpxj.asta.AstaDatabaseException;
import org.mpxj.asta.JackcessResultSetRow;
import org.mpxj.asta.Row;

public final class AstaMdbReader
extends AbstractAstaDatabaseReader {
    private File m_databaseFile;
    private Database m_database;

    @Override
    protected List<Row> getRows(String tableName, Map<String, Integer> keys) throws AstaDatabaseException {
        return this.getRows(tableName, keys, Collections.emptyMap());
    }

    @Override
    protected List<Row> getRows(String tableName, Map<String, Integer> keys, Map<String, String> nameMap) throws AstaDatabaseException {
        try {
            if (this.m_database == null) {
                this.m_database = DatabaseBuilder.open((File)this.m_databaseFile);
            }
            ArrayList<Row> result = new ArrayList<Row>();
            Table table = this.m_database.getTable(tableName);
            List columns = table.getColumns();
            if (keys.isEmpty()) {
                for (com.healthmarketscience.jackcess.Row row : table) {
                    result.add(new JackcessResultSetRow(nameMap, row, columns));
                }
            } else {
                Cursor cursor = CursorBuilder.createCursor((Table)table);
                if (cursor.findFirstRow(keys)) {
                    do {
                        result.add(new JackcessResultSetRow(nameMap, cursor.getCurrentRow(), columns));
                    } while (cursor.findNextRow(keys));
                }
            }
            return result;
        }
        catch (IOException ex) {
            throw new AstaDatabaseException(ex);
        }
    }

    @Override
    protected void allocateResources(File file) {
        this.m_databaseFile = file;
    }

    @Override
    protected void releaseResources() {
        try {
            if (this.m_database != null) {
                this.m_database.close();
                this.m_database = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

