/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.asta;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mpxj.ActivityCode;
import org.mpxj.ActivityCodeContainer;
import org.mpxj.ActivityCodeValue;
import org.mpxj.ActivityType;
import org.mpxj.Availability;
import org.mpxj.ChildTaskContainer;
import org.mpxj.ConstraintType;
import org.mpxj.CostRateTable;
import org.mpxj.CostRateTableEntry;
import org.mpxj.CustomFieldContainer;
import org.mpxj.DataType;
import org.mpxj.DayType;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.LocalDateRange;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarDays;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectCalendarWeek;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceType;
import org.mpxj.Task;
import org.mpxj.TimeUnit;
import org.mpxj.UnitOfMeasureContainer;
import org.mpxj.UserDefinedField;
import org.mpxj.UserDefinedFieldContainer;
import org.mpxj.asta.AstaBaselineStrategy;
import org.mpxj.asta.ObjectType;
import org.mpxj.asta.Row;
import org.mpxj.asta.RowComparator;
import org.mpxj.common.HierarchyHelper;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.LocalTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ObjectSequence;

final class AstaReader {
    private final ProjectFile m_project;
    private final EventManager m_eventManager;
    private final Map<Task, Double> m_weights = new HashMap<Task, Double>();
    private final Set<Integer> m_deferredConstraintType = new HashSet<Integer>();
    private final Map<Integer, Task> m_barMap = new HashMap<Integer, Task>();
    private final Map<Integer, Task> m_taskMap = new HashMap<Integer, Task>();
    private final Map<Integer, Task> m_milestoneMap = new HashMap<Integer, Task>();
    private final Map<Integer, Task> m_expandedTaskMap = new HashMap<Integer, Task>();
    private final Map<Integer, Task> m_completedSectionMap = new HashMap<Integer, Task>();
    private static final Double COMPLETE = 100.0;
    private static final Double INCOMPLETE = 0.0;
    private static final String LINE_BREAK = "|@|||";
    private static final RowComparator LEAF_COMPARATOR = new RowComparator("NATURAL_ORDER", "NATURAL_ORDER");
    private static final RowComparator BAR_COMPARATOR = new RowComparator("EXPANDED_TASK", "NATURAL_ORDER");
    private static final RelationType[] RELATION_TYPES = new RelationType[]{RelationType.FINISH_START, RelationType.START_START, RelationType.FINISH_FINISH, RelationType.START_FINISH};
    private static final Map<Integer, DataType> DATA_TYPE_MAP = new HashMap<Integer, DataType>();

    public AstaReader() {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoTaskUniqueID(false);
        config.setAutoResourceUniqueID(false);
        config.setAutoAssignmentUniqueID(false);
        config.setAutoCalendarUniqueID(false);
        config.setAutoRelationUniqueID(false);
        config.setBaselineStrategy(AstaBaselineStrategy.INSTANCE);
        this.m_project.getProjectProperties().setFileApplication("Asta");
        this.m_project.getProjectProperties().setFileType("PP");
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public void processProjectProperties(Integer schemaVersion, Row projectSummary, Row userSettings, List<Row> progressPeriods) {
        ProjectProperties ph = this.m_project.getProjectProperties();
        ph.setApplicationVersion(schemaVersion);
        if (projectSummary != null) {
            ph.setDuration(projectSummary.getDuration("DURATION"));
            ph.setStartDate(projectSummary.getDate("PROJECT_START"));
            ph.setFinishDate(projectSummary.getDate("PROJECT_END"));
            ph.setName(projectSummary.getString("SHORT_NAME"));
            ph.setAuthor(projectSummary.getString("PROJECT_BY"));
            ph.setLastSaved(projectSummary.getDate("LAST_EDITED_DATE"));
        }
        Integer currentProgressPeriodID = userSettings == null ? null : userSettings.getInteger("CURRENT_PROGRESS_PERIOD");
        if (progressPeriods != null) {
            Row progressPeriod;
            if (currentProgressPeriodID == null) {
                progressPeriods.sort(Comparator.comparing(o -> o.getInteger("ID")));
                progressPeriod = progressPeriods.get(progressPeriods.size() - 1);
            } else {
                progressPeriod = progressPeriods.stream().filter(r -> NumberHelper.equals(currentProgressPeriodID, r.getInteger("ID"))).findFirst().orElse(null);
            }
            if (progressPeriod != null) {
                ph.setStatusDate(progressPeriod.getDate("REPORT_DATE"));
            }
        }
    }

    public void processResources(List<Row> permanentRows, List<Row> consumableRows) {
        for (Row row : permanentRows) {
            Resource resource = this.m_project.addResource();
            resource.setType(ResourceType.WORK);
            resource.setUniqueID(row.getInteger("ID"));
            resource.setEmailAddress(row.getString("EMAIL_ADDRESS"));
            resource.setName(row.getString("NAME"));
            resource.setCalendar((ProjectCalendar)this.m_project.getCalendars().getByUniqueID(row.getInteger("CALENDAR")));
            resource.setGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setInitials(this.getInitials(resource.getName()));
            resource.getAvailability().add(new Availability(LocalDateTimeHelper.START_DATE_NA, LocalDateTimeHelper.END_DATE_NA, row.getDouble("AVAILABILITY") * 100.0));
        }
        UnitOfMeasureContainer uom = this.m_project.getUnitsOfMeasure();
        for (Row row : consumableRows) {
            Resource resource = this.m_project.addResource();
            resource.setType(ResourceType.MATERIAL);
            resource.setUniqueID(row.getInteger("ID"));
            resource.setName(row.getString("NAME"));
            resource.setCalendar((ProjectCalendar)this.m_project.getCalendars().getByUniqueID(row.getInteger("CALENDAR")));
            resource.setGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setUnitOfMeasure(uom.getOrCreateByAbbreviation(row.getString("MEASUREMENT")));
            resource.setInitials(this.getInitials(resource.getName()));
            CostRateTable table = new CostRateTable();
            table.add(new CostRateTableEntry(LocalDateTimeHelper.START_DATE_NA, LocalDateTimeHelper.END_DATE_NA, (Number)row.getDouble("COST_PER_USEDEFAULTSAMOUNT"), new Rate[0]));
            resource.setCostRateTable(0, table);
            LocalDateTime availableFrom = row.getDate("AVAILABLE_FROM");
            LocalDateTime availableTo = row.getDate("AVAILABLE_TO");
            availableFrom = availableFrom == null ? LocalDateTimeHelper.START_DATE_NA : availableFrom;
            availableTo = availableTo == null ? LocalDateTimeHelper.END_DATE_NA : availableTo;
            resource.getAvailability().add(new Availability(availableFrom, availableTo, row.getDouble("AVAILABILITY") * 100.0));
        }
    }

    public void processTasks(List<Row> bars, List<Row> expandedTasks, List<Row> tasks, List<Row> milestones, List<Row> hammocks, List<Row> completedSections) {
        List<Row> parentBars = this.buildRowHierarchy(bars, expandedTasks, tasks, milestones, hammocks);
        this.createTasks(this.m_project, "", parentBars);
        this.populateCompletedSections(completedSections);
        this.deriveProjectCalendar();
        this.updateUniqueIDs();
        this.updateStructure();
        this.updateDates();
        this.calculatePercentComplete();
    }

    /*
     * WARNING - void declaration
     */
    private List<Row> buildRowHierarchy(List<Row> bars, List<Row> expandedTasks, List<Row> tasks, List<Row> milestones, List<Row> hammocks) {
        void var9_13;
        Integer expandedTaskID;
        ArrayList<Row> leaves = new ArrayList<Row>();
        leaves.addAll(tasks);
        leaves.addAll(milestones);
        leaves.addAll(hammocks);
        bars.sort(BAR_COMPARATOR);
        leaves.sort(LEAF_COMPARATOR);
        HashMap<Integer, Row> barIdToBarMap = new HashMap<Integer, Row>();
        for (Row row : bars) {
            barIdToBarMap.put(row.getInteger("BARID"), row);
        }
        HashMap<Integer, Row> expandedTaskIdToBarMap = new HashMap<Integer, Row>();
        for (Row row : expandedTasks) {
            Row bar3 = (Row)barIdToBarMap.get(row.getInteger("BAR"));
            bar3.merge(row, "_");
            expandedTaskID = bar3.getInteger("_EXPANDED_TASKID");
            expandedTaskIdToBarMap.put(expandedTaskID, bar3);
        }
        ArrayList<Row> arrayList = new ArrayList<Row>();
        for (Row bar : bars) {
            expandedTaskID = bar.getInteger("EXPANDED_TASK");
            Row parentBar = (Row)expandedTaskIdToBarMap.get(expandedTaskID);
            if (parentBar == null) {
                arrayList.add(bar);
                continue;
            }
            parentBar.addChild(bar);
        }
        for (Row leaf : leaves) {
            Integer barID = leaf.getInteger("BAR");
            Row bar4 = (Row)barIdToBarMap.get(barID);
            bar4.addChild(leaf);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Row bar;
            bar = (Row)iterator.next();
            String barName = bar.getString("NAME");
            if (barName != null && !barName.isEmpty() && !barName.equals("Displaced Items")) continue;
            iterator.remove();
        }
        if (arrayList.size() == 1) {
            List<Row> list = ((Row)arrayList.get(0)).getChildRows();
        }
        return var9_13;
    }

    private void createTasks(ChildTaskContainer parent, String parentName, List<Row> rows) {
        for (Row row : rows) {
            boolean rowIsBar;
            boolean bl = rowIsBar = row.getInteger("BARID") != null;
            if (rowIsBar && this.childRowsAreHammocks(row)) continue;
            Task task = parent.addTask();
            if (row.getInteger("_EXPANDED_TASKID") != null) {
                this.m_expandedTaskMap.put(row.getInteger("_EXPANDED_TASKID"), task);
            }
            if (rowIsBar) {
                if (this.skipBar(row)) {
                    this.populateLeaf(row.getString("NAME"), row.getChildRows().get(0), task);
                } else {
                    this.populateBar(row, task);
                    this.createTasks(task, task.getName(), row.getChildRows());
                }
                this.m_barMap.put(row.getInteger("BARID"), task);
            } else {
                this.populateLeaf(parentName, row, task);
            }
            this.m_eventManager.fireTaskReadEvent(task);
        }
    }

    private void populateCompletedSections(List<Row> rows) {
        for (Row section : rows) {
            Task task = this.getTaskByAstaID(section.getInteger("TASK"));
            if (task == null) continue;
            this.m_completedSectionMap.put(section.getInteger("ID"), task);
        }
    }

    private boolean skipBar(Row row) {
        List<Row> childRows = row.getChildRows();
        if (childRows.size() != 1) {
            return false;
        }
        Row childRow = childRows.get(0);
        return (childRow.getInteger("TASKID") != null || childRow.getInteger("MILESTONEID") != null) && childRow.getChildRows().isEmpty();
    }

    private boolean childRowsAreHammocks(Row row) {
        int childCount = row.getChildRows().size();
        if (childCount == 0) {
            return false;
        }
        int count = (int)row.getChildRows().stream().filter(r -> r.getInteger("HAMMOCK_TASKID") != null).count();
        return count == childCount;
    }

    private void populateLeaf(String parentName, Row row, Task task) {
        if (row.getInteger("TASKID") != null) {
            this.populateTask(row, task);
            this.m_taskMap.put(row.getInteger("TASKID"), task);
        } else if (row.getInteger("MILESTONEID") != null) {
            this.populateMilestone(row, task);
            this.m_milestoneMap.put(row.getInteger("MILESTONEID"), task);
        } else {
            task.setUniqueID(row.getInteger("BARID"));
            task.setName(row.getString("NAME"));
        }
        String name = task.getName();
        if (name == null || name.isEmpty()) {
            task.setName(parentName);
        }
        task.setBarName(parentName);
    }

    private void populateTask(Row row, Task task) {
        task.setUniqueID(row.getInteger("TASKID"));
        task.setResume(row.getDate("RESUME"));
        task.setActualDuration(row.getDuration("ACTUAL_DURATION"));
        task.setEarlyStart(row.getDate("EARLY_START_DATE"));
        task.setLateStart(row.getDate("LATE_START_DATE"));
        task.setEarlyFinish(row.getDate("EARLY_END_DATE_RS"));
        task.setLateFinish(row.getDate("LATE_END_DATE_RS"));
        task.setName(row.getString("NAME"));
        task.setNotes(this.getNotes(row));
        task.setActivityID(row.getString("UNIQUE_TASK_ID"));
        task.setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAR")));
        task.setStart(row.getDate("LINKABLE_START"));
        task.setFinish(row.getDate("LINKABLE_FINISH"));
        Double overallPercentComplete = row.getPercent("OVERALL_PERCENT_COMPLETE");
        task.setOverallPercentComplete(overallPercentComplete);
        this.m_weights.put(task, row.getDouble("OVERALL_PERCENT_COMPL_WEIGHT"));
        boolean taskIsComplete = overallPercentComplete != null && overallPercentComplete > 99.0;
        Duration remainingDuration = null;
        if (!taskIsComplete) {
            LocalDateTime startDate = task.getResume();
            if (startDate == null) {
                startDate = task.getStart();
            }
            remainingDuration = this.timeUnitIsElapsed(row.getInt("DURATION_TIME_UNIT")) ? Duration.getInstance(startDate.until(task.getFinish(), ChronoUnit.HOURS), TimeUnit.HOURS) : task.getEffectiveCalendar().getWork(startDate, task.getFinish(), TimeUnit.HOURS);
        }
        if (remainingDuration == null) {
            remainingDuration = Duration.getInstance(0, TimeUnit.HOURS);
        }
        task.setRemainingDuration(remainingDuration);
        Duration actualDuration = task.getActualDuration();
        Duration durationAtCompletion = Duration.getInstance(actualDuration.getDuration() + remainingDuration.getDuration(), TimeUnit.HOURS);
        task.setDuration(durationAtCompletion);
        if (overallPercentComplete != null && overallPercentComplete > 99.0) {
            task.setActualDuration(task.getDuration());
            task.setActualStart(task.getStart());
            task.setActualFinish(task.getFinish());
            task.setPercentageComplete(COMPLETE);
        } else if (durationAtCompletion != null && durationAtCompletion.getDuration() > 0.0 && actualDuration.getDuration() > 0.0) {
            task.setActualStart(task.getStart());
            double percentComplete = actualDuration.getDuration() / durationAtCompletion.getDuration() * 100.0;
            task.setPercentageComplete(percentComplete);
            if (percentComplete > 99.0) {
                task.setActualFinish(task.getFinish());
            }
        } else {
            task.setPercentageComplete(INCOMPLETE);
        }
        if (task.getEarlyStart() != null && task.getEarlyFinish() == null) {
            task.setEarlyFinish(task.getEffectiveCalendar().getDate(task.getEarlyStart(), task.getDuration()));
        }
        if (task.getLateStart() != null && task.getLateFinish() == null) {
            task.setLateFinish(task.getEffectiveCalendar().getDate(task.getLateStart(), task.getDuration()));
        }
        this.processConstraints(row, task);
    }

    private void populateBar(Row row, Task task) {
        String extendedTaskName;
        String name;
        Integer calendarID = row.getInteger("_CALENDAR");
        if (calendarID == null && !row.getChildRows().isEmpty()) {
            calendarID = row.getChildRows().get(0).getInteger("CALENDAR");
        }
        if (((name = row.getString("NAME")) == null || name.isEmpty()) && (extendedTaskName = row.getString("_NAME")) != null && !extendedTaskName.isEmpty()) {
            name = extendedTaskName;
        }
        ProjectCalendar calendar = this.m_project.getCalendarByUniqueID(calendarID);
        task.setUniqueID(row.getInteger("BARID"));
        task.setStart(row.getDate("BAR_START"));
        task.setFinish(row.getDate("BAR_FINISH"));
        task.setName(name);
        task.setActivityID(row.getString("_UNIQUE_TASK_ID"));
        task.setCalendar(calendar);
        Duration durationAtCompletion = this.deriveEffectiveCalendar(task).getWork(task.getStart(), task.getFinish(), TimeUnit.HOURS);
        task.setDuration(durationAtCompletion);
    }

    private ProjectCalendar deriveEffectiveCalendar(Task task) {
        ProjectCalendar result = task.getEffectiveCalendar();
        if (result == null) {
            result = this.m_project.getCalendars().isEmpty() ? this.m_project.addDefaultBaseCalendar() : (ProjectCalendar)this.m_project.getCalendars().get(0);
        }
        return result;
    }

    private void populateMilestone(Row row, Task task) {
        task.setMilestone(true);
        task.setUniqueID(row.getInteger("MILESTONEID"));
        task.setStart(row.getDate("GIVEN_DATE_TIME"));
        task.setFinish(row.getDate("GIVEN_DATE_TIME"));
        task.setActivityType(this.getMilestoneType(row));
        task.setEarlyStart(row.getDate("EARLY_START_DATE"));
        task.setLateStart(row.getDate("LATE_START_DATE"));
        task.setEarlyFinish(row.getDate("EARLY_END_DATE_RS"));
        task.setLateFinish(row.getDate("LATE_END_DATE_RS"));
        task.setName(row.getString("NAME"));
        task.setActivityID(row.getString("UNIQUE_TASK_ID"));
        task.setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAR")));
        task.setDuration(Duration.getInstance(0, TimeUnit.HOURS));
        if (row.getBoolean("COMPLETED")) {
            task.setPercentageComplete(COMPLETE);
            task.setActualStart(task.getStart());
            task.setActualFinish(task.getFinish());
        } else {
            task.setPercentageComplete(INCOMPLETE);
        }
        if (task.getEarlyFinish() == null) {
            task.setEarlyFinish(task.getEarlyStart());
        }
        if (task.getLateFinish() == null) {
            task.setLateFinish(task.getLateStart());
        }
        this.processConstraints(row, task);
        this.m_weights.put(task, row.getDouble("OVERALL_PERCENT_COMPL_WEIGHT"));
    }

    private ActivityType getMilestoneType(Row row) {
        Integer value = row.getInteger("MILESTONE_TYPE");
        if (value == null) {
            return ActivityType.FINISH_MILESTONE;
        }
        return value == 1 ? ActivityType.FINISH_MILESTONE : ActivityType.START_MILESTONE;
    }

    private void updateUniqueIDs() {
        this.m_project.getTasks().stream().filter(t -> t.getUniqueID() == null).forEach(t -> t.setUniqueID(this.m_project.getUniqueIdObjectSequence(Task.class).getNext()));
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_project.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    private void calculatePercentComplete() {
        ArrayList<Task> childTasks = new ArrayList<Task>();
        for (Task task : this.m_project.getTasks()) {
            if (!task.hasChildTasks()) continue;
            if (task.getActualFinish() != null) {
                task.setPercentageComplete(COMPLETE);
                continue;
            }
            childTasks.clear();
            this.gatherChildTasks(childTasks, task);
            double totalPercentComplete = 0.0;
            double totalOverallPercentComplete = 0.0;
            double totalWeight = 0.0;
            double totalActualDuration = 0.0;
            double totalDuration = 0.0;
            for (Task child : childTasks) {
                Duration duration;
                totalPercentComplete += NumberHelper.getDouble(child.getPercentageComplete());
                totalOverallPercentComplete += NumberHelper.getDouble(child.getOverallPercentComplete());
                totalWeight += NumberHelper.getDouble(this.m_weights.get(child));
                Duration actualDuration = child.getActualDuration();
                if (actualDuration != null) {
                    totalActualDuration += actualDuration.getDuration();
                }
                if ((duration = child.getDuration()) == null) continue;
                totalDuration += duration.getDuration();
            }
            if (totalWeight == 0.0) {
                totalWeight = 1.0;
            }
            double overallPercentComplete = totalOverallPercentComplete / totalWeight;
            task.setOverallPercentComplete(overallPercentComplete);
            if (totalDuration == 0.0) {
                if (totalPercentComplete == 0.0) continue;
                double durationPercentComplete = totalPercentComplete / (double)childTasks.size();
                task.setPercentageComplete(durationPercentComplete);
                continue;
            }
            TimeUnit units = task.getDuration().getUnits();
            double durationPercentComplete = totalActualDuration / totalDuration * 100.0;
            double duration = task.getDuration().getDuration();
            double actualDuration = duration * durationPercentComplete / 100.0;
            double remainingDuration = duration - actualDuration;
            task.setPercentageComplete(durationPercentComplete);
            task.setActualDuration(Duration.getInstance(actualDuration, units));
            task.setRemainingDuration(Duration.getInstance(remainingDuration, units));
        }
    }

    private void gatherChildTasks(List<Task> tasks, Task task) {
        if (task.hasChildTasks()) {
            task.getChildTasks().forEach(child -> this.gatherChildTasks(tasks, (Task)child));
        } else {
            tasks.add(task);
        }
    }

    private void updateDates() {
        this.m_project.getChildTasks().forEach(this::updateDates);
    }

    private void updateDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            LocalDateTime actualStartDate = parentTask.getActualStart();
            LocalDateTime actualFinishDate = parentTask.getActualFinish();
            LocalDateTime earlyStartDate = parentTask.getEarlyStart();
            LocalDateTime earlyFinishDate = parentTask.getEarlyFinish();
            LocalDateTime lateStartDate = parentTask.getLateStart();
            LocalDateTime lateFinishDate = parentTask.getLateFinish();
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                actualStartDate = LocalDateTimeHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = LocalDateTimeHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = LocalDateTimeHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = LocalDateTimeHelper.max(earlyFinishDate, task.getEarlyFinish());
                lateStartDate = LocalDateTimeHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = LocalDateTimeHelper.max(lateFinishDate, task.getLateFinish());
                if (task.getActualFinish() == null) continue;
                ++finished;
            }
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
        }
    }

    public void processPredecessors(List<Row> rows) {
        for (Row row : rows) {
            Task endTask;
            Task startTask = this.getTaskByAstaID(row.getInteger("START_TASK"));
            if (startTask == null || (endTask = this.getTaskByAstaID(row.getInteger("END_TASK"))) == null) continue;
            RelationType type = this.getRelationType(row.getInt("LINK_KIND"));
            Duration startLag = row.getDuration("START_LAG_TIME");
            Duration endLag = row.getDuration("END_LAG_TIME");
            double startLagDuration = startLag.getDuration();
            double endLagDuration = endLag.getDuration();
            Duration lag = startLagDuration == 0.0 && endLagDuration == 0.0 ? Duration.getInstance(0, TimeUnit.HOURS) : (startLagDuration != 0.0 && endLagDuration == 0.0 ? startLag : (startLagDuration == 0.0 && endLagDuration != 0.0 ? Duration.getInstance(startLagDuration - endLagDuration, endLag.getUnits()) : Duration.getInstance(startLagDuration - endLagDuration, startLag.getUnits())));
            endTask.addPredecessor(new Relation.Builder().predecessorTask(startTask).type(type).lag(lag).uniqueID(row.getInteger("ID")));
            if (!this.m_deferredConstraintType.contains(endTask.getUniqueID())) continue;
            endTask.setConstraintType(ConstraintType.AS_LATE_AS_POSSIBLE);
            endTask.setConstraintDate(null);
        }
    }

    public void processAssignments(List<Row> allocationRows, List<Row> skillRows) {
        Map<Integer, Row> skillMap = skillRows.stream().collect(Collectors.toMap(t -> t.getInteger("ID"), t -> t));
        for (Row row : allocationRows) {
            Resource resource;
            Row skill;
            Task task = this.getTaskByAstaID(row.getInteger("ALLOCATED_TO"));
            if (task == null || (skill = skillMap.get(row.getInteger("ALLOCATION_OF"))) == null || (resource = this.m_project.getResourceByUniqueID(skill.getInteger("PLAYER"))) == null) continue;
            Double percentComplete = row.getPercent("PERCENT_COMPLETE");
            Duration work = row.getWork("EFFORT");
            double actualWork = work.getDuration() * percentComplete / 100.0;
            double remainingWork = work.getDuration() - actualWork;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setUniqueID(row.getInteger("ID"));
            assignment.setStart(row.getDate("LINKABLE_START"));
            assignment.setFinish(row.getDate("LINKABLE_FINISH"));
            assignment.setUnits(row.getDouble("GIVEN_ALLOCATION") * 100.0);
            assignment.setDelay(row.getDuration("DELAY"));
            assignment.setWork(work);
            assignment.setActualWork(Duration.getInstance(actualWork, work.getUnits()));
            assignment.setRemainingWork(Duration.getInstance(remainingWork, work.getUnits()));
            assignment.setPercentageWorkComplete(percentComplete);
        }
    }

    private RelationType getRelationType(int index) {
        if (index < 0 || index > RELATION_TYPES.length) {
            index = 0;
        }
        return RELATION_TYPES[index];
    }

    private String getInitials(String name) {
        String result = null;
        if (name != null && !name.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(name.charAt(0));
            int index = 1;
            while ((index = name.indexOf(32, index)) != -1) {
                if (++index < name.length() && name.charAt(index) != ' ') {
                    sb.append(name.charAt(index));
                }
                ++index;
            }
            result = sb.toString();
        }
        return result;
    }

    private void deriveProjectCalendar() {
        HashMap<ProjectCalendar, Integer> map = new HashMap<ProjectCalendar, Integer>();
        for (Task task : this.m_project.getTasks()) {
            ProjectCalendar calendar = task.getCalendar();
            map.compute(calendar, (k, v) -> v == null ? Integer.valueOf(1) : Integer.valueOf(v + 1));
        }
        int maxCount = 0;
        ProjectCalendar defaultCalendar = null;
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= maxCount) continue;
            maxCount = (Integer)entry.getValue();
            defaultCalendar = (ProjectCalendar)entry.getKey();
        }
        if (defaultCalendar == null) {
            defaultCalendar = this.m_project.getCalendars().findOrCreateDefaultCalendar();
        } else {
            for (Task task : this.m_project.getTasks()) {
                if (task.getCalendar() != defaultCalendar) continue;
                task.setCalendar(null);
            }
        }
        this.m_project.setDefaultCalendar(defaultCalendar);
    }

    private void processConstraints(Row row, Task task) {
        ConstraintType constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
        LocalDateTime constraintDate = null;
        switch (row.getInt("CONSTRAINT_FLAG")) {
            case 0: {
                if (row.getInt("PLACEMENT") == 1) {
                    this.m_deferredConstraintType.add(task.getUniqueID());
                    constraintType = ConstraintType.START_NO_EARLIER_THAN;
                    constraintDate = row.getDate("START_CONSTRAINT_DATE");
                    break;
                }
                constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
                break;
            }
            case 1: {
                constraintType = ConstraintType.MUST_START_ON;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 2: {
                constraintType = ConstraintType.START_NO_LATER_THAN;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 3: {
                constraintType = ConstraintType.START_NO_EARLIER_THAN;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 4: {
                constraintType = ConstraintType.MUST_FINISH_ON;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 5: {
                constraintType = ConstraintType.FINISH_NO_LATER_THAN;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 6: {
                constraintType = ConstraintType.FINISH_NO_EARLIER_THAN;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 8: {
                task.setDeadline(row.getDate("END_CONSTRAINT_DATE"));
            }
        }
        task.setConstraintType(constraintType);
        task.setConstraintDate(constraintDate);
    }

    public Map<Integer, DayType> createExceptionTypeMap(List<Row> rows) {
        HashMap<Integer, DayType> map = new HashMap<Integer, DayType>();
        for (Row row : rows) {
            DayType result;
            Integer id = row.getInteger("ID");
            switch (row.getInt("UNIQUE_BIT_FIELD")) {
                case 8: 
                case 32: 
                case 128: {
                    result = DayType.WORKING;
                    break;
                }
                default: {
                    result = DayType.NON_WORKING;
                }
            }
            map.put(id, result);
        }
        return map;
    }

    public Map<Integer, Row> createWorkPatternMap(List<Row> rows) {
        HashMap<Integer, Row> map = new HashMap<Integer, Row>();
        for (Row row : rows) {
            map.put(row.getInteger("ID"), row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createWorkPatternAssignmentMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("WORK_PATTERN_ASSIGNMENTID");
            List list = map.computeIfAbsent(calendarID, k -> new ArrayList());
            list.add(row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createExceptionAssignmentMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("EXCEPTION_ASSIGNMENTID");
            List list = map.computeIfAbsent(calendarID, k -> new ArrayList());
            list.add(row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createTimeEntryMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer workPatternID = row.getInteger("TIME_ENTRYID");
            List list = map.computeIfAbsent(workPatternID, k -> new ArrayList());
            list.add(row);
        }
        return map;
    }

    public void processCalendar(Row calendarRow, Map<Integer, Row> workPatternMap, Map<Integer, List<Row>> workPatternAssignmentMap, Map<Integer, List<Row>> exceptionAssignmentMap, Map<Integer, List<Row>> timeEntryMap, Map<Integer, DayType> exceptionTypeMap) {
        List<Row> rows;
        boolean defaultWeekSet;
        ProjectCalendar calendar = this.m_project.addCalendar();
        Integer dominantWorkPatternID = calendarRow.getInteger("DOMINANT_WORK_PATTERN");
        calendar.setUniqueID(calendarRow.getInteger("ID"));
        calendar.setName(calendarRow.getString("NAME"));
        boolean bl = defaultWeekSet = workPatternMap.get(dominantWorkPatternID) != null;
        if (defaultWeekSet) {
            this.processWorkPattern(calendar, dominantWorkPatternID, workPatternMap, timeEntryMap, exceptionTypeMap);
        }
        if ((rows = workPatternAssignmentMap.get(calendar.getUniqueID())) != null) {
            for (Row row : rows) {
                ProjectCalendarDays week;
                Integer workPatternID = row.getInteger("WORK_PATTERN");
                if (workPatternID.equals(dominantWorkPatternID)) continue;
                if (defaultWeekSet) {
                    ProjectCalendarWeek newWeek = calendar.addWorkWeek();
                    newWeek.setDateRange(new LocalDateRange(LocalDateHelper.getLocalDate(row.getDate("START_DATE")), LocalDateHelper.getLocalDate(row.getDate("END_DATE"))));
                    week = newWeek;
                } else {
                    week = calendar;
                    defaultWeekSet = true;
                }
                this.processWorkPattern(week, workPatternID, workPatternMap, timeEntryMap, exceptionTypeMap);
            }
        }
        if ((rows = exceptionAssignmentMap.get(calendar.getUniqueID())) != null) {
            ArrayList<LocalDateRange> ranges = new ArrayList<LocalDateRange>();
            for (Row row : rows) {
                LocalDateTime startDate = row.getDate("START_DATE");
                LocalDateTime endDate = row.getDate("END_DATE");
                if (endDate.equals(LocalDateTimeHelper.getDayStartDate(endDate))) {
                    endDate = endDate.plusDays(-1L);
                }
                ranges.add(new LocalDateRange(LocalDateHelper.getLocalDate(startDate), LocalDateHelper.getLocalDate(endDate)));
            }
            ranges.stream().distinct().forEach(r -> calendar.addCalendarException(r.getStart(), r.getEnd()));
        }
        for (DayOfWeek day : DayOfWeek.values()) {
            DayType dayType;
            if (calendar.getCalendarHours(day) != null || (dayType = calendar.getCalendarDayType(day)) == DayType.DEFAULT) continue;
            ProjectCalendarHours hours = calendar.addCalendarHours(day);
            if (dayType != DayType.WORKING) continue;
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_MORNING);
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_AFTERNOON);
        }
        calendar.setParent(this.m_project.getCalendarByUniqueID(calendarRow.getInteger("CALENDAR")));
        this.m_eventManager.fireCalendarReadEvent(calendar);
    }

    private void processWorkPattern(ProjectCalendarDays week, Integer workPatternID, Map<Integer, Row> workPatternMap, Map<Integer, List<Row>> timeEntryMap, Map<Integer, DayType> exceptionTypeMap) {
        List<Row> timeEntryRows;
        Row workPatternRow = workPatternMap.get(workPatternID);
        if (workPatternRow == null) {
            return;
        }
        if (!(week instanceof ProjectCalendar)) {
            week.setName(workPatternRow.getString("NAME"));
        }
        if ((timeEntryRows = timeEntryMap.get(workPatternID)) == null) {
            return;
        }
        DayOfWeek currentDay = DayOfWeek.SATURDAY;
        Arrays.stream(DayOfWeek.values()).forEach(d -> week.setCalendarDayType((DayOfWeek)d, DayType.NON_WORKING));
        ProjectCalendarHours hours = null;
        for (Row row : timeEntryRows) {
            LocalTime startTime = LocalTimeHelper.getLocalTime(row.getDate("START_TIME"));
            LocalTime endTime = LocalTimeHelper.getLocalTime(row.getDate("END_TIME"));
            if (startTime == null) {
                startTime = LocalTime.MIDNIGHT;
            }
            if (endTime == null) {
                endTime = LocalTime.MIDNIGHT;
            }
            if (startTime == LocalTime.MIDNIGHT) {
                currentDay = currentDay.plus(1L);
                hours = week.addCalendarHours(currentDay);
            }
            DayType type = exceptionTypeMap.get(row.getInteger("EXCEPTION"));
            if (hours == null || type != DayType.WORKING) continue;
            hours.add(new LocalTimeRange(startTime, endTime));
            week.setCalendarDayType(currentDay, DayType.WORKING);
        }
    }

    private String getNotes(Row row) {
        String notes = row.getString("NOTES");
        if (notes != null) {
            if (notes.isEmpty()) {
                notes = null;
            } else if (notes.contains(LINE_BREAK)) {
                notes = notes.replace(LINE_BREAK, "\n");
            }
        }
        return notes;
    }

    public void processUserDefinedFields(List<Row> definitions, List<Row> data) {
        HashMap<Integer, ObjectType> objectTypeMap = new HashMap<Integer, ObjectType>();
        HashMap<Integer, FieldType> fieldMap = new HashMap<Integer, FieldType>();
        this.processUserDefinedFieldDefinitions(definitions, objectTypeMap, fieldMap);
        this.processUserDefinedFieldData(data, objectTypeMap, fieldMap);
    }

    private void processUserDefinedFieldDefinitions(List<Row> definitions, Map<Integer, ObjectType> objectTypeMap, Map<Integer, FieldType> fieldMap) {
        UserDefinedFieldContainer userDefinedFields = this.m_project.getUserDefinedFields();
        CustomFieldContainer customFields = this.m_project.getCustomFields();
        for (Row row : definitions) {
            DataType dataType;
            FieldTypeClass fieldTypeClass;
            ObjectType objectType = ObjectType.getInstance(row.getInteger("OBJ_TYPE"));
            if (objectType == null || (fieldTypeClass = this.getFieldTypeClass(objectType)) == null || (dataType = DATA_TYPE_MAP.get(row.getInteger("DATA_TYPE"))) == null) continue;
            UserDefinedField field = new UserDefinedField.Builder(this.m_project).uniqueID(row.getInteger("UDF_ID")).externalName(row.getString("UDF_NAME")).fieldTypeClass(fieldTypeClass).dataType(dataType).build();
            userDefinedFields.add(field);
            customFields.add(field).setAlias(field.getName());
            objectTypeMap.put(field.getUniqueID(), objectType);
            fieldMap.put(field.getUniqueID(), field);
        }
    }

    private FieldTypeClass getFieldTypeClass(ObjectType objectType) {
        FieldTypeClass fieldTypeClass = null;
        switch (objectType) {
            case BAR_OBJECT_TYPE: 
            case TASK_OBJECT_TYPE: 
            case MILESTONE_OBJECT_TYPE: {
                fieldTypeClass = FieldTypeClass.TASK;
                break;
            }
            case PERMANENT_RESOURCE_OBJECT_TYPE: 
            case CONSUMABLE_RESOURCE_OBJECT_TYPE: {
                fieldTypeClass = FieldTypeClass.RESOURCE;
                break;
            }
            case PERMANENT_SCHEDULE_ALLOCATION_OBJECT_TYPE: {
                fieldTypeClass = FieldTypeClass.ASSIGNMENT;
            }
        }
        return fieldTypeClass;
    }

    private void processUserDefinedFieldData(List<Row> data, Map<Integer, ObjectType> objectTypeMap, Map<Integer, FieldType> fieldMap) {
        for (Row row : data) {
            FieldContainer container;
            Function<Integer, FieldContainer> mapper;
            ObjectType objectType;
            Integer id = row.getInteger("UDF_ID");
            FieldType field = fieldMap.get(id);
            if (field == null || (objectType = objectTypeMap.get(id)) == null || (mapper = this.getFieldContainerMapper(objectType)) == null || (container = mapper.apply(row.getInteger("OBJ_ID"))) == null) continue;
            container.set(field, this.getUserDefinedFieldValue(field.getDataType(), row));
        }
    }

    private Function<Integer, FieldContainer> getFieldContainerMapper(ObjectType objectType) {
        Function<Integer, FieldContainer> mapper = null;
        switch (objectType) {
            case BAR_OBJECT_TYPE: {
                mapper = this.m_barMap::get;
                break;
            }
            case TASK_OBJECT_TYPE: {
                mapper = this.m_taskMap::get;
                break;
            }
            case MILESTONE_OBJECT_TYPE: {
                mapper = this.m_milestoneMap::get;
                break;
            }
            case PERMANENT_RESOURCE_OBJECT_TYPE: 
            case CONSUMABLE_RESOURCE_OBJECT_TYPE: {
                mapper = this.m_project::getResourceByUniqueID;
                break;
            }
            case PERMANENT_SCHEDULE_ALLOCATION_OBJECT_TYPE: {
                mapper = i -> (ResourceAssignment)this.m_project.getResourceAssignments().getByUniqueID((Integer)i);
            }
        }
        return mapper;
    }

    private Object getUserDefinedFieldValue(DataType type, Row row) {
        Object value;
        switch (type) {
            case BOOLEAN: {
                value = this.getUserDefinedFieldBoolean(row);
                break;
            }
            case INTEGER: {
                value = this.getUserDefinedFieldInteger(row);
                break;
            }
            case NUMERIC: {
                value = this.getUserDefinedFieldDouble(row);
                break;
            }
            case DATE: {
                value = this.getUserDefinedFieldDate(row);
                break;
            }
            case DURATION: {
                value = this.getUserDefinedFieldDuration(row);
                break;
            }
            default: {
                value = this.getUserDefinedFieldString(row);
            }
        }
        return value;
    }

    private Integer getUserDefinedFieldInteger(Row row) {
        Integer result;
        Object value = row.getObject("DATA_AS_NUMBER");
        if (value instanceof Number) {
            result = ((Number)value).intValue();
        } else if (value instanceof String) {
            try {
                result = Integer.valueOf((String)value);
            }
            catch (NumberFormatException ex) {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    private Double getUserDefinedFieldDouble(Row row) {
        Double result;
        Object value = row.getObject("DATA_AS_NUMBER");
        if (value instanceof Number) {
            result = ((Number)value).doubleValue();
        } else if (value instanceof String) {
            try {
                result = Double.valueOf((String)value);
            }
            catch (NumberFormatException ex) {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    private Boolean getUserDefinedFieldBoolean(Row row) {
        Integer result = this.getUserDefinedFieldInteger(row);
        return result != null && result == 1;
    }

    private LocalDateTime getUserDefinedFieldDate(Row row) {
        Object value = row.getObject("DATA_AS_DATE");
        if (!(value instanceof LocalDateTime)) {
            value = null;
        }
        return (LocalDateTime)value;
    }

    private Duration getUserDefinedFieldDuration(Row row) {
        return Duration.getInstance(NumberHelper.getDouble(this.getUserDefinedFieldDouble(row)), TimeUnit.HOURS);
    }

    private String getUserDefinedFieldString(Row row) {
        Object value = row.getObject("DATA_AS_NOTE");
        return value == null ? null : value.toString();
    }

    public void processCodeLibraries(List<Row> types, List<Row> typeValues, List<Row> assignments) {
        ActivityCodeContainer container = this.m_project.getActivityCodes();
        HashMap<Integer, ActivityCode> codeMap = new HashMap<Integer, ActivityCode>();
        HashMap<Integer, ActivityCodeValue> valueMap = new HashMap<Integer, ActivityCodeValue>();
        for (Row row : types) {
            ActivityCode code = new ActivityCode.Builder(this.m_project).uniqueID(row.getInteger("ID")).sequenceNumber(codeMap.size() + 1).name(row.getString("NAME")).build();
            container.add(code);
            codeMap.put(code.getUniqueID(), code);
        }
        typeValues = HierarchyHelper.sortHierarchy(typeValues, r -> r.getInteger("ID"), r -> r.getInteger("CODE_LIBRARY_ENTRY"), Comparator.comparing(r -> r.getString("SHORT_NAME")));
        HashMap<ActivityCode, ObjectSequence> sequences = new HashMap<ActivityCode, ObjectSequence>();
        for (Row row : typeValues) {
            ActivityCode code = (ActivityCode)codeMap.get(row.getInteger("CODE_LIBRARY"));
            if (code == null) continue;
            Integer id = row.getInteger("ID");
            String name = row.getString("SHORT_NAME");
            String description = row.getString("NAME");
            if (name == null || name.isEmpty()) {
                name = description;
            }
            ObjectSequence sequence = sequences.computeIfAbsent(code, x -> new ObjectSequence(1));
            ActivityCodeValue value = new ActivityCodeValue.Builder(this.m_project).activityCode(code).uniqueID(id).sequenceNumber(sequence.getNext()).name(name).description(description).parentValue((ActivityCodeValue)valueMap.get(row.getInteger("CODE_LIBRARY_ENTRY"))).build();
            code.addValue(value);
            valueMap.put(value.getUniqueID(), value);
        }
        for (Row row : assignments) {
            Task task;
            ActivityCodeValue value = (ActivityCodeValue)valueMap.get(row.getInteger("ASSIGNED_TO"));
            if (value == null || (task = this.getTaskByAstaID(row.getInteger("CODES"))) == null) continue;
            task.addActivityCodeValue(value);
        }
    }

    private Task getTaskByAstaID(Integer id) {
        Task task = this.m_taskMap.get(id);
        if (task != null) {
            return task;
        }
        task = this.m_milestoneMap.get(id);
        if (task != null) {
            return task;
        }
        task = this.m_barMap.get(id);
        if (task != null) {
            return task;
        }
        task = this.m_expandedTaskMap.get(id);
        if (task != null) {
            return task;
        }
        return this.m_completedSectionMap.get(id);
    }

    private boolean timeUnitIsElapsed(int timeUnit) {
        return timeUnit >= 10 && timeUnit <= 18;
    }

    static {
        DATA_TYPE_MAP.put(0, DataType.BOOLEAN);
        DATA_TYPE_MAP.put(6, DataType.INTEGER);
        DATA_TYPE_MAP.put(8, DataType.NUMERIC);
        DATA_TYPE_MAP.put(9, DataType.STRING);
        DATA_TYPE_MAP.put(13, DataType.DATE);
        DATA_TYPE_MAP.put(15, DataType.DURATION);
        DATA_TYPE_MAP.put(24, DataType.STRING);
    }
}

