/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.asta;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mpxj.DayType;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.asta.AbstractFileFormat;
import org.mpxj.asta.AstaReader;
import org.mpxj.asta.FileFormat10008;
import org.mpxj.asta.FileFormat11004;
import org.mpxj.asta.FileFormat12002;
import org.mpxj.asta.FileFormat12005;
import org.mpxj.asta.FileFormat13001;
import org.mpxj.asta.FileFormat13004;
import org.mpxj.asta.FileFormat8020;
import org.mpxj.asta.FileFormat9006;
import org.mpxj.asta.Row;
import org.mpxj.asta.RowComparator;
import org.mpxj.asta.RowHeader;
import org.mpxj.asta.TableDefinition;
import org.mpxj.asta.TextFileRow;
import org.mpxj.common.CharsetHelper;
import org.mpxj.common.HierarchyHelper;
import org.mpxj.common.ReaderTokenizer;
import org.mpxj.reader.AbstractProjectStreamReader;

public final class AstaTextFileReader
extends AbstractProjectStreamReader {
    private Integer m_fileVersion;
    private AstaReader m_reader;
    private Map<String, List<Row>> m_tables;
    private Map<Integer, TableDefinition> m_tableDefinitions;
    private boolean m_epochDateFormat;
    private static final char DELIMITER = ',';
    private static final RowComparator PERMANENT_RESOURCE_COMPARATOR = new RowComparator("ID");
    private static final RowComparator CONSUMABLE_RESOURCE_COMPARATOR = new RowComparator("ID");
    private static final RowComparator LINK_COMPARATOR = new RowComparator("ID");
    private static final RowComparator ALLOCATION_COMPARATOR = new RowComparator("ID");
    private static final Map<Integer, Class<? extends AbstractFileFormat>> FILE_VERSION_MAP = new HashMap<Integer, Class<? extends AbstractFileFormat>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            this.m_reader = new AstaReader();
            ProjectFile project = this.m_reader.getProject();
            this.addListenersToProject(project);
            this.m_tables = new HashMap<String, List<Row>>();
            this.processFile(inputStream);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            project.readComplete();
            ProjectFile projectFile = project;
            return projectFile;
        }
        finally {
            this.m_reader = null;
        }
    }

    private void processFile(InputStream is) throws MPXJException {
        try {
            InputStreamReader reader = new InputStreamReader(is, CharsetHelper.UTF8);
            ReaderTokenizer tk = new ReaderTokenizer(reader){

                @Override
                protected boolean startQuotedIsValid(StringBuilder buffer) {
                    return buffer.length() == 1 && buffer.charAt(0) == '<';
                }
            };
            tk.setDelimiter(',');
            ArrayList<String> columns = new ArrayList<String>();
            String nextTokenPrefix = null;
            while (tk.getType() != -1) {
                columns.clear();
                TableDefinition table = null;
                while (tk.nextToken() == -3) {
                    String token = tk.getToken();
                    if (columns.isEmpty()) {
                        if (token.charAt(0) == '#') {
                            int index = token.lastIndexOf(58);
                            if (index != -1) {
                                String headerToken;
                                if (token.endsWith("-") || token.endsWith("=")) {
                                    headerToken = token;
                                    token = null;
                                } else {
                                    headerToken = token.substring(0, index);
                                    token = token.substring(index + 1);
                                }
                                RowHeader header = new RowHeader(headerToken);
                                table = this.m_tableDefinitions.get(header.getType());
                                columns.add(header.getID());
                            }
                        } else if (token.charAt(0) == '\u0000') {
                            this.processFileType(token);
                        }
                    }
                    if (table == null || token == null) continue;
                    if (token.startsWith("<\"") && !token.endsWith("\">")) {
                        nextTokenPrefix = token;
                        continue;
                    }
                    if (nextTokenPrefix != null) {
                        token = nextTokenPrefix + ',' + token;
                        nextTokenPrefix = null;
                    }
                    columns.add(token);
                }
                if (table == null || columns.size() <= 1) continue;
                TextFileRow row = new TextFileRow(table, columns, this.m_epochDateFormat);
                List rows = this.m_tables.computeIfAbsent(table.getName(), k -> new ArrayList());
                rows.add(row);
            }
        }
        catch (Exception ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    private void processFileType(String token) throws MPXJException {
        this.m_fileVersion = Integer.valueOf(token.substring(2).split(" ")[0]);
        Class<? extends AbstractFileFormat> fileFormatClass = FILE_VERSION_MAP.get(this.m_fileVersion);
        if (fileFormatClass == null) {
            throw new MPXJException("Unsupported PP file format version " + this.m_fileVersion);
        }
        try {
            AbstractFileFormat format = fileFormatClass.newInstance();
            this.m_tableDefinitions = format.tableDefinitions();
            this.m_epochDateFormat = format.epochDateFormat();
        }
        catch (Exception ex) {
            throw new MPXJException("Failed to configure file format", ex);
        }
    }

    private void processProjectProperties() {
        List<Row> rows = this.getTable("PROJECT_SUMMARY");
        if (!rows.isEmpty()) {
            this.m_reader.processProjectProperties(this.m_fileVersion, rows.get(0), null, null);
        }
    }

    private void processCalendars() {
        List<Row> rows = this.getTable("EXCEPTIONN");
        Map<Integer, DayType> exceptionMap = this.m_reader.createExceptionTypeMap(rows);
        rows = this.getTable("WORK_PATTERN");
        Map<Integer, Row> workPatternMap = this.m_reader.createWorkPatternMap(rows);
        rows = new ArrayList<Row>();
        Map<Integer, List<Row>> workPatternAssignmentMap = this.m_reader.createWorkPatternAssignmentMap(rows);
        rows = this.getTable("EXCEPTION_ASSIGNMENT");
        Map<Integer, List<Row>> exceptionAssignmentMap = this.m_reader.createExceptionAssignmentMap(rows);
        rows = this.getTable("TIME_ENTRY");
        Map<Integer, List<Row>> timeEntryMap = this.m_reader.createTimeEntryMap(rows);
        rows = this.getTable("CALENDAR");
        rows = HierarchyHelper.sortHierarchy(rows, r -> r.getInteger("ID"), r -> r.getInteger("CALENDAR"));
        for (Row row : rows) {
            this.m_reader.processCalendar(row, workPatternMap, workPatternAssignmentMap, exceptionAssignmentMap, timeEntryMap, exceptionMap);
        }
    }

    private void processResources() {
        List<Row> permanentRows = this.getTable("PERMANENT_RESOURCE");
        List<Row> consumableRows = this.getTable("CONSUMABLE_RESOURCE");
        permanentRows.sort(PERMANENT_RESOURCE_COMPARATOR);
        consumableRows.sort(CONSUMABLE_RESOURCE_COMPARATOR);
        this.m_reader.processResources(permanentRows, consumableRows);
    }

    private void processTasks() {
        List<Row> bars = this.getTable("BAR");
        List<Row> expandedTasks = this.getTable("EXPANDED_TASK");
        List<Row> tasks = this.getTable("TASK");
        List<Row> milestones = this.getTable("MILESTONE");
        List<Row> hammocks = this.getTable("HAMMOCK_TASK");
        List<Row> completedSections = this.getTable("TASK_COMPLETED_SECTION");
        this.m_reader.processTasks(bars, expandedTasks, tasks, milestones, hammocks, completedSections);
    }

    private void processPredecessors() {
        List<Row> rows = this.getTable("LINK");
        rows.sort(LINK_COMPARATOR);
        this.m_reader.processPredecessors(rows);
    }

    private void processAssignments() {
        List<Row> allocationRows = this.getTable("PERMANENT_SCHEDUL_ALLOCATION");
        List<Row> skillRows = this.getTable("PERM_RESOURCE_SKILL");
        allocationRows.sort(ALLOCATION_COMPARATOR);
        this.m_reader.processAssignments(allocationRows, skillRows);
    }

    private List<Row> getTable(String name) {
        return this.m_tables.getOrDefault(name, Collections.emptyList());
    }

    static {
        FILE_VERSION_MAP.put(8020, FileFormat8020.class);
        FILE_VERSION_MAP.put(9006, FileFormat9006.class);
        FILE_VERSION_MAP.put(10008, FileFormat10008.class);
        FILE_VERSION_MAP.put(11004, FileFormat11004.class);
        FILE_VERSION_MAP.put(12002, FileFormat12002.class);
        FILE_VERSION_MAP.put(12005, FileFormat12005.class);
        FILE_VERSION_MAP.put(13001, FileFormat13001.class);
        FILE_VERSION_MAP.put(13004, FileFormat13004.class);
    }
}

