/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.asta;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.mpxj.common.LocalDateTimeHelper;

final class DatatypeConverter {
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd[ HHmmss][ Hmmss][ 0]");
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HHmmss");
    private static final ThreadLocal<DecimalFormat> DOUBLE_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat("#.#E0"));
    private static final LocalDateTime JAVA_EPOCH = LocalDateTime.of(1900, 1, 1, 0, 0);
    private static final long ASTA_EPOCH = 2415021L;

    DatatypeConverter() {
    }

    public static String parseString(String value) {
        if (value != null) {
            if (!value.isEmpty() && value.charAt(0) == '<') {
                value = value.substring(1, value.length() - 1);
            }
            if (!value.isEmpty() && value.charAt(0) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
        }
        return value;
    }

    public static Number parseDouble(String value) throws ParseException {
        Number result = null;
        if ((value = DatatypeConverter.parseString(value)) != null && !value.isEmpty() && !value.equals("-1 -1")) {
            int index = value.indexOf("E+");
            if (index != -1) {
                value = value.substring(0, index) + 'E' + value.substring(index + 2);
            }
            result = value.indexOf(69) != -1 ? (Number)DOUBLE_FORMAT.get().parse(value) : (Number)Double.valueOf(value);
        }
        return result;
    }

    public static Boolean parseBoolean(String value) throws ParseException {
        Boolean result = null;
        Integer number = DatatypeConverter.parseInteger(value);
        if (number != null) {
            result = number == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return result;
    }

    public static Integer parseInteger(String value) throws ParseException {
        Integer result = null;
        if (!value.isEmpty() && value.indexOf(32) == -1) {
            if (value.indexOf(46) == -1) {
                result = Integer.valueOf(value);
            } else {
                Number n = DatatypeConverter.parseDouble(value);
                result = n.intValue();
            }
        }
        return result;
    }

    public static LocalDateTime parseEpochTimestamp(String value) {
        LocalDateTime result = null;
        if (!value.isEmpty() && !value.equals("-1 -1")) {
            int index = value.indexOf(32);
            if (index == -1) {
                if (value.length() < 6) {
                    value = "000000" + value;
                    value = value.substring(value.length() - 6);
                }
                int hours = Integer.parseInt(value.substring(0, 2));
                int minutes = Integer.parseInt(value.substring(2, 4));
                int seconds = Integer.parseInt(value.substring(4));
                result = JAVA_EPOCH.plusHours(hours).plusMinutes(minutes).plusSeconds(seconds);
            } else {
                long astaDays = Long.parseLong(value.substring(0, index));
                int astaSeconds = Integer.parseInt(value.substring(index + 1));
                result = JAVA_EPOCH.plusDays(astaDays - 2415021L).plusSeconds(astaSeconds);
            }
        }
        return result;
    }

    public static LocalDateTime parseBasicTimestamp(String value) {
        if (value.isEmpty() || value.equals("-1 -1") || value.equals("0")) {
            return null;
        }
        return LocalDateTimeHelper.parseBest(TIMESTAMP_FORMAT, value);
    }

    public static LocalDateTime parseBasicTime(String value) {
        LocalDateTime result = null;
        if (!value.isEmpty() && !value.equals("0")) {
            value = "000000" + value;
            value = value.substring(value.length() - 6);
            result = LocalDateTime.of(LocalDate.MIN, LocalTime.parse(value, TIME_FORMAT));
        }
        return result;
    }
}

