/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.asta;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mpxj.Duration;
import org.mpxj.TimeUnit;
import org.mpxj.asta.Row;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.NumberHelper;

class MapRow
implements Row {
    protected final Map<String, Object> m_map;
    private final List<Row> m_childRows = new ArrayList<Row>();

    public MapRow(Map<String, Object> map) {
        this.m_map = map;
    }

    @Override
    public String getString(String name) {
        Object value = this.getObject(name);
        String result = value instanceof byte[] ? new String((byte[])value) : (String)value;
        return result;
    }

    @Override
    public Integer getInteger(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Integer)) {
            result = ((Number)result).intValue();
        }
        return (Integer)result;
    }

    @Override
    public Double getDouble(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Double)) {
            result = ((Number)result).doubleValue();
        }
        return (Double)result;
    }

    @Override
    public Double getPercent(String name) {
        Object result = this.getObject(name);
        if (result != null) {
            result = (double)Math.round(((Number)result).doubleValue() * 100.0) / 100.0;
        }
        return (Double)result;
    }

    @Override
    public Double getCurrency(String name) {
        Double value = this.getDouble(name);
        if (value != null) {
            value = value / 100.0;
        }
        return value;
    }

    @Override
    public boolean getBoolean(String name) {
        boolean result = false;
        Object value = this.getObject(name);
        if (value != null) {
            result = value instanceof Boolean ? BooleanHelper.getBoolean((Boolean)value) : ((Number)value).intValue() == 1;
        }
        return result;
    }

    @Override
    public int getInt(String name) {
        return NumberHelper.getInt((Number)this.getObject(name));
    }

    @Override
    public LocalDateTime getDate(String name) {
        return (LocalDateTime)this.getObject(name);
    }

    @Override
    public Duration getDuration(String name) {
        return Duration.getInstance(NumberHelper.getDouble(this.getDouble(name)), TimeUnit.HOURS);
    }

    @Override
    public Duration getWork(String name) {
        return Duration.getInstance(NumberHelper.getDouble(this.getDouble(name)) / 3600.0, TimeUnit.HOURS);
    }

    @Override
    public Object getObject(String name) {
        return this.m_map.get(name);
    }

    public Map<String, Object> getMap() {
        return this.m_map;
    }

    @Override
    public void addChild(Row row) {
        this.m_childRows.add(row);
    }

    @Override
    public List<Row> getChildRows() {
        return this.m_childRows;
    }

    @Override
    public void merge(Row row, String prefix) {
        Map<String, Object> otherMap = ((MapRow)row).m_map;
        for (Map.Entry<String, Object> entry : otherMap.entrySet()) {
            this.m_map.put(prefix + entry.getKey(), entry.getValue());
        }
    }
}

