/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.util.Locale;
import org.mpxj.AssignmentField;
import org.mpxj.ConstraintField;
import org.mpxj.DataType;
import org.mpxj.Duration;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.Priority;
import org.mpxj.ProjectField;
import org.mpxj.ProjectFile;
import org.mpxj.Rate;
import org.mpxj.ResourceField;
import org.mpxj.TaskField;
import org.mpxj.common.MPPAssignmentField;
import org.mpxj.common.MPPConstraintField;
import org.mpxj.common.MPPProjectField;
import org.mpxj.common.MPPResourceField;
import org.mpxj.common.MPPTaskField;

public final class FieldTypeHelper {
    public static int getFieldID(FieldType type) {
        int result;
        if (type == null) {
            result = -1;
        } else {
            switch (type.getFieldTypeClass()) {
                case TASK: {
                    result = 0xB400000 | MPPTaskField.getID(type);
                    break;
                }
                case RESOURCE: {
                    result = 0xC400000 | MPPResourceField.getID(type);
                    break;
                }
                case ASSIGNMENT: {
                    result = 0xF400000 | MPPAssignmentField.getID(type);
                    break;
                }
                case PROJECT: {
                    result = 0xB600000 | MPPProjectField.getID(type);
                    break;
                }
                default: {
                    result = -1;
                }
            }
        }
        return result;
    }

    public static final FieldType getInstance(ProjectFile project, int fieldID) {
        return FieldTypeHelper.getInstance(project, fieldID, DataType.CUSTOM);
    }

    public static final FieldType getInstance(ProjectFile project, int fieldID, DataType customFieldDataType) {
        FieldType result;
        if (fieldID == -1) {
            return null;
        }
        int prefix = fieldID & 0xFFFF0000;
        int index = fieldID & 0xFFFF;
        switch (prefix) {
            case 0xB400000: {
                result = MPPTaskField.getInstance(project, index, customFieldDataType);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(TaskField.class, index);
                break;
            }
            case 0xC400000: {
                result = MPPResourceField.getInstance(project, index, customFieldDataType);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(ResourceField.class, index);
                break;
            }
            case 0xF400000: {
                result = MPPAssignmentField.getInstance(project, index, customFieldDataType);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(AssignmentField.class, index);
                break;
            }
            case 0xD400000: {
                result = MPPConstraintField.getInstance(index);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(ConstraintField.class, index);
                break;
            }
            case 0xB600000: {
                result = MPPProjectField.getInstance(project, index, customFieldDataType);
                if (result != null) break;
                result = FieldTypeHelper.getPlaceholder(ProjectField.class, index);
                break;
            }
            default: {
                result = FieldTypeHelper.getPlaceholder(null, index);
            }
        }
        return result;
    }

    private static FieldType getPlaceholder(final Class<?> type, final int fieldID) {
        return new FieldType(){

            @Override
            public FieldTypeClass getFieldTypeClass() {
                return FieldTypeClass.UNKNOWN;
            }

            @Override
            public String name() {
                return "UNKNOWN";
            }

            @Override
            public int getValue() {
                return fieldID;
            }

            @Override
            public String getName() {
                return "Unknown" + (type == null ? "" : " " + type.getSimpleName() + "(" + fieldID + ")");
            }

            @Override
            public String getName(Locale locale) {
                return this.getName();
            }

            @Override
            public DataType getDataType() {
                return null;
            }

            @Override
            public FieldType getUnitsType() {
                return null;
            }

            public String toString() {
                return this.getName();
            }
        };
    }

    public static FieldType mapTextFields(FieldType field) {
        if (!(field instanceof TaskField)) {
            return field;
        }
        TaskField taskField = (TaskField)field;
        switch (taskField) {
            case START_TEXT: {
                field = TaskField.START;
                break;
            }
            case FINISH_TEXT: {
                field = TaskField.FINISH;
                break;
            }
            case DURATION_TEXT: {
                field = TaskField.DURATION;
                break;
            }
        }
        return field;
    }

    public static final boolean valueIsNotDefault(FieldType type, Object value) {
        boolean result = true;
        if (value == null) {
            result = false;
        } else {
            DataType dataType = type.getDataType();
            switch (dataType) {
                case STRING: 
                case NOTES: {
                    result = !value.toString().isEmpty();
                    break;
                }
                case NUMERIC: 
                case CURRENCY: 
                case PERCENTAGE: 
                case UNITS: 
                case INTEGER: 
                case SHORT: {
                    result = ((Number)value).doubleValue() != 0.0;
                    break;
                }
                case WORK: 
                case DURATION: {
                    if (value instanceof String) {
                        result = !((String)value).isEmpty();
                        break;
                    }
                    result = ((Duration)value).getDuration() != 0.0;
                    break;
                }
                case RATE: {
                    result = ((Rate)value).getAmount() != 0.0;
                    break;
                }
                case BOOLEAN: {
                    result = (Boolean)value;
                    break;
                }
                case PRIORITY: {
                    result = ((Priority)value).getValue() != 500;
                    break;
                }
            }
        }
        return result;
    }
}

