/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public final class FileHelper {
    public static final void delete(File file) throws IOException {
        if (file != null && !file.delete()) {
            throw new IOException("Failed to delete file");
        }
    }

    public static final void deleteQuietly(File file) {
        if (file != null) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                for (File child : children) {
                    FileHelper.deleteQuietly(child);
                }
            }
            file.delete();
        }
    }

    public static final void mkdirs(File file) throws IOException {
        if (file != null && !file.mkdirs()) {
            throw new IOException("Failed to create directories");
        }
    }

    public static final void mkdirsQuietly(File file) {
        if (file != null) {
            file.mkdirs();
        }
    }

    public static final File createTempDir() throws IOException {
        File dir = Files.createTempFile("mpxj", "tmp", new FileAttribute[0]).toFile();
        FileHelper.delete(dir);
        FileHelper.mkdirs(dir);
        return dir;
    }

    public static final void createNewFile(File file) throws IOException {
        if (!file.createNewFile()) {
            throw new IOException("Failed to create new file");
        }
    }
}

