/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.mpxj.common.FileHelper;

public class InputStreamHelper {
    public static File writeStreamToTempFile(InputStream inputStream, String tempFileSuffix) throws IOException {
        File file = Files.createTempFile("mpxj", tempFileSuffix, new FileAttribute[0]).toFile();
        InputStreamHelper.writeInputStreamToOutputStream(inputStream, Files.newOutputStream(file.toPath(), new OpenOption[0]));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        finally {
            outputStream.close();
        }
    }

    public static File writeZipStreamToTempDir(InputStream inputStream) throws IOException {
        File dir;
        block2: {
            dir = FileHelper.createTempDir();
            try {
                InputStreamHelper.processZipStream(dir, inputStream);
            }
            catch (ZipException ex) {
                if (ex.getMessage().equals("only DEFLATED entries can have EXT descriptor")) break block2;
                throw ex;
            }
        }
        return dir;
    }

    public static byte[] readAvailable(InputStream is) throws IOException {
        return InputStreamHelper.read(is, new byte[is.available()]);
    }

    public static byte[] read(InputStream is, int size) throws IOException {
        return InputStreamHelper.read(is, new byte[size]);
    }

    public static byte[] read(InputStream is, byte[] data) throws IOException {
        return InputStreamHelper.read(is, data, data.length);
    }

    public static byte[] read(InputStream is, byte[] data, int size) throws IOException {
        int bytesRead = is.read(data, 0, size);
        if (bytesRead != size) {
            throw new RuntimeException("Unable to read the required number of bytes");
        }
        return data;
    }

    private static void processZipStream(File dir, InputStream inputStream) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(inputStream);
        while ((entry = zip.getNextEntry()) != null) {
            int length;
            File file = new File(dir, entry.getName());
            if (!file.getCanonicalFile().toPath().startsWith(dir.getCanonicalFile().toPath())) {
                throw new IOException("Entry is outside of the target dir: " + entry.getName());
            }
            if (entry.isDirectory()) {
                FileHelper.mkdirsQuietly(file);
                continue;
            }
            File parent = file.getParentFile();
            if (parent != null) {
                FileHelper.mkdirsQuietly(parent);
            }
            FileOutputStream fos = new FileOutputStream(file);
            byte[] bytes = new byte[1024];
            while ((length = zip.read(bytes)) >= 0) {
                fos.write(bytes, 0, length);
            }
            fos.close();
        }
    }

    public static void skip(InputStream stream, long skip) throws IOException {
        long skipped;
        for (long count = skip; count > 0L; count -= skipped) {
            skipped = stream.skip(count);
            if (skipped != 0L) continue;
            throw new IOException("Cannot skip forward within InputStream");
        }
    }
}

