/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.mpxj.Duration;
import org.mpxj.ProjectCalendar;
import org.mpxj.TimeUnit;

public final class LocalDateTimeHelper {
    public static final LocalDateTime START_DATE_NA = LocalDateTime.of(1984, 1, 1, 0, 0);
    public static final LocalDateTime END_DATE_NA = LocalDateTime.of(2049, 12, 31, 23, 59);

    public static LocalDateTime getDayStartDate(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.of(date.toLocalDate(), LocalTime.of(0, 0));
    }

    public static int compare(LocalDateTime startDate, LocalDateTime endDate, LocalDateTime targetDate) {
        int result = 0;
        if (targetDate.isBefore(startDate)) {
            result = -1;
        } else if (targetDate.isAfter(endDate)) {
            result = 1;
        }
        return result;
    }

    public static int compare(LocalDateTime d1, LocalDateTime d2) {
        if (d1 == null || d2 == null) {
            return d1 == d2 ? 0 : (d1 == null ? 1 : -1);
        }
        return d1.compareTo(d2);
    }

    public static LocalDateTime min(LocalDateTime d1, LocalDateTime d2) {
        LocalDateTime result = d1 == null ? d2 : (d2 == null ? d1 : (d1.isBefore(d2) ? d1 : d2));
        return result;
    }

    public static LocalDateTime max(LocalDateTime d1, LocalDateTime d2) {
        LocalDateTime result = d1 == null ? d2 : (d2 == null ? d1 : (d1.isAfter(d2) ? d1 : d2));
        return result;
    }

    public static LocalDateTime parseBest(DateTimeFormatter format, String value) {
        TemporalAccessor parsed = format.parseBest(value, LocalDateTime::from, LocalDate::from);
        if (parsed instanceof LocalDate) {
            return ((LocalDate)parsed).atStartOfDay();
        }
        return (LocalDateTime)parsed;
    }

    public static Duration getVariance(ProjectCalendar calendar, LocalDateTime date1, LocalDateTime date2, TimeUnit format) {
        if (date1 != null && date2 != null && calendar != null) {
            return calendar.getWork(date1, date2, format);
        }
        return Duration.getInstance(0, format);
    }
}

