/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mpxj.AccrueType;
import org.mpxj.Duration;
import org.mpxj.EarnedValueMethod;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.Priority;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.TaskMode;
import org.mpxj.TaskType;
import org.mpxj.TimeUnit;
import org.mpxj.UserDefinedField;

public class PopulatedFields<E extends Enum<E>, T extends FieldContainer> {
    private final Set<FieldType> m_fields;
    private final Collection<T> m_collection;
    private final TimeUnit m_defaultDurationUnits;
    private final TaskType m_defaultTaskType;
    private final EarnedValueMethod m_defaultTaskEarnedValueMethod;
    private final AccrueType m_defaultFixedCostAccrual;

    public PopulatedFields(ProjectFile project, Class<E> fieldEnumType, Collection<UserDefinedField> userDefinedFields, Collection<T> collection) {
        this.m_fields = new HashSet<FieldType>(EnumSet.allOf(fieldEnumType));
        this.m_fields.addAll(userDefinedFields);
        this.m_collection = collection;
        ProjectProperties props = project.getProjectProperties();
        this.m_defaultDurationUnits = props.getDefaultDurationUnits();
        this.m_defaultTaskType = props.getDefaultTaskType();
        this.m_defaultTaskEarnedValueMethod = props.getDefaultTaskEarnedValueMethod();
        this.m_defaultFixedCostAccrual = props.getDefaultFixedCostAccrual();
    }

    public Set<FieldType> getPopulatedFields() {
        HashSet<FieldType> unusedFields = new HashSet<FieldType>(this.m_fields);
        for (FieldContainer item : this.m_collection) {
            unusedFields.removeIf(e -> this.fieldIsPopulated(item, (FieldType)e));
        }
        HashSet<FieldType> usedFields = new HashSet<FieldType>(this.m_fields);
        usedFields.removeAll(unusedFields);
        return usedFields;
    }

    private boolean fieldIsPopulated(FieldContainer item, FieldType type) {
        Object value = item.getCachedValue(type);
        return value != null && this.fieldIsNotDefaultValue(value, type);
    }

    private boolean fieldIsNotDefaultValue(Object value, FieldType type) {
        boolean result;
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)value).isEmpty();
        }
        switch (type.getDataType()) {
            case STRING: 
            case NOTES: {
                result = !value.toString().isEmpty();
                break;
            }
            case NUMERIC: 
            case CURRENCY: 
            case PERCENTAGE: 
            case UNITS: 
            case INTEGER: 
            case SHORT: {
                result = ((Number)value).doubleValue() != 0.0;
                break;
            }
            case WORK: 
            case DURATION: {
                if (value instanceof String) {
                    result = !((String)value).isEmpty();
                    break;
                }
                result = ((Duration)value).getDuration() != 0.0;
                break;
            }
            case RATE: {
                result = ((Rate)value).getAmount() != 0.0;
                break;
            }
            case BOOLEAN: {
                result = (Boolean)value;
                break;
            }
            case PRIORITY: {
                result = ((Priority)value).getValue() != 500;
                break;
            }
            case TIME_UNITS: {
                result = value != this.m_defaultDurationUnits;
                break;
            }
            case TASK_TYPE: {
                result = value != this.m_defaultTaskType;
                break;
            }
            case EARNED_VALUE_METHOD: {
                result = value != this.m_defaultTaskEarnedValueMethod;
                break;
            }
            case ACCRUE: {
                result = value != this.m_defaultFixedCostAccrual;
                break;
            }
            case TASK_MODE: {
                result = value != TaskMode.AUTO_SCHEDULED;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }
}

