/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.DayType;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectCalendarWeek;
import org.mpxj.ProjectFile;
import org.mpxj.Resource;
import org.mpxj.TemporaryCalendar;
import org.mpxj.common.NumberHelper;

public final class ProjectCalendarHelper {
    public static ProjectCalendar createTemporaryFlattenedCalendar(ProjectCalendar calendar) {
        if (!calendar.isDerived()) {
            return calendar;
        }
        TemporaryCalendar newCalendar = new TemporaryCalendar(calendar.getParentFile());
        newCalendar.setName(calendar.getName());
        newCalendar.setUniqueID(calendar.getUniqueID());
        newCalendar.setType(calendar.getType());
        newCalendar.setPersonal(calendar.getPersonal());
        newCalendar.setCalendarMinutesPerDay(calendar.getCalendarMinutesPerDay());
        newCalendar.setCalendarMinutesPerWeek(calendar.getCalendarMinutesPerWeek());
        newCalendar.setCalendarMinutesPerMonth(calendar.getMinutesPerMonth());
        newCalendar.setCalendarMinutesPerYear(calendar.getCalendarMinutesPerYear());
        ProjectCalendarHelper.populateDays(newCalendar, calendar);
        ProjectCalendarHelper.populateWorkingWeeks(newCalendar, calendar);
        ProjectCalendarHelper.mergeExceptions((ProjectCalendar)newCalendar, calendar);
        return newCalendar;
    }

    public static ProjectCalendar createTemporaryDerivedCalendar(ProjectCalendar baseCalendar, Resource resource) {
        ProjectFile file = baseCalendar.getParentFile();
        TemporaryCalendar derivedCalendar = new TemporaryCalendar(file);
        derivedCalendar.setParent(baseCalendar);
        derivedCalendar.setName(resource.getName());
        derivedCalendar.setCalendarDayType(DayOfWeek.SUNDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(DayOfWeek.MONDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(DayOfWeek.TUESDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(DayOfWeek.WEDNESDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(DayOfWeek.THURSDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(DayOfWeek.FRIDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(DayOfWeek.SATURDAY, DayType.DEFAULT);
        if (NumberHelper.getInt(derivedCalendar.getUniqueID()) == 0) {
            derivedCalendar.setUniqueID(file.getUniqueIdObjectSequence(ProjectCalendar.class).getNext());
        }
        return derivedCalendar;
    }

    public static void mergeExceptions(ProjectCalendar target, ProjectCalendar source) {
        ProjectCalendarHelper.mergeExceptions(target, source.getCalendarExceptions());
        ProjectCalendar parent = source.getParent();
        if (parent != null) {
            ProjectCalendarHelper.mergeExceptions(target, parent);
        }
    }

    public static void mergeExceptions(ProjectCalendar target, List<ProjectCalendarException> sourceExceptions) {
        ArrayList<ProjectCalendarException> expandedTargetExceptions = new ArrayList<ProjectCalendarException>(target.getExpandedCalendarExceptions());
        for (ProjectCalendarException sourceException : sourceExceptions) {
            boolean collision = false;
            List<ProjectCalendarException> expandedSourceExceptions = sourceException.getExpandedExceptions();
            for (ProjectCalendarException expandedSourceException : expandedSourceExceptions) {
                collision = expandedTargetExceptions.stream().anyMatch(e -> e.contains(expandedSourceException));
                if (!collision) continue;
                break;
            }
            if (collision) {
                for (ProjectCalendarException expandedSourceException : expandedSourceExceptions) {
                    if (!expandedTargetExceptions.stream().noneMatch(e -> e.contains(expandedSourceException))) continue;
                    ProjectCalendarException newException = target.addCalendarException(expandedSourceException.getFromDate(), expandedSourceException.getToDate());
                    newException.addAll(expandedSourceException);
                }
                continue;
            }
            ProjectCalendarException newException = sourceException.getRecurring() == null ? target.addCalendarException(sourceException.getFromDate(), sourceException.getToDate()) : target.addCalendarException(sourceException.getRecurring());
            newException.addAll(sourceException);
        }
    }

    private static void populateDays(ProjectCalendar target, ProjectCalendar source) {
        for (DayOfWeek day : DayOfWeek.values()) {
            ProjectCalendarHours hours = source.getHours(day);
            ProjectCalendarHours newHours = target.addCalendarHours(day);
            if (hours == null || hours.isEmpty()) {
                target.setCalendarDayType(day, DayType.NON_WORKING);
                continue;
            }
            target.setCalendarDayType(day, DayType.WORKING);
            newHours.addAll(hours);
        }
    }

    private static void populateWorkingWeeks(ProjectCalendar target, ProjectCalendar source) {
        for (ProjectCalendarWeek sourceWeek : source.getWorkWeeks()) {
            ProjectCalendarWeek targetWeek = target.addWorkWeek();
            for (DayOfWeek day : DayOfWeek.values()) {
                targetWeek.setCalendarDayType(day, sourceWeek.getCalendarDayType(day));
                ProjectCalendarHours sourceHours = sourceWeek.getCalendarHours(day);
                if (sourceHours == null) continue;
                ProjectCalendarHours targetHours = targetWeek.addCalendarHours(day);
                targetHours.addAll(sourceHours);
            }
        }
    }
}

