/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.Duration;
import org.mpxj.LocalDateTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ResourceAssignment;
import org.mpxj.Task;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedItem;
import org.mpxj.TimephasedWork;

public final class SplitTaskFactory {
    private SplitTaskFactory() {
    }

    public static void processSplitData(ResourceAssignment assignment, List<TimephasedWork> timephasedComplete, List<TimephasedWork> timephasedPlanned) {
        LocalDateTime splitsComplete = null;
        TimephasedWork lastComplete = null;
        TimephasedWork firstPlanned = null;
        if (!timephasedComplete.isEmpty()) {
            lastComplete = timephasedComplete.get(timephasedComplete.size() - 1);
            splitsComplete = lastComplete.getFinish();
        }
        if (!timephasedPlanned.isEmpty()) {
            firstPlanned = timephasedPlanned.get(0);
        }
        ArrayList<LocalDateTimeRange> splits = new ArrayList<LocalDateTimeRange>();
        TimephasedItem lastAssignment = null;
        LocalDateTimeRange lastRange = null;
        for (TimephasedWork work : timephasedComplete) {
            if (lastAssignment != null && lastRange != null && ((Duration)lastAssignment.getTotalAmount()).getDuration() != 0.0 && ((Duration)work.getTotalAmount()).getDuration() != 0.0) {
                splits.remove(splits.size() - 1);
                lastRange = new LocalDateTimeRange(lastRange.getStart(), work.getFinish());
            } else {
                lastRange = new LocalDateTimeRange(work.getStart(), work.getFinish());
            }
            splits.add(lastRange);
            lastAssignment = work;
        }
        LocalDateTime splitStart = null;
        if (lastComplete != null && firstPlanned != null && ((Duration)lastComplete.getTotalAmount()).getDuration() != 0.0 && ((Duration)firstPlanned.getTotalAmount()).getDuration() != 0.0) {
            ProjectCalendar calendar = assignment.getEffectiveCalendar();
            Duration duration = calendar.getWork(lastComplete.getFinish(), firstPlanned.getStart(), TimeUnit.HOURS);
            if (duration.getDuration() == 0.0) {
                lastRange = (LocalDateTimeRange)splits.remove(splits.size() - 1);
                splitStart = lastRange.getStart();
            } else {
                splits.add(new LocalDateTimeRange(calendar.getNextWorkStart(lastComplete.getFinish()), calendar.getPreviousWorkFinish(firstPlanned.getStart())));
            }
        }
        lastAssignment = null;
        lastRange = null;
        for (TimephasedWork timephasedWork : timephasedPlanned) {
            if (splitStart == null) {
                if (lastAssignment != null && lastRange != null && ((Duration)lastAssignment.getTotalAmount()).getDuration() != 0.0 && ((Duration)timephasedWork.getTotalAmount()).getDuration() != 0.0) {
                    splits.remove(splits.size() - 1);
                    lastRange = new LocalDateTimeRange(lastRange.getStart(), timephasedWork.getFinish());
                } else {
                    lastRange = new LocalDateTimeRange(timephasedWork.getStart(), timephasedWork.getFinish());
                }
            } else {
                lastRange = new LocalDateTimeRange(splitStart, timephasedWork.getFinish());
            }
            splits.add(lastRange);
            splitStart = null;
            lastAssignment = timephasedWork;
        }
        Task task = assignment.getTask();
        if (splits.size() > 2) {
            task.setSplits(splits);
            if (task.getActualFinish() == null) {
                task.setCompleteThrough(splitsComplete);
            }
        } else {
            task.setSplits(null);
            task.setCompleteThrough(null);
        }
    }
}

