/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.io.IOException;

public abstract class Tokenizer {
    public static final int TT_EOL = 10;
    public static final int TT_EOF = -1;
    public static final int TT_WORD = -3;
    private char m_delimiter = (char)44;
    private int m_nextToken;
    private int m_nextCharacter = -1;
    private int m_type;
    private final StringBuilder m_buffer = new StringBuilder();

    protected abstract int read() throws IOException;

    public int nextToken() throws IOException {
        boolean quoted = false;
        int result = this.m_nextToken;
        if (this.m_nextToken != 0) {
            this.m_nextToken = 0;
        }
        this.m_buffer.setLength(0);
        block5: while (result == 0) {
            int c;
            if (this.m_nextCharacter != -1) {
                c = this.m_nextCharacter;
                this.m_nextCharacter = -1;
            } else {
                c = this.read();
            }
            switch (c) {
                case -1: {
                    if (this.m_buffer.length() != 0) {
                        result = -3;
                        this.m_nextToken = -1;
                        continue block5;
                    }
                    result = -1;
                    continue block5;
                }
                case 13: {
                    int length;
                    this.m_nextCharacter = this.read();
                    if (this.m_nextCharacter == 10) {
                        this.m_nextCharacter = -1;
                    }
                    if ((length = this.m_buffer.length()) == 0) {
                        result = 10;
                        continue block5;
                    }
                    result = -3;
                    this.m_nextToken = 10;
                    continue block5;
                }
                case 10: {
                    int length = this.m_buffer.length();
                    if (length == 0) {
                        result = 10;
                        continue block5;
                    }
                    result = -3;
                    this.m_nextToken = 10;
                    continue block5;
                }
            }
            int quote = 34;
            if (c == quote) {
                if (!quoted && this.startQuotedIsValid(this.m_buffer)) {
                    quoted = true;
                    continue;
                }
                if (!quoted) {
                    this.m_buffer.append((char)c);
                    continue;
                }
                this.m_nextCharacter = this.read();
                if (this.m_nextCharacter == quote) {
                    this.m_buffer.append((char)c);
                    this.m_nextCharacter = -1;
                    continue;
                }
                quoted = false;
                continue;
            }
            if (c == this.m_delimiter && !quoted) {
                result = -3;
                continue;
            }
            this.m_buffer.append((char)c);
        }
        this.m_type = result;
        return result;
    }

    protected boolean startQuotedIsValid(StringBuilder buffer) {
        return buffer.length() == 0;
    }

    public String getToken() {
        return this.m_buffer.toString();
    }

    public int getType() {
        return this.m_type;
    }

    public void setDelimiter(char delimiter) {
        this.m_delimiter = delimiter;
    }
}

