/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.conceptdraw;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.mpxj.CostRateTable;
import org.mpxj.CostRateTableEntry;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.LocalTimeRange;
import org.mpxj.MPXJException;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.Task;
import org.mpxj.TimeUnit;
import org.mpxj.common.AlphanumComparator;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.UnmarshalHelper;
import org.mpxj.conceptdraw.NamespaceFilter;
import org.mpxj.conceptdraw.schema.Document;
import org.mpxj.reader.AbstractProjectStreamReader;
import org.xml.sax.SAXException;

public final class ConceptDrawProjectReader
extends AbstractProjectStreamReader {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private Map<Integer, ProjectCalendar> m_calendarMap;
    private Map<Integer, Task> m_taskIdMap;
    private double m_workHoursPerDay;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_DAY = 1440;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_calendarMap = new HashMap<Integer, ProjectCalendar>();
            this.m_taskIdMap = new HashMap<Integer, Task>();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoResourceUniqueID(false);
            config.setAutoResourceID(false);
            config.setAutoRelationUniqueID(false);
            config.setAutoAssignmentUniqueID(false);
            this.m_projectFile.getProjectProperties().setFileApplication("ConceptDraw PROJECT");
            this.m_projectFile.getProjectProperties().setFileType("CDP");
            this.addListenersToProject(this.m_projectFile);
            Document cdp = (Document)UnmarshalHelper.unmarshal(CONTEXT, stream, new NamespaceFilter());
            this.readProjectProperties(cdp);
            this.readCalendars(cdp);
            this.readResources(cdp);
            this.readTasks(cdp);
            this.readRelationships(cdp);
            this.m_projectFile.readComplete();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (JAXBException | IOException | ParserConfigurationException | SAXException ex) {
            throw new MPXJException("Failed to parse file", (Exception)ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_eventManager = null;
            this.m_calendarMap = null;
            this.m_taskIdMap = null;
        }
    }

    private void readProjectProperties(Document cdp) {
        Document.WorkspaceProperties props = cdp.getWorkspaceProperties();
        ProjectProperties mpxjProps = this.m_projectFile.getProjectProperties();
        mpxjProps.setSymbolPosition(props.getCurrencyPosition());
        mpxjProps.setCurrencyDigits(props.getCurrencyDigits());
        mpxjProps.setCurrencySymbol(props.getCurrencySymbol());
        mpxjProps.setDaysPerMonth(props.getDaysPerMonth());
        mpxjProps.setMinutesPerDay(props.getHoursPerDay());
        mpxjProps.setMinutesPerWeek(NumberHelper.getInt(props.getHoursPerWeek()) * 60);
        this.m_workHoursPerDay = mpxjProps.getMinutesPerDay().doubleValue() / 60.0;
    }

    private void readCalendars(Document cdp) {
        for (Document.Calendars.Calendar calendar : cdp.getCalendars().getCalendar()) {
            this.readCalendar(calendar);
        }
        for (Document.Calendars.Calendar calendar : cdp.getCalendars().getCalendar()) {
            ProjectCalendar child = this.m_calendarMap.get(calendar.getID());
            ProjectCalendar parent = this.m_calendarMap.get(calendar.getBaseCalendarID());
            if (parent == null) {
                this.m_projectFile.setDefaultCalendar(child);
                continue;
            }
            child.setParent(parent);
        }
    }

    private void readCalendar(Document.Calendars.Calendar calendar) {
        ProjectCalendar mpxjCalendar = this.m_projectFile.addCalendar();
        mpxjCalendar.setName(calendar.getName());
        this.m_calendarMap.put(calendar.getID(), mpxjCalendar);
        for (Document.Calendars.Calendar.WeekDays.WeekDay weekDay : calendar.getWeekDays().getWeekDay()) {
            this.readWeekDay(mpxjCalendar, weekDay);
        }
        for (Document.Calendars.Calendar.ExceptedDays.ExceptedDay exceptedDay : calendar.getExceptedDays().getExceptedDay()) {
            this.readExceptionDay(mpxjCalendar, exceptedDay);
        }
        this.m_eventManager.fireCalendarReadEvent(mpxjCalendar);
    }

    private void readWeekDay(ProjectCalendar mpxjCalendar, Document.Calendars.Calendar.WeekDays.WeekDay day) {
        mpxjCalendar.setWorkingDay(day.getDay(), day.isIsDayWorking());
        ProjectCalendarHours hours = mpxjCalendar.addCalendarHours(day.getDay());
        if (day.isIsDayWorking()) {
            for (Document.Calendars.Calendar.WeekDays.WeekDay.TimePeriods.TimePeriod period : day.getTimePeriods().getTimePeriod()) {
                hours.add(new LocalTimeRange(period.getFrom(), period.getTo()));
            }
        }
    }

    private void readExceptionDay(ProjectCalendar mpxjCalendar, Document.Calendars.Calendar.ExceptedDays.ExceptedDay day) {
        ProjectCalendarException mpxjException = mpxjCalendar.addCalendarException(day.getDate());
        if (day.isIsDayWorking()) {
            for (Document.Calendars.Calendar.ExceptedDays.ExceptedDay.TimePeriods.TimePeriod period : day.getTimePeriods().getTimePeriod()) {
                mpxjException.add(new LocalTimeRange(period.getFrom(), period.getTo()));
            }
        }
    }

    private void readResources(Document cdp) {
        for (Document.Resources.Resource resource : cdp.getResources().getResource()) {
            this.readResource(resource);
        }
    }

    private void readResource(Document.Resources.Resource resource) {
        Resource mpxjResource = this.m_projectFile.addResource();
        mpxjResource.setName(resource.getName());
        mpxjResource.setCalendar(this.m_calendarMap.get(resource.getCalendarID()));
        mpxjResource.setEmailAddress(resource.getEMail());
        mpxjResource.setGroup(resource.getGroup());
        mpxjResource.setUniqueID(resource.getID());
        mpxjResource.setNotes(resource.getNote());
        mpxjResource.setID(Integer.valueOf(resource.getOutlineNumber()));
        mpxjResource.setType(resource.getSubType() == null ? resource.getType() : resource.getSubType());
        CostRateTable table = new CostRateTable();
        table.add(new CostRateTableEntry(LocalDateTimeHelper.START_DATE_NA, LocalDateTimeHelper.END_DATE_NA, (Number)NumberHelper.DOUBLE_ZERO, new Rate(resource.getCost(), resource.getCostTimeUnit())));
        mpxjResource.setCostRateTable(0, table);
        this.m_eventManager.fireResourceReadEvent(mpxjResource);
    }

    private void readTasks(Document cdp) {
        for (Document.Projects.Project project : cdp.getProjects().getProject()) {
            this.readProject(project);
        }
    }

    private void readProject(Document.Projects.Project project) {
        Task mpxjTask = this.m_projectFile.addTask();
        mpxjTask.setBaselineCost(project.getBaselineCost());
        mpxjTask.setBaselineFinish(project.getBaselineFinishDate());
        mpxjTask.setBaselineStart(project.getBaselineStartDate());
        mpxjTask.setFinish(project.getFinishDate());
        mpxjTask.setName(project.getName());
        mpxjTask.setNotes(project.getNote());
        mpxjTask.setPriority(project.getPriority());
        mpxjTask.setStart(project.getStartDate());
        String projectIdentifier = project.getID().toString();
        mpxjTask.setGUID(UUID.nameUUIDFromBytes(projectIdentifier.getBytes()));
        ArrayList<Document.Projects.Project.Task> tasks = new ArrayList<Document.Projects.Project.Task>(project.getTask());
        AlphanumComparator comparator = new AlphanumComparator();
        tasks.sort((o1, o2) -> comparator.compare(o1.getOutlineNumber(), o2.getOutlineNumber()));
        HashMap<String, Task> map = new HashMap<String, Task>();
        map.put("", mpxjTask);
        for (Document.Projects.Project.Task task : tasks) {
            this.readTask(projectIdentifier, map, task);
        }
    }

    private void readTask(String projectIdentifier, Map<String, Task> map, Document.Projects.Project.Task task) {
        Task parentTask = map.get(this.getParentOutlineNumber(task.getOutlineNumber()));
        Task mpxjTask = parentTask.addTask();
        TimeUnit units = task.getBaseDurationTimeUnit();
        mpxjTask.setCost(task.getActualCost());
        mpxjTask.setDuration(this.getDuration(units, task.getActualDuration()));
        mpxjTask.setFinish(task.getActualFinishDate());
        mpxjTask.setStart(task.getActualStartDate());
        mpxjTask.setBaselineDuration(this.getDuration(units, task.getBaseDuration()));
        mpxjTask.setBaselineFinish(task.getBaseFinishDate());
        mpxjTask.setBaselineCost(task.getBaselineCost());
        mpxjTask.setBaselineStart(task.getBaseStartDate());
        mpxjTask.setPercentageComplete(task.getComplete());
        mpxjTask.setDeadline(task.getDeadlineDate());
        mpxjTask.setName(task.getName());
        mpxjTask.setNotes(task.getNote());
        mpxjTask.setPriority(task.getPriority());
        mpxjTask.setType(task.getSchedulingType());
        if (task.isIsMilestone()) {
            mpxjTask.setMilestone(true);
            mpxjTask.setDuration(Duration.getInstance(0, TimeUnit.HOURS));
            mpxjTask.setBaselineDuration(Duration.getInstance(0, TimeUnit.HOURS));
        }
        String taskIdentifier = projectIdentifier + "." + task.getID();
        this.m_taskIdMap.put(task.getID(), mpxjTask);
        mpxjTask.setGUID(UUID.nameUUIDFromBytes(taskIdentifier.getBytes()));
        map.put(task.getOutlineNumber(), mpxjTask);
        this.m_eventManager.fireTaskReadEvent(mpxjTask);
        for (Document.Projects.Project.Task.ResourceAssignments.ResourceAssignment assignment : task.getResourceAssignments().getResourceAssignment()) {
            this.readResourceAssignment(mpxjTask, assignment);
        }
    }

    private void readResourceAssignment(Task task, Document.Projects.Project.Task.ResourceAssignments.ResourceAssignment assignment) {
        Resource resource = this.m_projectFile.getResourceByUniqueID(assignment.getResourceID());
        if (resource != null) {
            ResourceAssignment mpxjAssignment = task.addResourceAssignment(resource);
            mpxjAssignment.setUniqueID(assignment.getID());
            mpxjAssignment.setWork(Duration.getInstance(assignment.getManHour() * this.m_workHoursPerDay, TimeUnit.HOURS));
            mpxjAssignment.setUnits(assignment.getUse());
            this.m_eventManager.fireAssignmentReadEvent(mpxjAssignment);
        }
    }

    private void readRelationships(Document cdp) {
        for (Document.Links.Link link : cdp.getLinks().getLink()) {
            this.readRelationship(link);
        }
    }

    private void readRelationship(Document.Links.Link link) {
        Task sourceTask = this.m_taskIdMap.get(link.getSourceTaskID());
        Task destinationTask = this.m_taskIdMap.get(link.getDestinationTaskID());
        if (sourceTask != null && destinationTask != null) {
            Relation relation = destinationTask.addPredecessor(new Relation.Builder().predecessorTask(sourceTask).type(link.getType()).lag(this.getDuration(link.getLagUnit(), link.getLag())).uniqueID(link.getID()));
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private Duration getDuration(TimeUnit units, Double duration) {
        Duration result = null;
        if (duration != null) {
            double durationValue = duration * 100.0;
            switch (units) {
                case MINUTES: {
                    durationValue *= 1440.0;
                    break;
                }
                case HOURS: {
                    durationValue *= 24.0;
                    break;
                }
                case DAYS: {
                    durationValue *= 3.0;
                    break;
                }
                case WEEKS: {
                    durationValue *= 0.6;
                    break;
                }
                case MONTHS: {
                    durationValue *= 0.15;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported time units " + units);
                }
            }
            durationValue = (double)Math.round(durationValue) / 100.0;
            result = Duration.getInstance(durationValue, units);
        }
        return result;
    }

    private String getParentOutlineNumber(String outlineNumber) {
        int index = outlineNumber.lastIndexOf(46);
        String result = index == -1 ? "" : outlineNumber.substring(0, index);
        return result;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"org.mpxj.conceptdraw.schema", (ClassLoader)ConceptDrawProjectReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

