/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.cpm;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mpxj.ConstraintType;
import org.mpxj.Duration;
import org.mpxj.FieldType;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectFile;
import org.mpxj.Relation;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceType;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TaskMode;
import org.mpxj.TaskType;
import org.mpxj.TimeUnit;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.cpm.CpmException;
import org.mpxj.cpm.DepthFirstGraphSort;
import org.mpxj.cpm.Scheduler;

public class MicrosoftScheduler
implements Scheduler {
    private ProjectFile m_file;
    private List<Task> m_sortedTasks;
    private boolean m_backwardPass;
    private LocalDateTime m_projectStartDate;
    private LocalDateTime m_projectFinishDate;
    private final Map<Task, List<Relation>> m_summaryTaskPredecessors = new HashMap<Task, List<Relation>>();
    private final Map<Task, List<Relation>> m_summaryTaskSuccessors = new HashMap<Task, List<Relation>>();
    private final Map<Task, LocalDateTime> m_calculatedLateStart = new HashMap<Task, LocalDateTime>();
    private static final Map<TimeUnit, TimeUnit> DURATION_UNITS_MAP = new HashMap<TimeUnit, TimeUnit>();

    @Override
    public void schedule(ProjectFile file, LocalDateTime startDate) throws CpmException {
        this.m_file = file;
        this.m_projectStartDate = startDate;
        this.m_calculatedLateStart.clear();
        List<Task> tasks = new DepthFirstGraphSort(this.m_file, this::isTask).sort();
        this.m_sortedTasks = tasks;
        if (tasks.isEmpty()) {
            return;
        }
        this.validateTasks(tasks);
        this.clearDates();
        this.m_backwardPass = false;
        this.forwardPass(tasks);
        boolean summaryTasksHaveLogic = this.m_file.getTasks().stream().anyMatch(t -> t.getSummary() && (!t.getPredecessors().isEmpty() || !t.getSuccessors().isEmpty()));
        if (summaryTasksHaveLogic) {
            this.createSummaryTaskRelationships();
            tasks = new DepthFirstGraphSort(this.m_file, this::isTask){

                @Override
                public List<Relation> getSuccessors(Task task) {
                    List<Relation> successors = task.getSuccessors();
                    List summaryTaskSuccessors = (List)MicrosoftScheduler.this.m_summaryTaskSuccessors.get(task);
                    if (summaryTaskSuccessors != null) {
                        successors = new ArrayList<Relation>(successors);
                        successors.addAll(summaryTaskSuccessors);
                    }
                    return successors;
                }
            }.sort();
            this.m_sortedTasks = tasks;
            this.forwardPass(tasks);
        }
        this.m_projectFinishDate = tasks.stream().map(Task::getEarlyFinish).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElseThrow(() -> new CpmException("Missing early finish date"));
        this.backwardPass(tasks);
        this.m_backwardPass = true;
        if (tasks.stream().anyMatch(t -> t.getConstraintType() == ConstraintType.AS_LATE_AS_POSSIBLE)) {
            this.forwardPass(tasks);
        }
        for (Task task : tasks) {
            if (task.getExternalTask() || task.getExternalProject() || !task.getActive() || task.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) continue;
            task.setStart(task.getActualStart() == null ? (task.getConstraintType() == ConstraintType.AS_LATE_AS_POSSIBLE ? task.getLateStart() : task.getEarlyStart()) : task.getActualStart());
            task.setFinish(task.getActualFinish() == null ? (task.getConstraintType() == ConstraintType.AS_LATE_AS_POSSIBLE ? task.getLateFinish() : task.getEarlyFinish()) : task.getActualFinish());
            if (this.useTaskEffectiveCalendar(task)) continue;
            task.setDuration(task.getEffectiveCalendar().getWork(task.getStart(), task.getFinish(), TimeUnit.DAYS));
        }
        this.m_file.getChildTasks().forEach(this::rollupDates);
    }

    private void validateTasks(List<Task> tasks) throws CpmException {
        for (Task task : tasks) {
            if (task.getDuration() == null && (!this.getResourceAssignmentStream(task).findAny().isPresent() || this.getResourceAssignmentStream(task).noneMatch(r -> r.getWork() != null))) {
                throw new CpmException("Task has no duration value and no resource assignments with a work value: " + task);
            }
            if (task.getActualDuration() == null && (!this.getResourceAssignmentStream(task).findAny().isPresent() || this.getResourceAssignmentStream(task).noneMatch(r -> r.getActualWork() != null))) {
                throw new CpmException("Task has no actual duration value and no resource assignments with an actual work value: " + task);
            }
            if (task.getRemainingDuration() != null || this.getResourceAssignmentStream(task).findAny().isPresent() && !this.getResourceAssignmentStream(task).noneMatch(r -> r.getRemainingWork() != null)) continue;
            throw new CpmException("Task has no remaining duration value and no resource assignments with a remaining work value: " + task);
        }
    }

    private void clearDates() {
        for (Task task : this.m_file.getTasks()) {
            if (task.getExternalTask() || task.getExternalProject() || !task.getActive() || task.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) continue;
            task.setStart(null);
            task.setFinish(null);
            task.setEarlyStart(null);
            task.setEarlyFinish(null);
            task.setLateStart(null);
            task.setLateFinish(null);
            task.set((FieldType)TaskField.CRITICAL, null);
        }
    }

    private void forwardPass(List<Task> tasks) throws CpmException {
        for (Task task : tasks) {
            this.forwardPass(task);
        }
    }

    private void forwardPass(Task task) throws CpmException {
        LocalDateTime earlyStart;
        LocalDateTime earlyFinish;
        block27: {
            block26: {
                if (task.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
                    task.setEarlyStart(task.getStart());
                    task.setEarlyFinish(task.getFinish());
                    return;
                }
                if (task.getExternalTask() || task.getExternalProject()) {
                    return;
                }
                earlyFinish = null;
                List predecessors = task.getPredecessors().stream().filter(r -> this.isTask(r.getPredecessorTask())).collect(Collectors.toList());
                List<Relation> summaryTaskPredecessors = this.m_summaryTaskPredecessors.get(task);
                if (summaryTaskPredecessors != null) {
                    predecessors = new ArrayList(predecessors);
                    predecessors.addAll(summaryTaskPredecessors);
                }
                if (task.getActualStart() != null) break block26;
                if (predecessors.isEmpty()) {
                    switch (this.getConstraintType(task)) {
                        case START_NO_EARLIER_THAN: {
                            earlyStart = task.getConstraintDate();
                            break;
                        }
                        case FINISH_NO_EARLIER_THAN: {
                            earlyFinish = task.getConstraintDate();
                            earlyStart = this.getDateFromFinishAndDuration(task, earlyFinish);
                            break;
                        }
                        default: {
                            earlyStart = this.addLevelingDelay(task, this.getNextWorkStart(task, this.m_projectStartDate));
                            break;
                        }
                    }
                } else {
                    earlyStart = predecessors.stream().map(this::calculateEarlyStart).max(Comparator.naturalOrder()).orElseThrow(() -> new CpmException("Missing early start date"));
                }
                earlyStart = this.getNextWorkStart(task, earlyStart);
                switch (this.getConstraintType(task)) {
                    case START_NO_EARLIER_THAN: {
                        if (earlyStart.isBefore(task.getConstraintDate())) {
                            earlyStart = task.getConstraintDate();
                            break;
                        }
                        break block27;
                    }
                    case FINISH_NO_LATER_THAN: {
                        LocalDateTime latestStart = this.getDateFromFinishAndDuration(task, task.getConstraintDate());
                        if (earlyStart.isAfter(latestStart)) {
                            earlyStart = latestStart;
                            break;
                        }
                        break block27;
                    }
                    case FINISH_NO_EARLIER_THAN: {
                        LocalDateTime earliestStart = this.getDateFromFinishAndDuration(task, task.getConstraintDate());
                        if (earlyStart.isBefore(earliestStart)) {
                            earlyStart = earliestStart;
                            break;
                        }
                        break block27;
                    }
                    case START_NO_LATER_THAN: {
                        if (earlyStart.isAfter(task.getConstraintDate())) {
                            earlyStart = task.getConstraintDate();
                            break;
                        }
                        break block27;
                    }
                    case MUST_START_ON: 
                    case START_ON: {
                        earlyStart = task.getConstraintDate();
                        break;
                    }
                    case MUST_FINISH_ON: 
                    case FINISH_ON: {
                        earlyFinish = task.getConstraintDate();
                        earlyStart = this.getDateFromFinishAndDuration(task, earlyFinish);
                        break;
                    }
                }
                break block27;
            }
            earlyStart = task.getActualStart();
            if (task.getConstraintType() != null && task.getActualFinish() == null) {
                earlyFinish = this.getDateFromStartAndDuration(task, earlyStart);
                switch (task.getConstraintType()) {
                    case FINISH_NO_EARLIER_THAN: {
                        if (!earlyFinish.isBefore(task.getConstraintDate())) break;
                        earlyFinish = task.getConstraintDate();
                        break;
                    }
                }
            }
        }
        if (earlyFinish == null) {
            earlyFinish = task.getActualFinish() == null ? this.getDateFromStartAndDuration(task, earlyStart) : task.getActualFinish();
        }
        task.setEarlyStart(earlyStart);
        task.setEarlyFinish(earlyFinish);
    }

    private void backwardPass(List<Task> forwardPassTasks) throws CpmException {
        ArrayList<Task> tasks = new ArrayList<Task>(forwardPassTasks);
        Collections.reverse(tasks);
        for (Task task : tasks) {
            this.backwardPass(task);
        }
    }

    private void backwardPass(Task task) throws CpmException {
        LocalDateTime lateStart;
        LocalDateTime lateFinish;
        if (task.getExternalTask() || task.getExternalProject()) {
            return;
        }
        List successors = this.m_file.getRelations().getSuccessors(task).stream().filter(r -> this.isTask(r.getSuccessorTask()) && r.getSuccessorTask().getActualFinish() == null).collect(Collectors.toList());
        List<Relation> summaryTaskSuccessors = this.m_summaryTaskSuccessors.get(task);
        if (summaryTaskSuccessors != null) {
            successors = new ArrayList(successors);
            successors.addAll(summaryTaskSuccessors);
        }
        if (task.getActualFinish() == null) {
            lateFinish = successors.isEmpty() ? this.m_projectFinishDate : (task.getMilestone() && task.getDuration().getDuration() == 0.0 && task.getActualStart() != null ? task.getActualStart() : successors.stream().map(this::calculateLateFinish).min(Comparator.naturalOrder()).orElseThrow(() -> new CpmException("Missing late start date")));
            switch (this.getConstraintType(task)) {
                case MUST_START_ON: {
                    lateFinish = this.getDateFromStartAndDuration(task, task.getConstraintDate());
                    break;
                }
                case MUST_FINISH_ON: 
                case FINISH_ON: {
                    lateFinish = task.getConstraintDate();
                    break;
                }
                case START_NO_LATER_THAN: {
                    LocalDateTime latestFinish = this.getDateFromStartAndDuration(task, task.getConstraintDate());
                    if (!lateFinish.isAfter(latestFinish)) break;
                    lateFinish = latestFinish;
                    break;
                }
                case FINISH_NO_LATER_THAN: {
                    if (!lateFinish.isAfter(task.getConstraintDate())) break;
                    lateFinish = task.getConstraintDate();
                    break;
                }
            }
            if (task.getDeadline() != null && lateFinish.isAfter(task.getDeadline())) {
                lateFinish = task.getDeadline();
            }
            lateFinish = this.getEquivalentPreviousWorkFinish(task, lateFinish);
        } else {
            lateFinish = task.getActualFinish();
        }
        if (task.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
            lateStart = this.getDateFromFinishAndDuration(task, lateFinish);
            this.m_calculatedLateStart.put(task, lateStart);
            if (task.getActualFinish() == null) {
                task.setLateStart(lateStart);
                task.setLateFinish(lateFinish);
            } else {
                task.setLateStart(task.getActualStart());
                task.setLateFinish(lateFinish);
            }
        } else {
            lateStart = this.getDateFromFinishAndRemainingDuration(task, lateFinish);
            this.m_calculatedLateStart.put(task, lateStart);
            task.setLateStart(task.getActualStart() == null ? lateStart : task.getActualStart());
            task.setLateFinish(lateFinish);
        }
    }

    private LocalDateTime calculateEarlyStart(Relation relation) {
        switch (relation.getType()) {
            case FINISH_START: {
                return this.calculateEarlyStartForFinishStart(relation);
            }
            case START_START: {
                return this.calculateEarlyStartForStartStart(relation);
            }
            case FINISH_FINISH: {
                return this.calculateEarlyStartForFinishFinish(relation);
            }
            case START_FINISH: {
                return this.calculateEarlyStartForStartFinish(relation);
            }
        }
        throw new UnsupportedOperationException();
    }

    private LocalDateTime calculateEarlyStartForFinishStart(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        if (predecessorTask.getActualStart() == null) {
            LocalDateTime finish = this.isAlap(relation) ? predecessorTask.getLateFinish() : predecessorTask.getEarlyFinish();
            return this.addLag(relation, finish);
        }
        if (predecessorTask.getActualFinish() != null) {
            LocalDateTime finish = this.isAlap(relation) ? predecessorTask.getLateFinish() : predecessorTask.getEarlyFinish();
            return this.addLag(relation, finish);
        }
        LocalDateTime finish = this.isAlap(relation) ? predecessorTask.getLateFinish() : predecessorTask.getEarlyFinish();
        return this.addLag(relation, finish);
    }

    private LocalDateTime calculateEarlyStartForStartStart(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        if (predecessorTask.getActualStart() == null) {
            LocalDateTime start = this.isAlap(relation) ? predecessorTask.getLateStart() : predecessorTask.getEarlyStart();
            return this.addLag(relation, start);
        }
        if (predecessorTask.getActualFinish() != null) {
            return this.addLag(relation, predecessorTask.getActualStart());
        }
        LocalDateTime start = this.isAlap(relation) ? predecessorTask.getLateStart() : predecessorTask.getEarlyStart();
        return this.addLag(relation, start);
    }

    private LocalDateTime calculateEarlyStartForStartFinish(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        if (predecessorTask.getActualStart() == null) {
            LocalDateTime start = this.isAlap(relation) ? predecessorTask.getLateStart() : predecessorTask.getEarlyStart();
            return this.addLag(relation, this.getDateFromFinishAndDuration(relation.getSuccessorTask(), start));
        }
        if (predecessorTask.getActualFinish() != null) {
            LocalDateTime start = this.isAlap(relation) ? predecessorTask.getLateStart() : predecessorTask.getEarlyStart();
            return this.addLag(relation, this.getDateFromFinishAndDuration(relation.getSuccessorTask(), start));
        }
        LocalDateTime start = this.isAlap(relation) ? predecessorTask.getLateStart() : predecessorTask.getEarlyStart();
        return this.addLag(relation, this.getDateFromFinishAndDuration(relation.getSuccessorTask(), start));
    }

    private LocalDateTime calculateEarlyStartForFinishFinish(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        if (predecessorTask.getActualStart() == null) {
            LocalDateTime finish = this.isAlap(relation) ? predecessorTask.getLateFinish() : predecessorTask.getEarlyFinish();
            LocalDateTime earlyStart = this.addLag(relation, this.getDateFromFinishAndRemainingDuration(relation.getSuccessorTask(), finish));
            return earlyStart.isBefore(this.m_projectStartDate) ? this.m_projectStartDate : earlyStart;
        }
        if (predecessorTask.getActualFinish() != null) {
            LocalDateTime earlyStart = this.addLag(relation, this.getDateFromFinishAndRemainingDuration(relation.getSuccessorTask(), predecessorTask.getActualFinish()));
            return earlyStart.isBefore(this.m_projectStartDate) ? this.m_projectStartDate : earlyStart;
        }
        LocalDateTime finish = this.isAlap(relation) ? predecessorTask.getLateFinish() : predecessorTask.getEarlyFinish();
        LocalDateTime earlyStart = this.addLag(relation, this.getDateFromFinishAndRemainingDuration(relation.getSuccessorTask(), finish));
        return earlyStart.isBefore(this.m_projectStartDate) ? this.m_projectStartDate : earlyStart;
    }

    private LocalDateTime calculateLateFinish(Relation relation) {
        LocalDateTime lateFinish;
        switch (relation.getType()) {
            case START_START: {
                lateFinish = this.calculateLateFinishForStartStart(relation);
                break;
            }
            case FINISH_FINISH: {
                lateFinish = this.calculateLateFinishForFinishFinish(relation);
                break;
            }
            case START_FINISH: {
                lateFinish = this.calculateLateFinishForStartFinish(relation);
                break;
            }
            case FINISH_START: {
                lateFinish = this.calculateLateFinishForFinishStart(relation);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (lateFinish.isAfter(this.m_projectFinishDate)) {
            return this.m_projectFinishDate;
        }
        return lateFinish;
    }

    private LocalDateTime calculateLateFinishForStartStart(Relation relation) {
        LocalDateTime lateFinish;
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        ProjectCalendar calendar = predecessorTask.getEffectiveCalendar();
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                if (predecessorTask.getTaskMode() == TaskMode.MANUALLY_SCHEDULED && successorTask.getSuccessors().isEmpty()) {
                    lateFinish = successorTask.getLateFinish();
                } else if (predecessorTask.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
                    lateFinish = this.m_projectFinishDate;
                } else {
                    LocalDateTime lateStart = this.removeLag(relation, calendar.getNextWorkStart(successorTask.getLateStart()));
                    lateFinish = this.getDateFromStartAndDuration(predecessorTask, lateStart);
                }
            } else if (successorTask.getSuccessors().isEmpty()) {
                lateFinish = this.m_projectFinishDate;
            } else {
                LocalDateTime lateStart = this.getDateFromStartAndActualDuration(successorTask, successorTask.getActualStart());
                lateFinish = this.getDateFromStartAndDuration(predecessorTask, lateStart);
            }
        } else {
            lateFinish = successorTask.getActualStart() == null ? this.m_projectFinishDate : this.m_projectFinishDate;
        }
        return lateFinish;
    }

    private LocalDateTime calculateLateFinishForFinishFinish(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                return this.removeLag(relation, relation.getSuccessorTask().getLateFinish());
            }
            return this.removeLag(relation, relation.getSuccessorTask().getLateFinish());
        }
        if (successorTask.getActualStart() == null) {
            return this.removeLag(relation, relation.getSuccessorTask().getLateFinish());
        }
        return this.removeLag(relation, relation.getSuccessorTask().getLateFinish());
    }

    private LocalDateTime calculateLateFinishForFinishStart(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                return this.removeLag(relation, this.m_calculatedLateStart.getOrDefault(successorTask, successorTask.getLateStart()));
            }
            return this.removeLag(relation, this.m_calculatedLateStart.getOrDefault(successorTask, successorTask.getLateStart()));
        }
        if (successorTask.getActualStart() == null) {
            return this.removeLag(relation, this.m_calculatedLateStart.getOrDefault(successorTask, successorTask.getLateStart()));
        }
        return this.removeLag(relation, this.m_calculatedLateStart.getOrDefault(successorTask, successorTask.getLateStart()));
    }

    private LocalDateTime calculateLateFinishForStartFinish(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
            }
            return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
        }
        if (successorTask.getActualStart() == null) {
            return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
        }
        return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
    }

    private LocalDateTime addLevelingDelay(Task task, LocalDateTime date) {
        Duration delay = task.getLevelingDelay();
        if (delay == null || delay.getDuration() == 0.0) {
            return date;
        }
        if (!delay.getUnits().isElapsed()) {
            TimeUnit newTimeUnit = DURATION_UNITS_MAP.get(delay.getUnits());
            if (newTimeUnit == null) {
                throw new UnsupportedOperationException("Unsupported TimeUnit " + delay.getUnits());
            }
            delay = Duration.getInstance(delay.getDuration(), newTimeUnit);
        }
        ProjectCalendar calendar = task.getEffectiveCalendar();
        date = calendar.getNextWorkStart(date);
        return calendar.getDate(date, delay);
    }

    public boolean isTask(Task task) {
        return (!task.getSummary() || task.getExternalProject()) && task.getActive() && !task.getNull();
    }

    private LocalDateTime addLag(Relation relation, LocalDateTime date) {
        if (relation.getLag().getDuration() == 0.0) {
            return date;
        }
        Duration lag = relation.getLag();
        if (lag.getUnits() == TimeUnit.PERCENT) {
            Duration predecessorDuration = relation.getPredecessorTask().getDuration();
            lag = Duration.getInstance(predecessorDuration.getDuration() * lag.getDuration() / 100.0, predecessorDuration.getUnits());
        }
        ProjectCalendar calendar = relation.getSuccessorTask().getEffectiveCalendar();
        return calendar.getDate(date, lag);
    }

    private LocalDateTime removeLag(Relation relation, LocalDateTime date) {
        if (relation.getLag().getDuration() == 0.0) {
            return date;
        }
        Duration lag = relation.getLag();
        if (lag.getUnits() == TimeUnit.PERCENT) {
            Duration predecessorDuration = relation.getPredecessorTask().getDuration();
            lag = Duration.getInstance(predecessorDuration.getDuration() * lag.getDuration() / 100.0, predecessorDuration.getUnits());
        }
        ProjectCalendar calendar = relation.getSuccessorTask().getEffectiveCalendar();
        return calendar.getDate(date, lag.negate());
    }

    private void createSummaryTaskRelationships() {
        this.m_file.getRelations().stream().filter(r -> r.getPredecessorTask().getSummary() || r.getSuccessorTask().getSummary()).forEach(this::createSummaryTaskRelationship);
    }

    private void createSummaryTaskRelationship(Relation relation) {
        List<Task> successors;
        List<Task> predecessors = Collections.singletonList(relation.getPredecessorTask());
        if (predecessors.get(0).getSummary()) {
            switch (relation.getType()) {
                case START_START: 
                case START_FINISH: {
                    predecessors = Collections.singletonList(this.findEarliestSubtask(predecessors.get(0)));
                    break;
                }
                default: {
                    predecessors = this.allChildTasks(predecessors.get(0));
                }
            }
        }
        if ((successors = Collections.singletonList(relation.getSuccessorTask())).get(0).getSummary()) {
            successors = this.allChildTasks(successors.get(0));
        }
        for (Task predecessor : predecessors) {
            for (Task successor : successors) {
                Relation newRelation = new Relation.Builder().from(relation).predecessorTask(predecessor).successorTask(successor).build();
                this.m_summaryTaskPredecessors.computeIfAbsent(successor, k -> new ArrayList()).add(newRelation);
                this.m_summaryTaskSuccessors.computeIfAbsent(predecessor, k -> new ArrayList()).add(newRelation);
            }
        }
    }

    private void rollupDates(Task parentTask) {
        if (!parentTask.hasChildTasks()) {
            return;
        }
        int finished = 0;
        LocalDateTime startDate = parentTask.getStart();
        LocalDateTime finishDate = parentTask.getFinish();
        LocalDateTime actualStartDate = parentTask.getActualStart();
        LocalDateTime actualFinishDate = parentTask.getActualFinish();
        LocalDateTime earlyStartDate = parentTask.getEarlyStart();
        LocalDateTime earlyFinishDate = parentTask.getEarlyFinish();
        LocalDateTime lateStartDate = parentTask.getLateStart();
        LocalDateTime lateFinishDate = parentTask.getLateFinish();
        boolean critical = false;
        for (Task task : parentTask.getChildTasks()) {
            if (task.getExternalTask()) continue;
            this.rollupDates(task);
            startDate = LocalDateTimeHelper.min(startDate, task.getStart());
            finishDate = LocalDateTimeHelper.max(finishDate, task.getFinish());
            actualStartDate = LocalDateTimeHelper.min(actualStartDate, task.getActualStart());
            actualFinishDate = LocalDateTimeHelper.max(actualFinishDate, task.getActualFinish());
            if (task.getConstraintType() == ConstraintType.AS_LATE_AS_POSSIBLE) {
                earlyStartDate = LocalDateTimeHelper.min(earlyStartDate, task.getLateStart());
                earlyFinishDate = LocalDateTimeHelper.max(earlyFinishDate, task.getLateFinish());
            } else {
                earlyStartDate = LocalDateTimeHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = LocalDateTimeHelper.max(earlyFinishDate, task.getEarlyFinish());
            }
            if (task.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
                lateStartDate = LocalDateTimeHelper.min(lateStartDate, task.getEarlyStart());
                lateFinishDate = LocalDateTimeHelper.max(lateFinishDate, task.getEarlyFinish());
            } else {
                lateStartDate = LocalDateTimeHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = LocalDateTimeHelper.max(lateFinishDate, task.getLateFinish());
            }
            if (task.getActualFinish() != null) {
                ++finished;
            }
            critical = critical || task.getCritical();
        }
        parentTask.setStart(startDate);
        parentTask.setFinish(finishDate);
        parentTask.setActualStart(actualStartDate);
        parentTask.setEarlyStart(earlyStartDate);
        parentTask.setEarlyFinish(earlyFinishDate);
        parentTask.setLateStart(lateStartDate);
        parentTask.setLateFinish(lateFinishDate);
        if (finished == parentTask.getChildTasks().size()) {
            parentTask.setActualFinish(actualFinishDate);
        }
        parentTask.setCritical(critical);
        parentTask.setDuration(parentTask.getEffectiveCalendar().getWork(startDate, finishDate, TimeUnit.DAYS));
    }

    private Task findEarliestSubtask(Task summaryTask) {
        return this.allChildTasks(summaryTask).stream().min(Comparator.comparing(Task::getEarlyStart)).orElse(null);
    }

    private List<Task> allChildTasks(Task summaryTask) {
        return this.allChildTasks(summaryTask, new ArrayList<Task>());
    }

    private List<Task> allChildTasks(Task summaryTask, List<Task> childTasks) {
        childTasks.addAll(summaryTask.getChildTasks().stream().filter(t -> !t.getSummary() && t.getActive()).collect(Collectors.toList()));
        summaryTask.getChildTasks().stream().filter(Task::getSummary).forEach(t -> this.allChildTasks((Task)t, childTasks));
        return childTasks;
    }

    List<Task> getSortedTasks() {
        return this.m_sortedTasks;
    }

    private LocalDateTime getDateFromStartAndDuration(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return task.getEffectiveCalendar().getDate(date, task.getDuration());
        }
        return this.getDateFromStartAndWork(task, date);
    }

    private LocalDateTime getDateFromStartAndActualDuration(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return task.getEffectiveCalendar().getDate(date, task.getActualDuration());
        }
        return this.getDateFromStartAndActualWork(task, date);
    }

    private LocalDateTime getDateFromFinishAndDuration(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return task.getEffectiveCalendar().getDate(date, task.getDuration().negate());
        }
        return this.getDateFromFinishAndWork(task, date);
    }

    private LocalDateTime getDateFromFinishAndRemainingDuration(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return task.getEffectiveCalendar().getDate(date, task.getRemainingDuration().negate());
        }
        return this.getDateFromFinishAndRemainingWork(task, date);
    }

    private boolean useTaskEffectiveCalendar(Task task) {
        return task.getType() == TaskType.FIXED_DURATION || !this.getResourceAssignmentStream(task).findAny().isPresent();
    }

    private LocalDateTime getDateFromStartAndWork(Task task, LocalDateTime date) {
        return this.getResourceAssignmentStream(task).map(r -> this.getDateFromWork((ResourceAssignment)r, date, r.getWork())).max(Comparator.naturalOrder()).orElseGet(null);
    }

    private LocalDateTime getDateFromStartAndActualWork(Task task, LocalDateTime date) {
        return this.getResourceAssignmentStream(task).map(r -> this.getDateFromWork((ResourceAssignment)r, date, r.getActualWork())).max(Comparator.naturalOrder()).orElseGet(null);
    }

    private LocalDateTime getDateFromFinishAndWork(Task task, LocalDateTime date) {
        return this.getResourceAssignmentStream(task).map(r -> this.getDateFromWork((ResourceAssignment)r, date, r.getWork().negate())).min(Comparator.naturalOrder()).orElseGet(null);
    }

    private LocalDateTime getDateFromFinishAndRemainingWork(Task task, LocalDateTime date) {
        return this.getResourceAssignmentStream(task).map(r -> this.getDateFromWork((ResourceAssignment)r, date, r.getRemainingWork().negate())).min(Comparator.naturalOrder()).orElseGet(null);
    }

    private LocalDateTime getDateFromWork(ResourceAssignment assignment, LocalDateTime date, Duration work) {
        double units = assignment.getUnits().doubleValue();
        if (units != 100.0) {
            work = Duration.getInstance(work.getDuration() * 100.0 / units, work.getUnits());
        }
        return assignment.getEffectiveCalendar().getDate(date, work);
    }

    private LocalDateTime getEquivalentPreviousWorkFinish(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return this.getEquivalentPreviousWorkFinish(task.getEffectiveCalendar(), date);
        }
        return this.getResourceAssignmentStream(task).map(r -> this.getEquivalentPreviousWorkFinish(r.getEffectiveCalendar(), date)).max(Comparator.naturalOrder()).orElse(null);
    }

    private LocalDateTime getEquivalentPreviousWorkFinish(ProjectCalendar calendar, LocalDateTime date) {
        LocalDateTime previousWorkFinish = calendar.getPreviousWorkFinish(date);
        if (calendar.getWork(previousWorkFinish, date, TimeUnit.HOURS).getDuration() == 0.0) {
            return previousWorkFinish;
        }
        return date;
    }

    private LocalDateTime getNextWorkStart(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return this.getNextWorkStart(task, task.getEffectiveCalendar(), date);
        }
        return this.getResourceAssignmentStream(task).map(r -> this.getNextWorkStart(task, r.getEffectiveCalendar(), date)).min(Comparator.naturalOrder()).orElse(null);
    }

    private LocalDateTime getNextWorkStart(Task task, ProjectCalendar calendar, LocalDateTime date) {
        LocalDateTime nextWorkStart = calendar.getNextWorkStart(date);
        if (nextWorkStart.isAfter(date) && task.getMilestone() && calendar.getPreviousWorkFinish(date).isEqual(date)) {
            return date;
        }
        return nextWorkStart;
    }

    private Stream<ResourceAssignment> getResourceAssignmentStream(Task task) {
        return task.getResourceAssignments().stream().filter(r -> r.getResource() != null && r.getResource().getType() == ResourceType.WORK && r.getUnits().doubleValue() > 0.0);
    }

    private boolean isAlap(Relation relation) {
        return relation.getPredecessorTask().getConstraintType() == ConstraintType.AS_LATE_AS_POSSIBLE && relation.getSuccessorTask().getConstraintType() != ConstraintType.AS_LATE_AS_POSSIBLE && this.m_backwardPass;
    }

    private ConstraintType getConstraintType(Task task) {
        return task.getConstraintType() == null ? ConstraintType.AS_SOON_AS_POSSIBLE : task.getConstraintType();
    }

    static {
        DURATION_UNITS_MAP.put(TimeUnit.MINUTES, TimeUnit.ELAPSED_MINUTES);
        DURATION_UNITS_MAP.put(TimeUnit.HOURS, TimeUnit.ELAPSED_HOURS);
        DURATION_UNITS_MAP.put(TimeUnit.DAYS, TimeUnit.ELAPSED_DAYS);
        DURATION_UNITS_MAP.put(TimeUnit.WEEKS, TimeUnit.ELAPSED_WEEKS);
        DURATION_UNITS_MAP.put(TimeUnit.MONTHS, TimeUnit.ELAPSED_MONTHS);
        DURATION_UNITS_MAP.put(TimeUnit.YEARS, TimeUnit.ELAPSED_YEARS);
    }
}

