/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.cpm;

import java.io.File;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mpxj.ProjectFile;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TimeUnit;
import org.mpxj.common.NumberHelper;
import org.mpxj.cpm.CpmException;
import org.mpxj.cpm.MicrosoftScheduler;
import org.mpxj.reader.UniversalProjectReader;

public class MicrosoftSchedulerComparator {
    private boolean m_debug;
    private boolean m_directory;
    private ProjectFile m_baselineFile;
    private ProjectFile m_workingFile;
    private int m_forwardErrorCount;
    private int m_backwardErrorCount;
    private Set<String> m_unreadableFiles = Collections.emptySet();
    private Set<String> m_useScheduled = Collections.emptySet();
    private Set<String> m_excluded = Collections.emptySet();

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.out.println("Usage: MicrosoftSchedulerComparator <file or folder>");
            return;
        }
        File target = new File(argv[0]);
        MicrosoftSchedulerComparator test = new MicrosoftSchedulerComparator();
        test.setDebug(true);
        if (target.isDirectory()) {
            test.process(target, ".mpp");
        } else {
            test.process(target);
        }
    }

    public void setDebug(boolean value) {
        this.m_debug = value;
    }

    public void setUnreadableFiles(Set<String> value) {
        this.m_unreadableFiles = value;
    }

    public void setUseScheduled(Set<String> value) {
        this.m_useScheduled = value;
    }

    public void setExcluded(Set<String> value) {
        this.m_excluded = value;
    }

    public boolean process(File directory, String suffix) throws Exception {
        File[] fileList = directory.listFiles((dir, name) -> name.toLowerCase().endsWith(suffix));
        if (fileList == null) {
            throw new IllegalArgumentException();
        }
        this.m_directory = true;
        int failed = 0;
        int skipped = 0;
        int valid = 0;
        int success = 0;
        for (File file : fileList) {
            String name2 = file.getName().toLowerCase();
            if (this.m_unreadableFiles.contains(name2) || this.m_useScheduled.contains(name2)) continue;
            ++valid;
            if (this.m_excluded.contains(name2)) {
                ++skipped;
                continue;
            }
            if (this.process(file)) {
                ++success;
                continue;
            }
            ++failed;
        }
        if (this.m_debug) {
            System.out.println();
            System.out.println("Files: " + fileList.length);
            System.out.println("Skipped: " + skipped);
            System.out.println("Success: " + success);
            System.out.println("Failed: " + failed);
            System.out.println("Success %: " + (double)success * 100.0 / (double)valid);
        }
        return failed == 0;
    }

    public boolean process(File file) throws Exception {
        if (this.m_debug) {
            System.out.print("Processing " + file + " ... ");
        }
        this.m_forwardErrorCount = 0;
        this.m_backwardErrorCount = 0;
        this.m_baselineFile = new UniversalProjectReader().read(file);
        this.m_workingFile = new UniversalProjectReader().read(file);
        MicrosoftScheduler scheduler = new MicrosoftScheduler();
        try {
            scheduler.schedule(this.m_workingFile, this.m_workingFile.getProjectProperties().getStartDate());
        }
        catch (CpmException ex) {
            if (this.m_debug) {
                System.out.println("failed.");
                System.out.println(ex.getMessage());
            }
            return false;
        }
        for (Task baselineTask : this.m_baselineFile.getTasks()) {
            Task workingTask = this.m_workingFile.getTaskByUniqueID(baselineTask.getUniqueID());
            if (NumberHelper.getInt(baselineTask.getID()) == 0) continue;
            this.compare(baselineTask, workingTask);
        }
        if (this.m_forwardErrorCount == 0 && this.m_backwardErrorCount == 0) {
            if (this.m_debug) {
                System.out.println("done.");
            }
            return true;
        }
        if (this.m_debug) {
            System.out.println("failed.");
            System.out.println("Forward errors: " + this.m_forwardErrorCount);
            System.out.println("Backward errors: " + this.m_backwardErrorCount);
        }
        if (!this.m_directory && this.m_debug) {
            this.analyseFailures(scheduler);
            System.out.println("DONE");
        }
        return false;
    }

    private void compare(Task baseline, Task working) {
        boolean lateFinishFailed;
        boolean finishFailed;
        boolean earlyStartFailed = !this.compareDates(baseline, working, TaskField.EARLY_START);
        boolean earlyFinishFailed = !this.compareDates(baseline, working, TaskField.EARLY_FINISH);
        boolean startFailed = !this.compareDates(baseline, working, TaskField.START);
        boolean bl = finishFailed = !this.compareDates(baseline, working, TaskField.FINISH);
        if (earlyStartFailed || earlyFinishFailed || startFailed || finishFailed) {
            ++this.m_forwardErrorCount;
        }
        boolean lateStartFailed = !this.compareDates(baseline, working, TaskField.LATE_START);
        boolean bl2 = lateFinishFailed = !this.compareDates(baseline, working, TaskField.LATE_FINISH);
        if (lateStartFailed || lateFinishFailed) {
            ++this.m_backwardErrorCount;
        }
    }

    private boolean compareDates(Task baseline, Task working, TaskField field) {
        LocalDateTime baselineDate = (LocalDateTime)baseline.get(field);
        if (baselineDate == null) {
            return true;
        }
        LocalDateTime workingDate = (LocalDateTime)working.get(field);
        if (workingDate == null) {
            return false;
        }
        if (baselineDate.isEqual(workingDate)) {
            return true;
        }
        double result = Math.abs(baseline.getEffectiveCalendar().getWork(baselineDate, workingDate, TimeUnit.MINUTES).getDuration());
        return result < 0.29;
    }

    private void analyseFailures(MicrosoftScheduler scheduler) {
        List<Task> tasks = scheduler.getSortedTasks();
        List<Task> wbs = this.m_workingFile.getTasks().stream().filter(Task::getSummary).collect(Collectors.toList());
        Collections.reverse(wbs);
        if (this.m_forwardErrorCount != 0) {
            tasks.forEach(this::analyseForwardError);
            wbs.forEach(this::analyseForwardError);
        }
        if (this.m_backwardErrorCount != 0) {
            Collections.reverse(tasks);
            tasks.forEach(this::analyseBackwardError);
            wbs.forEach(this::analyseBackwardError);
        }
    }

    private void analyseForwardError(Task working) {
        Task baseline = this.m_baselineFile.getTaskByUniqueID(working.getUniqueID());
        boolean earlyStartFail = !this.compareDates(baseline, working, TaskField.EARLY_START);
        boolean earlyFinishFail = !this.compareDates(baseline, working, TaskField.EARLY_FINISH);
        boolean startFail = !this.compareDates(baseline, working, TaskField.START);
        boolean finishFail = !this.compareDates(baseline, working, TaskField.FINISH);
        System.out.println((working.getActivityID() == null ? "" : working.getActivityID() + " ") + working);
        System.out.println("Early Start: " + baseline.getEarlyStart() + " " + working.getEarlyStart() + (earlyStartFail ? " FAIL" : ""));
        System.out.println("Early Finish: " + baseline.getEarlyFinish() + " " + working.getEarlyFinish() + (earlyFinishFail ? " FAIL" : ""));
        System.out.println("Start: " + baseline.getStart() + " " + working.getStart() + (startFail ? " FAIL" : ""));
        System.out.println("Finish: " + baseline.getFinish() + " " + working.getFinish() + (finishFail ? " FAIL" : ""));
        System.out.println();
    }

    private void analyseBackwardError(Task working) {
        Task baseline = this.m_baselineFile.getTaskByUniqueID(working.getUniqueID());
        boolean lateStartFail = !this.compareDates(baseline, working, TaskField.LATE_START);
        boolean lateFinishFail = !this.compareDates(baseline, working, TaskField.LATE_FINISH);
        System.out.println((working.getActivityID() == null ? "" : working.getActivityID() + " ") + working);
        System.out.println("Late Start: " + baseline.getLateStart() + " " + working.getLateStart() + (lateStartFail ? " FAIL" : ""));
        System.out.println("Late Finish: " + baseline.getLateFinish() + " " + working.getLateFinish() + (lateFinishFail ? " FAIL" : ""));
        System.out.println();
    }
}

