/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.cpm;

import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mpxj.AssignmentField;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectFile;
import org.mpxj.ResourceAssignment;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.cpm.CpmException;
import org.mpxj.cpm.CycleException;
import org.mpxj.cpm.DepthFirstGraphSort;
import org.mpxj.cpm.PrimaveraScheduler;
import org.mpxj.reader.UniversalProjectReader;

public class PrimaveraSchedulerComparator {
    private boolean m_debug;
    private boolean m_directory;
    private int m_forwardErrorCount;
    private int m_backwardErrorCount;
    private int m_assignmentErrorCount;
    private Set<String> m_unreadableFiles = Collections.emptySet();
    private Set<String> m_useScheduled = Collections.emptySet();
    private Set<String> m_excluded = Collections.emptySet();
    private Set<String> m_noWbsTest = Collections.emptySet();
    private Set<String> m_noResourceAssignmentTest = Collections.emptySet();

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.out.println("Usage: PrimaveraSchedulerComparator <file or folder>");
            return;
        }
        File target = new File(argv[0]);
        PrimaveraSchedulerComparator test = new PrimaveraSchedulerComparator();
        test.setDebug(true);
        if (target.isDirectory()) {
            test.process(target, ".xer");
        } else {
            test.process(target);
        }
    }

    public void setDebug(boolean value) {
        this.m_debug = value;
    }

    public void setUnreadableFiles(Set<String> value) {
        this.m_unreadableFiles = value;
    }

    public void setUseScheduled(Set<String> value) {
        this.m_useScheduled = value;
    }

    public void setExcluded(Set<String> value) {
        this.m_excluded = value;
    }

    public void setNoWbsTest(Set<String> value) {
        this.m_noWbsTest = value;
    }

    public void setNoResourceAssignmentTest(Set<String> value) {
        this.m_noResourceAssignmentTest = value;
    }

    public boolean process(File directory, String suffix) throws Exception {
        File[] fileList = directory.listFiles((dir, name) -> name.toLowerCase().endsWith(suffix));
        if (fileList == null) {
            throw new IllegalArgumentException();
        }
        this.m_directory = true;
        int failed = 0;
        int skipped = 0;
        int valid = 0;
        int success = 0;
        for (File file : fileList) {
            String name2 = file.getName().toLowerCase();
            if (this.m_unreadableFiles.contains(name2) || this.m_useScheduled.contains(name2)) continue;
            ++valid;
            if (this.m_excluded.contains(name2)) {
                ++skipped;
                continue;
            }
            if (this.process(file)) {
                ++success;
                continue;
            }
            ++failed;
        }
        if (this.m_debug) {
            System.out.println();
            System.out.println("Files: " + fileList.length);
            System.out.println("Skipped: " + skipped);
            System.out.println("Success: " + success);
            System.out.println("Failed: " + failed);
            System.out.println("Success %: " + (double)success * 100.0 / (double)valid);
        }
        return failed == 0;
    }

    public boolean process(File file) throws Exception {
        if (this.m_debug) {
            System.out.print("Processing " + file + " ... ");
        }
        ProjectFile baselineFile = new UniversalProjectReader().read(file);
        ProjectFile workingFile = new UniversalProjectReader().read(file);
        PrimaveraScheduler scheduler = new PrimaveraScheduler();
        try {
            LocalDateTime start = workingFile.getProjectProperties().getPlannedStart();
            if (start == null) {
                start = workingFile.getProjectProperties().getStartDate();
            }
            scheduler.schedule(workingFile, start);
        }
        catch (CpmException ex) {
            if (this.m_debug) {
                System.out.println("failed.");
                System.out.println(ex.getMessage());
            }
            return false;
        }
        String fileName = file.getName().toLowerCase();
        return this.process(baselineFile, workingFile, !this.m_noWbsTest.contains(fileName), !this.m_noResourceAssignmentTest.contains(fileName));
    }

    public boolean process(ProjectFile baselineFile, ProjectFile workingFile, boolean analyseWbs, boolean analyseResourceAssignments) throws Exception {
        this.m_forwardErrorCount = 0;
        this.m_backwardErrorCount = 0;
        this.m_assignmentErrorCount = 0;
        for (Task baselineTask : baselineFile.getTasks()) {
            Task workingTask = workingFile.getTaskByUniqueID(baselineTask.getUniqueID());
            if (workingTask.getSummary() && !analyseWbs) continue;
            this.compare(baselineTask, workingTask);
            if (!analyseResourceAssignments) continue;
            for (ResourceAssignment baselineAssignment : baselineTask.getResourceAssignments()) {
                ResourceAssignment workingAssignment = (ResourceAssignment)workingFile.getResourceAssignments().getByUniqueID(baselineAssignment.getUniqueID());
                this.compare(baselineAssignment, workingAssignment);
            }
        }
        if (this.m_forwardErrorCount == 0 && this.m_backwardErrorCount == 0 && this.m_assignmentErrorCount == 0) {
            if (this.m_debug) {
                System.out.println("done.");
            }
            return true;
        }
        if (this.m_debug) {
            System.out.println("failed.");
            System.out.println("Project ID: " + baselineFile.getProjectProperties().getProjectID());
            System.out.println((Object)baselineFile.getProjectProperties().getSchedulingProgressedActivities());
            System.out.println("Forward errors: " + this.m_forwardErrorCount);
            System.out.println("Backward errors: " + this.m_backwardErrorCount);
            System.out.println("Assignment errors: " + this.m_assignmentErrorCount);
        }
        if (!this.m_directory && this.m_debug) {
            this.analyseFailures(baselineFile, workingFile, analyseWbs);
            System.out.println("DONE");
        }
        return false;
    }

    private void compare(Task baseline, Task working) {
        boolean remainingLateFinishFailed;
        boolean remainingEarlyFinishFailed;
        boolean earlyStartFailed = !this.compareDates(baseline, working, TaskField.EARLY_START);
        boolean earlyFinishFailed = !this.compareDates(baseline, working, TaskField.EARLY_FINISH);
        boolean startFailed = !this.compareDates(baseline, working, TaskField.START);
        boolean finishFailed = !this.compareDates(baseline, working, TaskField.FINISH);
        boolean actualStartFailed = !this.compareDates(baseline, working, TaskField.ACTUAL_START);
        boolean actualFinishFailed = !this.compareDates(baseline, working, TaskField.ACTUAL_FINISH);
        boolean remainingEarlyStartFailed = !this.compareDates(baseline, working, TaskField.REMAINING_EARLY_START);
        boolean bl = remainingEarlyFinishFailed = !this.compareDates(baseline, working, TaskField.REMAINING_EARLY_FINISH);
        if (earlyStartFailed || earlyFinishFailed || startFailed || finishFailed || actualStartFailed || actualFinishFailed || remainingEarlyStartFailed || remainingEarlyFinishFailed) {
            ++this.m_forwardErrorCount;
        }
        boolean lateStartFailed = !this.compareDates(baseline, working, TaskField.LATE_START);
        boolean lateFinishFailed = !this.compareDates(baseline, working, TaskField.LATE_FINISH);
        boolean remainingLateStartFailed = !this.compareDates(baseline, working, TaskField.REMAINING_LATE_START);
        boolean bl2 = remainingLateFinishFailed = !this.compareDates(baseline, working, TaskField.REMAINING_LATE_FINISH);
        if (lateStartFailed || lateFinishFailed || remainingLateStartFailed || remainingLateFinishFailed) {
            ++this.m_backwardErrorCount;
        }
    }

    private boolean compareDates(Task baseline, Task working, TaskField field) {
        boolean result;
        LocalDateTime baselineDate = (LocalDateTime)baseline.get(field);
        if (baselineDate == null) {
            return true;
        }
        LocalDateTime workingDate = (LocalDateTime)working.get(field);
        if (workingDate == null) {
            return false;
        }
        if (baselineDate.isEqual(workingDate)) {
            return true;
        }
        ProjectCalendar calendar = baseline.getEffectiveCalendar();
        boolean bl = result = calendar.getNextWorkStart(workingDate).isEqual(baselineDate) || calendar.getNextWorkStart(baselineDate).isEqual(workingDate);
        if (result || !working.getSummary()) {
            return result;
        }
        result = this.allChildTasks(working).stream().map(Task::getEffectiveCalendar).anyMatch(c -> c.getNextWorkStart(workingDate).isEqual(baselineDate) || c.getNextWorkStart(baselineDate).isEqual(workingDate));
        return result;
    }

    private void analyseFailures(ProjectFile baselineFile, ProjectFile workingFile, boolean analyseWbs) throws CycleException {
        List<Task> activities = new DepthFirstGraphSort(workingFile, PrimaveraScheduler::isActivity).sort();
        List<Task> levelOfEffortActivities = new DepthFirstGraphSort(workingFile, PrimaveraScheduler::isLevelOfEffortActivity).sort();
        List<Task> wbsSummaryActivities = new DepthFirstGraphSort(workingFile, PrimaveraScheduler::isWbsSummary).sort();
        List<Task> wbs = workingFile.getTasks().stream().filter(Task::getSummary).collect(Collectors.toList());
        Collections.reverse(wbs);
        if (this.m_forwardErrorCount != 0) {
            activities.forEach(a -> this.analyseForwardError(baselineFile, (Task)a));
            levelOfEffortActivities.forEach(a -> this.analyseForwardError(baselineFile, (Task)a));
            wbsSummaryActivities.forEach(a -> this.analyseForwardError(baselineFile, (Task)a));
            if (analyseWbs) {
                wbs.forEach(a -> this.analyseForwardError(baselineFile, (Task)a));
            }
        }
        if (this.m_backwardErrorCount != 0) {
            Collections.reverse(activities);
            Collections.reverse(levelOfEffortActivities);
            activities.forEach(a -> this.analyseBackwardError(baselineFile, (Task)a));
            levelOfEffortActivities.forEach(a -> this.analyseBackwardError(baselineFile, (Task)a));
            wbsSummaryActivities.forEach(a -> this.analyseBackwardError(baselineFile, (Task)a));
            if (analyseWbs) {
                wbs.forEach(a -> this.analyseBackwardError(baselineFile, (Task)a));
            }
        }
    }

    private void analyseForwardError(ProjectFile baselineFile, Task working) {
        Task baseline = baselineFile.getTaskByUniqueID(working.getUniqueID());
        boolean earlyStartFail = !this.compareDates(baseline, working, TaskField.EARLY_START);
        boolean earlyFinishFail = !this.compareDates(baseline, working, TaskField.EARLY_FINISH);
        boolean startFail = !this.compareDates(baseline, working, TaskField.START);
        boolean finishFail = !this.compareDates(baseline, working, TaskField.FINISH);
        boolean actualStartFail = !this.compareDates(baseline, working, TaskField.ACTUAL_START);
        boolean actualFinishFail = !this.compareDates(baseline, working, TaskField.ACTUAL_FINISH);
        boolean remainingEarlyStartFail = !this.compareDates(baseline, working, TaskField.REMAINING_EARLY_START);
        boolean remainingEarlyFinishFail = !this.compareDates(baseline, working, TaskField.REMAINING_EARLY_FINISH);
        System.out.println((working.getActivityID() == null ? "" : working.getActivityID() + " ") + working);
        System.out.println("Early Start: " + baseline.getEarlyStart() + " " + working.getEarlyStart() + (earlyStartFail ? " FAIL" : ""));
        System.out.println("Early Finish: " + baseline.getEarlyFinish() + " " + working.getEarlyFinish() + (earlyFinishFail ? " FAIL" : ""));
        System.out.println("Start: " + baseline.getStart() + " " + working.getStart() + (startFail ? " FAIL" : ""));
        System.out.println("Finish: " + baseline.getFinish() + " " + working.getFinish() + (finishFail ? " FAIL" : ""));
        System.out.println("Actual Start: " + baseline.getActualStart() + " " + working.getActualStart() + (actualStartFail ? " FAIL" : ""));
        System.out.println("Actual Finish: " + baseline.getActualFinish() + " " + working.getActualFinish() + (actualFinishFail ? " FAIL" : ""));
        System.out.println("Remaining Early Start: " + baseline.getRemainingEarlyStart() + " " + working.getRemainingEarlyStart() + (remainingEarlyStartFail ? " FAIL" : ""));
        System.out.println("Remaining Early Finish: " + baseline.getRemainingEarlyFinish() + " " + working.getRemainingEarlyFinish() + (remainingEarlyFinishFail ? " FAIL" : ""));
        System.out.println();
    }

    private void analyseBackwardError(ProjectFile baselineFile, Task working) {
        Task baseline = baselineFile.getTaskByUniqueID(working.getUniqueID());
        boolean lateStartFail = !this.compareDates(baseline, working, TaskField.LATE_START);
        boolean lateFinishFail = !this.compareDates(baseline, working, TaskField.LATE_FINISH);
        boolean remainingLateStartFail = !this.compareDates(baseline, working, TaskField.REMAINING_LATE_START);
        boolean remainingLateFinishFail = !this.compareDates(baseline, working, TaskField.REMAINING_LATE_FINISH);
        System.out.println((working.getActivityID() == null ? "" : working.getActivityID() + " ") + working);
        System.out.println("Late Start: " + baseline.getLateStart() + " " + working.getLateStart() + (lateStartFail ? " FAIL" : ""));
        System.out.println("Late Finish: " + baseline.getLateFinish() + " " + working.getLateFinish() + (lateFinishFail ? " FAIL" : ""));
        System.out.println("Remaining Late Start: " + baseline.getRemainingLateStart() + " " + working.getRemainingLateStart() + (remainingLateStartFail ? " FAIL" : ""));
        System.out.println("Remaining Late Finish: " + baseline.getRemainingLateFinish() + " " + working.getRemainingLateFinish() + (remainingLateFinishFail ? " FAIL" : ""));
        System.out.println();
    }

    private List<Task> allChildTasks(Task parent) {
        ArrayList<Task> result = new ArrayList<Task>(parent.getChildTasks());
        for (Task task : parent.getChildTasks()) {
            result.addAll(this.allChildTasks(task));
        }
        return result;
    }

    private void compare(ResourceAssignment baseline, ResourceAssignment working) {
        boolean remainingLateFinishFailed;
        boolean startFailed = !this.compareDates(baseline, working, AssignmentField.START);
        boolean finishFailed = !this.compareDates(baseline, working, AssignmentField.FINISH);
        boolean actualStartFailed = !this.compareDates(baseline, working, AssignmentField.ACTUAL_START);
        boolean actualFinishFailed = !this.compareDates(baseline, working, AssignmentField.ACTUAL_FINISH);
        boolean remainingEarlyStartFailed = !this.compareDates(baseline, working, AssignmentField.REMAINING_EARLY_START);
        boolean remainingEarlyFinishFailed = !this.compareDates(baseline, working, AssignmentField.REMAINING_EARLY_FINISH);
        boolean remainingLateStartFailed = !this.compareDates(baseline, working, AssignmentField.REMAINING_LATE_START);
        boolean bl = remainingLateFinishFailed = !this.compareDates(baseline, working, AssignmentField.REMAINING_LATE_FINISH);
        if (startFailed || finishFailed || actualStartFailed || actualFinishFailed || remainingEarlyStartFailed || remainingEarlyFinishFailed || remainingLateStartFailed || remainingLateFinishFailed) {
            ++this.m_assignmentErrorCount;
        }
    }

    private boolean compareDates(ResourceAssignment baseline, ResourceAssignment working, AssignmentField field) {
        LocalDateTime baselineDate = (LocalDateTime)baseline.get(field);
        if (baselineDate == null) {
            return true;
        }
        LocalDateTime workingDate = (LocalDateTime)working.get(field);
        if (workingDate == null) {
            return false;
        }
        if (baselineDate.isEqual(workingDate)) {
            return true;
        }
        ProjectCalendar calendar = baseline.getEffectiveCalendar();
        return calendar.getNextWorkStart(workingDate).isEqual(baselineDate) || calendar.getNextWorkStart(baselineDate).isEqual(workingDate);
    }
}

