/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.edrawproject;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.InputStream;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.mpxj.CostRateTable;
import org.mpxj.CostRateTableEntry;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.LocalTimeRange;
import org.mpxj.MPXJException;
import org.mpxj.Priority;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceType;
import org.mpxj.Task;
import org.mpxj.TaskMode;
import org.mpxj.TimeUnit;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.HierarchyHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.UnmarshalHelper;
import org.mpxj.edrawproject.schema.Document;
import org.mpxj.reader.AbstractProjectStreamReader;
import org.xml.sax.SAXException;

public final class EdrawProjectReader
extends AbstractProjectStreamReader {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private static final Map<Integer, ResourceType> RESOURCE_TYPE_MAP = new HashMap<Integer, ResourceType>();
    private static final Map<Integer, TimeUnit> RATE_TIME_UNIT_MAP;
    private static final Map<Integer, DayOfWeek> DAY_OF_WEEK_MAP;
    private static final Map<Integer, Priority> PRIORITY_MAP;
    private static final Map<Integer, RelationType> RELATION_TYPE_MAP;
    private static final LocalDateTime EPOCH;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoWBS(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoTaskUniqueID(false);
            config.setAutoTaskID(false);
            config.setAutoWBS(false);
            this.m_projectFile.getProjectProperties().setFileApplication("Edraw Project");
            this.m_projectFile.getProjectProperties().setFileType("EDPX");
            this.addListenersToProject(this.m_projectFile);
            Document document = (Document)UnmarshalHelper.unmarshal(CONTEXT, stream);
            this.processProperties(document);
            this.processCalendars(document);
            this.processResources(document);
            this.processTasks(document);
            this.m_projectFile.readComplete();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (JAXBException | ParserConfigurationException | SAXException ex) {
            throw new MPXJException("Failed to parse file", (Exception)ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_eventManager = null;
        }
    }

    private void processProperties(Document document) {
        ProjectProperties props = this.m_projectFile.getProjectProperties();
        props.setCreationDate(document.getCreationDate().getV());
        props.setLastSaved(document.getLastSaved().getV());
        props.setAuthor(document.getCreator().getV());
        props.setLastAuthor(document.getModifier().getV());
        props.setMinutesPerDay(document.getMinutesPerDay().getV());
        props.setMinutesPerWeek(document.getMinutesPerWeek().getV());
        props.setDaysPerMonth(document.getDaysPerMonth().getV());
    }

    private void processCalendars(Document document) {
        document.getCalendars().getCalendar().forEach(this::processCalendar);
        ProjectCalendar defaultCalendar = this.m_projectFile.getCalendarByUniqueID(document.getCalendarUID().getV());
        this.m_projectFile.setDefaultCalendar(defaultCalendar);
    }

    private void processCalendar(Document.Calendars.Calendar xml) {
        ProjectCalendar calendar = this.m_projectFile.addCalendar();
        calendar.setUniqueID(xml.getUID());
        calendar.setName(xml.getName());
        this.processDays(calendar, xml);
        this.processExceptions(calendar, xml);
        this.m_eventManager.fireCalendarReadEvent(calendar);
    }

    private void processDays(ProjectCalendar calendar, Document.Calendars.Calendar xml) {
        if (xml.getWeekDays() == null) {
            return;
        }
        xml.getWeekDays().getWeekDay().forEach(d -> this.processDay(calendar, (Document.Calendars.Calendar.WeekDays.WeekDay)d));
    }

    private void processDay(ProjectCalendar calendar, Document.Calendars.Calendar.WeekDays.WeekDay xml) {
        if (NumberHelper.getInt(xml.getDayType()) == 0) {
            return;
        }
        DayOfWeek day = DAY_OF_WEEK_MAP.get(xml.getDayType());
        boolean workingDay = BooleanHelper.getBoolean(xml.isDayWorking());
        calendar.setWorkingDay(day, workingDay);
        if (workingDay) {
            ProjectCalendarHours hours = calendar.addCalendarHours(day);
            for (Document.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime xmlTime : xml.getWorkingTimes().getWorkingTime()) {
                hours.add(new LocalTimeRange(xmlTime.getFromTime(), xmlTime.getToTime()));
            }
        }
    }

    private void processExceptions(ProjectCalendar calendar, Document.Calendars.Calendar xml) {
        if (xml.getExceptions() == null) {
            return;
        }
        xml.getExceptions().getException().forEach(e -> this.processException(calendar, (Document.Calendars.Calendar.Exceptions.Exception)e));
    }

    private void processException(ProjectCalendar calendar, Document.Calendars.Calendar.Exceptions.Exception xml) {
        ProjectCalendarException exception = calendar.addCalendarException(xml.getTimePeriod().getFromDate().toLocalDate(), xml.getTimePeriod().getToDate().toLocalDate());
        if (xml.getWorkingTimes() == null) {
            return;
        }
        xml.getWorkingTimes().getWorkingTime().forEach(w -> exception.add(new LocalTimeRange(w.getFromTime(), w.getToTime())));
    }

    private void processResources(Document document) {
        if (document.getResourceInfo() == null) {
            return;
        }
        document.getResourceInfo().getColumn().forEach(this::processResource);
    }

    private void processResource(Document.ResourceInfo.Column xml) {
        Resource resource = this.m_projectFile.addResource();
        resource.setUniqueID(xml.getID());
        resource.setName(xml.getName());
        resource.setEmailAddress(xml.getEmail());
        resource.setNotes(xml.getNotes());
        resource.setType(RESOURCE_TYPE_MAP.getOrDefault(xml.getType(), ResourceType.WORK));
        resource.setGroup(xml.getGroup());
        Rate standardRate = new Rate(xml.getCost(), RATE_TIME_UNIT_MAP.getOrDefault(xml.getCostUnit(), TimeUnit.HOURS));
        Rate overtimeRate = new Rate(xml.getOvertimeCost(), RATE_TIME_UNIT_MAP.getOrDefault(xml.getOvertimeUnit(), TimeUnit.HOURS));
        CostRateTableEntry entry = new CostRateTableEntry(LocalDateTimeHelper.START_DATE_NA, LocalDateTimeHelper.END_DATE_NA, (Number)xml.getCostPer(), standardRate, overtimeRate);
        CostRateTable table = new CostRateTable();
        table.add(entry);
        resource.setCostRateTable(0, table);
        this.m_eventManager.fireResourceReadEvent(resource);
    }

    private void processTasks(Document document) {
        if (document.getTaskList() == null || document.getTaskList().getTask().isEmpty()) {
            return;
        }
        List<Document.TaskList.Task> tasks = HierarchyHelper.sortHierarchy(document.getTaskList().getTask(), Document.TaskList.Task::getID, Document.TaskList.Task::getParentID, Comparator.comparing(Document.TaskList.Task::getRowID));
        tasks.forEach(this::processTask);
    }

    private void processTask(Document.TaskList.Task xml) {
        Task parent = this.m_projectFile.getTaskByUniqueID(xml.getParentID());
        double percentComplete = NumberHelper.getDouble(xml.getPercent()) * 100.0;
        Task task = (parent == null ? this.m_projectFile : parent).addTask();
        task.setMilestone(BooleanHelper.getBoolean(xml.isMilestone()));
        task.setCritical(BooleanHelper.getBoolean(xml.isCriticalPath()));
        task.setUniqueID(xml.getID());
        task.setID(xml.getRowID());
        task.setBaselineStart(xml.getDateBaseStart());
        task.setBaselineFinish(xml.getDateBaseFinish());
        task.setBaselineCost(xml.getBaselineCost());
        task.setDuration(this.getDuration(xml.getDurationSecs(), xml.getDurationUnits()));
        task.setLateStart(xml.getDateLateStart());
        task.setActualStart(this.getDateFromLong(xml.getActualStart()));
        task.setWork(Duration.getInstance(NumberHelper.getDouble(xml.getWork()), TimeUnit.HOURS));
        task.setCost(xml.getCost());
        task.setStart(xml.getDateStart());
        task.setName(xml.getName());
        task.setActualFinish(this.getDateFromLong(xml.getActualFinish()));
        task.setLateFinish(xml.getDateLateFinish());
        task.setPriority(PRIORITY_MAP.get(xml.getPriority()));
        task.setFinish(xml.getDateFinish());
        task.setWBS(xml.getWbs());
        task.setNotes(xml.getNotes());
        task.setPercentageComplete(percentComplete);
        task.setRemainingCost(xml.getRemainingCost());
        task.setTaskMode(BooleanHelper.getBoolean(xml.isManual()) ? TaskMode.MANUALLY_SCHEDULED : TaskMode.AUTO_SCHEDULED);
        double actualDuration = task.getDuration().getDuration() * percentComplete / 100.0;
        double remainingDuration = task.getDuration().getDuration() - actualDuration;
        task.setActualDuration(Duration.getInstance(actualDuration, task.getDuration().getUnits()));
        task.setRemainingDuration(Duration.getInstance(remainingDuration, task.getDuration().getUnits()));
        this.m_eventManager.fireTaskReadEvent(task);
        this.processResourceAssignments(task, xml.getResourceList());
        this.processRelationships(task, xml.getPredecessorLink());
    }

    private void processResourceAssignments(Task task, Document.TaskList.Task.ResourceList xml) {
        if (xml == null || xml.getResource().isEmpty()) {
            return;
        }
        xml.getResource().forEach(a -> this.processResourceAssignment(task, (Document.TaskList.Task.ResourceList.Resource)a));
    }

    private void processResourceAssignment(Task task, Document.TaskList.Task.ResourceList.Resource xml) {
        Resource resource = this.m_projectFile.getResourceByUniqueID(xml.getID());
        if (resource == null) {
            return;
        }
        ResourceAssignment assignment = task.addResourceAssignment(resource);
        assignment.setUnits(NumberHelper.getDouble(xml.getPercent()) * 100.0);
        assignment.setWork(this.getDuration(xml.getWorkSecs(), 5));
        this.m_eventManager.fireAssignmentReadEvent(assignment);
    }

    private void processRelationships(Task task, List<Document.TaskList.Task.PredecessorLink> xml) {
        if (xml == null || xml.isEmpty()) {
            return;
        }
        xml.forEach(r -> this.processRelationship(task, (Document.TaskList.Task.PredecessorLink)r));
    }

    private void processRelationship(Task task, Document.TaskList.Task.PredecessorLink xml) {
        Task predecessor = this.m_projectFile.getTaskByUniqueID(xml.getPredecessorUID());
        if (predecessor == null) {
            return;
        }
        Relation relation = task.addPredecessor(new Relation.Builder().predecessorTask(predecessor).type(RELATION_TYPE_MAP.getOrDefault(xml.getType(), RelationType.FINISH_START)).lag(this.getDuration(xml.getLinkLag() * 6L, xml.getLagFormat())));
        this.m_eventManager.fireRelationReadEvent(relation);
    }

    private Duration getDuration(Long seconds, Integer units) {
        TimeUnit durationUnits;
        if (seconds == null || seconds == -1L || seconds == 0xFFFFFFFFL) {
            return null;
        }
        double durationValue = seconds.doubleValue();
        switch (units) {
            case 6: {
                durationValue /= 60.0;
                durationUnits = TimeUnit.MINUTES;
                break;
            }
            case 5: {
                durationValue /= 3600.0;
                durationUnits = TimeUnit.HOURS;
                break;
            }
            case 7: 
            case 10: {
                durationValue /= 60.0 * (double)NumberHelper.getInt(this.m_projectFile.getProjectProperties().getMinutesPerDay());
                durationUnits = TimeUnit.DAYS;
                break;
            }
            case 8: {
                durationValue /= 60.0 * (double)NumberHelper.getInt(this.m_projectFile.getProjectProperties().getMinutesPerWeek());
                durationUnits = TimeUnit.WEEKS;
                break;
            }
            case 9: {
                durationValue /= 60.0 * (double)NumberHelper.getInt(this.m_projectFile.getProjectProperties().getMinutesPerDay()) * (double)NumberHelper.getInt(this.m_projectFile.getProjectProperties().getDaysPerMonth());
                durationUnits = TimeUnit.MONTHS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported duration units: " + units);
            }
        }
        return Duration.getInstance(durationValue, durationUnits);
    }

    private LocalDateTime getDateFromLong(Long value) {
        if (value == null || value == 0L) {
            return null;
        }
        return EPOCH.plusSeconds(value);
    }

    static {
        RESOURCE_TYPE_MAP.put(0, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put(1, ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put(2, ResourceType.COST);
        RATE_TIME_UNIT_MAP = new HashMap<Integer, TimeUnit>();
        RATE_TIME_UNIT_MAP.put(0, TimeUnit.MINUTES);
        RATE_TIME_UNIT_MAP.put(1, TimeUnit.HOURS);
        RATE_TIME_UNIT_MAP.put(2, TimeUnit.DAYS);
        RATE_TIME_UNIT_MAP.put(3, TimeUnit.DAYS);
        RATE_TIME_UNIT_MAP.put(4, TimeUnit.WEEKS);
        RATE_TIME_UNIT_MAP.put(5, TimeUnit.MONTHS);
        DAY_OF_WEEK_MAP = new HashMap<Integer, DayOfWeek>();
        DAY_OF_WEEK_MAP.put(1, DayOfWeek.SUNDAY);
        DAY_OF_WEEK_MAP.put(2, DayOfWeek.MONDAY);
        DAY_OF_WEEK_MAP.put(3, DayOfWeek.TUESDAY);
        DAY_OF_WEEK_MAP.put(4, DayOfWeek.WEDNESDAY);
        DAY_OF_WEEK_MAP.put(5, DayOfWeek.THURSDAY);
        DAY_OF_WEEK_MAP.put(6, DayOfWeek.FRIDAY);
        DAY_OF_WEEK_MAP.put(7, DayOfWeek.SATURDAY);
        PRIORITY_MAP = new HashMap<Integer, Priority>();
        PRIORITY_MAP.put(1, Priority.getInstance(900));
        PRIORITY_MAP.put(2, Priority.getInstance(600));
        PRIORITY_MAP.put(3, Priority.getInstance(500));
        PRIORITY_MAP.put(4, Priority.getInstance(400));
        PRIORITY_MAP.put(5, Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<Integer, RelationType>();
        RELATION_TYPE_MAP.put(0, RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put(1, RelationType.FINISH_START);
        RELATION_TYPE_MAP.put(2, RelationType.START_FINISH);
        RELATION_TYPE_MAP.put(3, RelationType.START_START);
        EPOCH = LocalDateTime.of(1970, 1, 1, 1, 0);
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"org.mpxj.edrawproject.schema", (ClassLoader)EdrawProjectReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

