/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.fasttrack;

import java.io.PrintWriter;
import org.mpxj.fasttrack.AbstractColumn;
import org.mpxj.fasttrack.FastTrackUtility;
import org.mpxj.fasttrack.StringsWithLengthBlock;

class AssignmentColumn1
extends AbstractColumn {
    private String[] m_options;

    AssignmentColumn1() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 14;
    }

    @Override
    protected int readData(byte[] buffer, int offset) {
        if (FastTrackUtility.getByte(buffer, offset) == 1) {
            offset += 2;
        } else {
            StringsWithLengthBlock options = new StringsWithLengthBlock().read(buffer, offset += 20, false);
            this.m_options = options.getData();
            offset = options.getOffset();
            if (FastTrackUtility.getByte(buffer, offset + 1) == 1) {
                int stringLength = FastTrackUtility.getInt(buffer, offset += 4);
                offset += 4;
                offset += stringLength;
            }
            offset += 8;
        }
        StringsWithLengthBlock data = new StringsWithLengthBlock().read(buffer, offset, true);
        this.m_data = data.getData();
        offset = data.getOffset();
        return offset;
    }

    @Override
    protected void dumpData(PrintWriter pw) {
        if (this.m_options != null) {
            pw.println("  [Options");
            for (String string : this.m_options) {
                pw.println("    " + (String)string);
            }
            pw.println("  ]");
        }
        pw.println("  [Data");
        for (Object object : this.m_data) {
            pw.println("    " + object);
        }
        pw.println("  ]");
    }
}

