/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.fasttrack;

import java.io.PrintWriter;
import org.mpxj.fasttrack.AbstractColumn;
import org.mpxj.fasttrack.FastTrackUtility;
import org.mpxj.fasttrack.StringsWithLengthBlock;

class BooleanColumn
extends AbstractColumn {
    private String[] m_options;

    BooleanColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 34;
    }

    @Override
    protected int readData(byte[] buffer, int offset) {
        StringsWithLengthBlock options = new StringsWithLengthBlock().read(buffer, offset, false);
        this.m_options = options.getData();
        offset = options.getOffset();
        offset = FastTrackUtility.skipToNextMatchingShort(buffer, offset, 15);
        int numberOfItems = FastTrackUtility.getInt(buffer, offset) + 1;
        FastTrackUtility.validateSize(numberOfItems);
        this.m_data = new Boolean[numberOfItems];
        offset += 4;
        offset += 4;
        offset += this.m_data.length * 4;
        offset += 4;
        for (int index = 0; index < this.m_data.length; ++index) {
            int value = FastTrackUtility.getShort(buffer, offset);
            offset += 2;
            if (value == 2) continue;
            this.m_data[index] = value == 1;
        }
        return offset;
    }

    @Override
    protected void dumpData(PrintWriter pw) {
        pw.println("  [Options");
        for (String string : this.m_options) {
            pw.println("    " + string);
        }
        pw.println("  ]");
        pw.println("  [Data");
        for (Object object : this.m_data) {
            pw.println("    " + object);
        }
        pw.println("  ]");
    }
}

