/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.fasttrack;

import java.io.PrintWriter;
import org.mpxj.fasttrack.AbstractColumn;
import org.mpxj.fasttrack.FastTrackUtility;
import org.mpxj.fasttrack.FixedSizeItemsBlock;

abstract class DurationColumn
extends AbstractColumn {
    private int m_timeUnitValue;

    DurationColumn() {
    }

    @Override
    protected int readData(byte[] buffer, int offset) {
        FixedSizeItemsBlock data = new FixedSizeItemsBlock().read(buffer, offset);
        offset = data.getOffset();
        this.m_timeUnitValue = FastTrackUtility.getByte(buffer, offset);
        byte[][] rawData = data.getData();
        this.m_data = new Double[rawData.length];
        for (int index = 0; index < rawData.length; ++index) {
            Double durationValue = FastTrackUtility.getDouble(rawData[index], 0);
            if (durationValue != null && this.m_timeUnitValue == 10) {
                durationValue = durationValue * 3.0;
            }
            this.m_data[index] = durationValue;
        }
        return offset;
    }

    @Override
    protected void dumpData(PrintWriter pw) {
        pw.println("  [Data");
        for (Object item : this.m_data) {
            pw.println("    " + item);
        }
        pw.println("  ]");
    }

    public int getTimeUnitValue() {
        return this.m_timeUnitValue;
    }
}

