/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.fasttrack;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;
import org.mpxj.Duration;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.fasttrack.FastTrackField;
import org.mpxj.fasttrack.FastTrackTable;

class MapRow {
    protected final Map<FastTrackField, Object> m_map;
    private final FastTrackTable m_table;

    public MapRow(FastTrackTable table, Map<FastTrackField, Object> map) {
        this.m_table = table;
        this.m_map = map;
    }

    public String getString(FastTrackField type) {
        return (String)this.getObject(type);
    }

    public Integer getInteger(FastTrackField type) {
        return (Integer)this.getObject(type);
    }

    public Double getDouble(FastTrackField type) {
        return (Double)this.getObject(type);
    }

    public Double getCurrency(FastTrackField type) {
        return this.getDouble(type);
    }

    public boolean getBoolean(FastTrackField type) {
        boolean result = false;
        Object value = this.getObject(type);
        if (value != null) {
            result = BooleanHelper.getBoolean((Boolean)value);
        }
        return result;
    }

    public int getInt(FastTrackField type) {
        return NumberHelper.getInt((Number)this.getObject(type));
    }

    public LocalDateTime getTimestamp(FastTrackField dateName, FastTrackField timeName) {
        LocalDateTime result = null;
        LocalDate date = this.getDate(dateName);
        if (date != null) {
            Object timeObject = this.getObject(timeName);
            if (timeObject instanceof LocalTime) {
                LocalTime time = (LocalTime)timeObject;
                result = LocalDateTime.of(date, time);
            } else {
                result = date.atStartOfDay();
            }
        }
        return result;
    }

    public LocalDateTime getTimestamp(FastTrackField dateName) {
        LocalDateTime result = null;
        LocalDate date = this.getDate(dateName);
        if (date != null) {
            result = date.atStartOfDay();
        }
        return result;
    }

    public LocalDate getDate(FastTrackField type) {
        return (LocalDate)this.getObject(type);
    }

    public Duration getDuration(FastTrackField type) {
        Double value = (Double)this.getObject(type);
        return value == null ? null : Duration.getInstance(value, this.m_table.getDurationTimeUnit());
    }

    public Duration getWork(FastTrackField type) {
        Double value = (Double)this.getObject(type);
        return value == null ? null : Duration.getInstance(value, this.m_table.getWorkTimeUnit());
    }

    public Object getObject(FastTrackField type) {
        return this.m_map.get(type);
    }

    public UUID getUUID(FastTrackField type) {
        String value = this.getString(type);
        UUID result = null;
        if (value != null && value.length() >= 36) {
            if (value.startsWith("{")) {
                value = value.substring(1, value.length() - 1);
            }
            if (value.length() > 16) {
                value = value.substring(0, 36);
            }
            result = UUID.fromString(value);
        }
        return result;
    }

    public Map<FastTrackField, Object> getMap() {
        return this.m_map;
    }
}

