/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.fasttrack;

import java.io.PrintWriter;
import org.mpxj.fasttrack.AbstractColumn;
import org.mpxj.fasttrack.FastTrackUtility;

class StringColumn2
extends AbstractColumn {
    StringColumn2() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 0;
    }

    @Override
    protected int readData(byte[] buffer, int offset) {
        int index;
        int structureFlags = FastTrackUtility.getByte(buffer, offset += 2);
        ++offset;
        offset = structureFlags == 0 ? (offset += 33) : FastTrackUtility.skipToNextMatchingShort(buffer, offset, 15);
        int numberOfItems = FastTrackUtility.getInt(buffer, offset);
        FastTrackUtility.validateSize(numberOfItems);
        this.m_data = new String[numberOfItems];
        offset += 4;
        offset += 4;
        int[] blockOffsets = new int[this.m_data.length + 1];
        for (index = 0; index < blockOffsets.length; ++index) {
            int offsetInBlock;
            blockOffsets[index] = offsetInBlock = FastTrackUtility.getInt(buffer, offset);
            offset += 4;
        }
        offset += 4;
        for (index = 0; index < this.m_data.length; ++index) {
            int itemNameLength = blockOffsets[index + 1] - blockOffsets[index];
            FastTrackUtility.validateSize(itemNameLength);
            this.m_data[index] = FastTrackUtility.getString(buffer, offset, itemNameLength);
            offset += itemNameLength;
        }
        return offset;
    }

    @Override
    protected void dumpData(PrintWriter pw) {
        pw.println("  [Data");
        if (this.m_data != null) {
            for (Object item : this.m_data) {
                pw.println("    " + item);
            }
        }
        pw.println("  ]");
    }
}

