/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.fasttrack;

import org.mpxj.fasttrack.FastTrackUtility;

class StringsWithLengthBlock {
    private String[] m_data;
    private int m_offset;

    StringsWithLengthBlock() {
    }

    public StringsWithLengthBlock read(byte[] buffer, int offset, boolean inclusive) {
        int numberOfItems = FastTrackUtility.getInt(buffer, offset);
        offset += 4;
        FastTrackUtility.validateSize(numberOfItems);
        if (inclusive) {
            ++numberOfItems;
        }
        this.m_data = new String[numberOfItems];
        for (int index = 0; index < this.m_data.length; ++index) {
            int itemNameLength = FastTrackUtility.getInt(buffer, offset += 2);
            this.m_data[index] = FastTrackUtility.getString(buffer, offset += 4, itemNameLength);
            offset += itemNameLength;
        }
        this.m_offset = offset;
        return this;
    }

    public String[] getData() {
        return this.m_data;
    }

    public int getOffset() {
        return this.m_offset;
    }
}

