/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.fasttrack;

import java.io.PrintWriter;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.mpxj.fasttrack.AbstractColumn;
import org.mpxj.fasttrack.FastTrackUtility;
import org.mpxj.fasttrack.FixedSizeItemsBlock;

class TimeColumn
extends AbstractColumn {
    TimeColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 48;
    }

    @Override
    protected int readData(byte[] buffer, int offset) {
        FixedSizeItemsBlock data = new FixedSizeItemsBlock().read(buffer, offset);
        offset = data.getOffset();
        byte[][] rawData = data.getData();
        this.m_data = new LocalTime[rawData.length];
        for (int index = 0; index < rawData.length; ++index) {
            if (rawData[index].length <= 1) continue;
            int value = FastTrackUtility.getShort(rawData[index], 0);
            this.m_data[index] = LocalTime.of(value / 60 % 24, value % 60);
        }
        return offset;
    }

    @Override
    protected void dumpData(PrintWriter pw) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        pw.println("  [Data");
        for (Object item : this.m_data) {
            pw.println("    " + df.format((LocalTime)item));
        }
        pw.println("  ]");
    }
}

