/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.merlin;

import java.io.File;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.mpxj.Availability;
import org.mpxj.ConstraintType;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.LocalTimeRange;
import org.mpxj.MPXJException;
import org.mpxj.Priority;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceType;
import org.mpxj.ScheduleFrom;
import org.mpxj.Task;
import org.mpxj.TimeUnit;
import org.mpxj.UnitOfMeasureContainer;
import org.mpxj.common.AutoCloseableHelper;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.SQLite;
import org.mpxj.merlin.Row;
import org.mpxj.reader.AbstractProjectFileReader;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class MerlinReader
extends AbstractProjectFileReader {
    private ProjectFile m_project;
    private EventManager m_eventManager;
    private final Integer m_projectID = 1;
    private Connection m_connection;
    private DocumentBuilder m_documentBuilder;
    private final DateTimeFormatter m_calendarTimeFormat = DateTimeFormatter.ofPattern("HH:mm:ss");
    private XPathExpression m_dayTimeIntervals;
    private Map<String, Integer> m_entityMap;

    @Override
    public ProjectFile read(File file) throws MPXJException {
        File databaseFile = file.isDirectory() ? new File(file, "state.sql") : file;
        return this.readFile(databaseFile);
    }

    private ProjectFile readFile(File file) throws MPXJException {
        try {
            this.m_connection = SQLite.createConnection(file);
            this.m_documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            this.m_dayTimeIntervals = xpath.compile("/array/dayTimeInterval");
            this.m_entityMap = new HashMap<String, Integer>();
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (Exception ex) {
            throw new MPXJException("Invalid format", ex);
        }
        finally {
            AutoCloseableHelper.closeQuietly(this.m_connection);
            this.m_documentBuilder = null;
            this.m_dayTimeIntervals = null;
            this.m_entityMap = null;
        }
    }

    private ProjectFile read() throws Exception {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoCalendarUniqueID(false);
        config.setAutoTaskUniqueID(false);
        config.setAutoResourceUniqueID(false);
        config.setAutoRelationUniqueID(false);
        this.m_project.getProjectProperties().setFileApplication("Merlin");
        this.m_project.getProjectProperties().setFileType("SQLITE");
        this.addListenersToProject(this.m_project);
        this.populateEntityMap();
        this.processProject();
        this.processCalendars();
        this.processResources();
        this.processTasks();
        this.processAssignments();
        this.processDependencies();
        this.m_project.readComplete();
        return this.m_project;
    }

    private void populateEntityMap() throws SQLException {
        for (Row row : this.getRows("select * from z_primarykey", new Integer[0])) {
            this.m_entityMap.put(row.getString("Z_NAME"), row.getInteger("Z_ENT"));
        }
    }

    private void processProject() throws SQLException {
        ProjectProperties props = this.m_project.getProjectProperties();
        Row row = this.getRows("select * from zproject where z_pk=?", this.m_projectID).get(0);
        props.setWeekStartDay(DayOfWeekHelper.getInstance(row.getInt("ZFIRSTDAYOFWEEK") + 1));
        props.setScheduleFrom(row.getInt("ZSCHEDULINGDIRECTION") == 1 ? ScheduleFrom.START : ScheduleFrom.FINISH);
        props.setMinutesPerDay(row.getInt("ZHOURSPERDAY") * 60);
        props.setDaysPerMonth(row.getInteger("ZDAYSPERMONTH"));
        props.setMinutesPerWeek(row.getInt("ZHOURSPERWEEK") * 60);
        props.setStatusDate(row.getTimestamp("ZGIVENSTATUSDATE"));
        props.setCurrencySymbol(row.getString("ZCURRENCYSYMBOL"));
        props.setName(row.getString("ZTITLE"));
        props.setGUID(row.getUUID("ZUNIQUEID"));
    }

    private void processCalendars() throws Exception {
        List<Row> rows = this.getRows("select * from zcalendar where zproject=?", this.m_projectID);
        ProjectCalendar defaultCalendar = null;
        for (Row row : rows) {
            ProjectCalendar calendar = this.m_project.addCalendar();
            calendar.setUniqueID(row.getInteger("Z_PK"));
            calendar.setName(row.getString("ZTITLE"));
            this.processDays(calendar);
            this.processExceptions(calendar);
            this.m_eventManager.fireCalendarReadEvent(calendar);
            if (NumberHelper.getInt(row.getInteger("Z_OPT")) != 5) continue;
            defaultCalendar = calendar;
        }
        if (defaultCalendar == null) {
            defaultCalendar = this.m_project.getCalendars().findOrCreateDefaultCalendar();
        }
        this.m_project.setDefaultCalendar(defaultCalendar);
    }

    private void processDays(ProjectCalendar calendar) throws Exception {
        for (DayOfWeek day : DayOfWeek.values()) {
            calendar.setWorkingDay(day, false);
            calendar.addCalendarHours(day);
        }
        List<Row> rows = this.getRows("select * from zcalendarrule where zcalendar1=? and z_ent=?", calendar.getUniqueID(), this.m_entityMap.get("CalendarWeekDayRule"));
        for (Row row : rows) {
            DayOfWeek day;
            day = row.getDay("ZWEEKDAY");
            String timeIntervals = row.getString("ZTIMEINTERVALS");
            ProjectCalendarHours hours = calendar.getCalendarHours(day);
            if (timeIntervals == null) {
                calendar.setWorkingDay(day, false);
                continue;
            }
            NodeList nodes = this.getNodeList(timeIntervals, this.m_dayTimeIntervals);
            calendar.setWorkingDay(day, nodes.getLength() > 0);
            for (int loop = 0; loop < nodes.getLength(); ++loop) {
                NamedNodeMap attributes = nodes.item(loop).getAttributes();
                LocalTime startTime = LocalTime.parse(attributes.getNamedItem("startTime").getTextContent(), this.m_calendarTimeFormat);
                LocalTime endTime = LocalTime.parse(attributes.getNamedItem("endTime").getTextContent(), this.m_calendarTimeFormat);
                hours.add(new LocalTimeRange(startTime, endTime));
            }
        }
    }

    private void processExceptions(ProjectCalendar calendar) throws Exception {
        List<Row> rows = this.getRows("select * from zcalendarrule where zcalendar=? and z_ent=?", calendar.getUniqueID(), this.m_entityMap.get("CalendarExceptionRule"));
        for (Row row : rows) {
            LocalDate startDay = LocalDateHelper.getLocalDate(row.getDate("ZSTARTDAY"));
            LocalDate endDay = LocalDateHelper.getLocalDate(row.getDate("ZENDDAY"));
            ProjectCalendarException exception = calendar.addCalendarException(startDay, endDay);
            String timeIntervals = row.getString("ZTIMEINTERVALS");
            if (timeIntervals == null) continue;
            NodeList nodes = this.getNodeList(timeIntervals, this.m_dayTimeIntervals);
            for (int loop = 0; loop < nodes.getLength(); ++loop) {
                NamedNodeMap attributes = nodes.item(loop).getAttributes();
                LocalTime startTime = LocalTime.parse(attributes.getNamedItem("startTime").getTextContent(), this.m_calendarTimeFormat);
                LocalTime endTime = LocalTime.parse(attributes.getNamedItem("endTime").getTextContent(), this.m_calendarTimeFormat);
                exception.add(new LocalTimeRange(startTime, endTime));
            }
        }
    }

    private void processResources() throws SQLException {
        List<Row> rows = this.getRows("select * from zresource where zproject=? order by zorderinproject", this.m_projectID);
        UnitOfMeasureContainer uom = this.m_project.getUnitsOfMeasure();
        for (Row row : rows) {
            ProjectCalendar calendar;
            Integer calendarID;
            Resource resource = this.m_project.addResource();
            resource.setUniqueID(row.getInteger("Z_PK"));
            resource.setEmailAddress(row.getString("ZEMAIL"));
            resource.setInitials(row.getString("ZINITIALS"));
            resource.setName(row.getString("ZTITLE_"));
            resource.setGUID(row.getUUID("ZUNIQUEID"));
            resource.setType(row.getResourceType("ZTYPE"));
            resource.setUnitOfMeasure(uom.getOrCreateByAbbreviation(row.getString("ZMATERIALUNIT")));
            if (resource.getType() == ResourceType.WORK) {
                resource.getAvailability().add(new Availability(LocalDateTimeHelper.START_DATE_NA, LocalDateTimeHelper.END_DATE_NA, NumberHelper.getDouble(row.getDouble("ZAVAILABLEUNITS_")) * 100.0));
            }
            if ((calendarID = row.getInteger("ZRESOURCECALENDAR")) != null && (calendar = this.m_project.getCalendarByUniqueID(calendarID)) != null) {
                String name = resource.getName();
                if (name == null || name.isEmpty()) {
                    name = "Unnamed Resource";
                }
                calendar.setName(name);
                resource.setCalendar(calendar);
            }
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processTasks() throws SQLException {
        List<Row> rows = this.getRows("select * from zscheduleitem where zproject=? and zparentactivity_ is null and z_ent=? order by zorderinparentactivity", this.m_projectID, this.m_entityMap.get("Activity"));
        for (Row row : rows) {
            Task task = this.m_project.addTask();
            this.populateTask(row, task);
            this.processChildTasks(task);
        }
    }

    private void processChildTasks(Task parentTask) throws SQLException {
        List<Row> rows = this.getRows("select * from zscheduleitem where zparentactivity_=? and z_ent=? order by zorderinparentactivity", parentTask.getUniqueID(), this.m_entityMap.get("Activity"));
        for (Row row : rows) {
            Task task = parentTask.addTask();
            this.populateTask(row, task);
            this.processChildTasks(task);
        }
    }

    private void populateTask(Row row, Task task) {
        ProjectCalendar calendar;
        task.setUniqueID(row.getInteger("Z_PK"));
        task.setName(row.getString("ZTITLE"));
        task.setPriority(Priority.getInstance(row.getInt("ZPRIORITY")));
        task.setMilestone(row.getBoolean("ZISMILESTONE"));
        task.setActualFinish(row.getTimestamp("ZGIVENACTUALENDDATE_"));
        task.setActualStart(row.getTimestamp("ZGIVENACTUALSTARTDATE_"));
        task.setNotes(row.getString("ZOBJECTDESCRIPTION"));
        task.setDuration(row.getDuration("ZGIVENDURATION_"));
        task.setOvertimeWork(row.getWork("ZGIVENWORKOVERTIME_"));
        task.setWork(row.getWork("ZGIVENWORK_"));
        task.setLevelingDelay(row.getDuration("ZLEVELINGDELAY_"));
        task.setActualOvertimeWork(row.getWork("ZGIVENACTUALWORKOVERTIME_"));
        task.setActualWork(row.getWork("ZGIVENACTUALWORK_"));
        task.setRemainingWork(row.getWork("ZGIVENACTUALWORK_"));
        task.setGUID(row.getUUID("ZUNIQUEID"));
        Integer calendarID = row.getInteger("ZGIVENCALENDAR");
        if (calendarID != null && (calendar = this.m_project.getCalendarByUniqueID(calendarID)) != null) {
            task.setCalendar(calendar);
        }
        this.populateConstraints(row, task);
        this.m_eventManager.fireTaskReadEvent(task);
    }

    private void populateConstraints(Row row, Task task) {
        LocalDateTime endDateMax = row.getTimestamp("ZGIVENENDDATEMAX_");
        LocalDateTime endDateMin = row.getTimestamp("ZGIVENENDDATEMIN_");
        LocalDateTime startDateMax = row.getTimestamp("ZGIVENSTARTDATEMAX_");
        LocalDateTime startDateMin = row.getTimestamp("ZGIVENSTARTDATEMIN_");
        ConstraintType constraintType = null;
        LocalDateTime constraintDate = null;
        if (endDateMax != null) {
            constraintType = ConstraintType.FINISH_NO_LATER_THAN;
            constraintDate = endDateMax;
        }
        if (endDateMin != null) {
            constraintType = ConstraintType.FINISH_NO_EARLIER_THAN;
            constraintDate = endDateMin;
        }
        if (endDateMin != null && endDateMin == endDateMax) {
            constraintType = ConstraintType.MUST_FINISH_ON;
            constraintDate = endDateMin;
        }
        if (startDateMax != null) {
            constraintType = ConstraintType.START_NO_LATER_THAN;
            constraintDate = startDateMax;
        }
        if (startDateMin != null) {
            constraintType = ConstraintType.START_NO_EARLIER_THAN;
            constraintDate = startDateMin;
        }
        if (startDateMin != null && startDateMin == endDateMax) {
            constraintType = ConstraintType.MUST_START_ON;
            constraintDate = endDateMin;
        }
        task.setConstraintType(constraintType);
        task.setConstraintDate(constraintDate);
    }

    private void processAssignments() throws SQLException {
        List<Row> rows = this.getRows("select * from zscheduleitem where zproject=? and z_ent=? order by zorderinactivity", this.m_projectID, this.m_entityMap.get("Assignment"));
        for (Row row : rows) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("ZACTIVITY_"));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("ZRESOURCE"));
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setGUID(row.getUUID("ZUNIQUEID"));
            assignment.setActualFinish(row.getTimestamp("ZGIVENACTUALENDDATE_"));
            assignment.setActualStart(row.getTimestamp("ZGIVENACTUALSTARTDATE_"));
            assignment.setWork(this.assignmentDuration(task, row.getWork("ZGIVENWORK_")));
            assignment.setOvertimeWork(this.assignmentDuration(task, row.getWork("ZGIVENWORKOVERTIME_")));
            assignment.setActualWork(this.assignmentDuration(task, row.getWork("ZGIVENACTUALWORK_")));
            assignment.setActualOvertimeWork(this.assignmentDuration(task, row.getWork("ZGIVENACTUALWORKOVERTIME_")));
            assignment.setRemainingWork(this.assignmentDuration(task, row.getWork("ZGIVENREMAININGWORK_")));
            assignment.setLevelingDelay(row.getDuration("ZLEVELINGDELAY_"));
            if (assignment.getRemainingWork() == null) {
                assignment.setRemainingWork(assignment.getWork());
            }
            if (resource.getType() != ResourceType.WORK) continue;
            assignment.setUnits(NumberHelper.getDouble(row.getDouble("ZRESOURCEUNITS_")) * 100.0);
        }
    }

    private Duration assignmentDuration(Task task, Duration work) {
        Duration taskWork;
        Duration result = work;
        if (result != null && result.getUnits() == TimeUnit.PERCENT && (taskWork = task.getWork()) != null) {
            result = Duration.getInstance(taskWork.getDuration() * result.getDuration(), taskWork.getUnits());
        }
        return result;
    }

    private void processDependencies() throws SQLException {
        List<Row> rows = this.getRows("select * from zdependency where zproject=?", this.m_projectID);
        for (Row row : rows) {
            Task nextTask = this.m_project.getTaskByUniqueID(row.getInteger("ZNEXTACTIVITY_"));
            Task prevTask = this.m_project.getTaskByUniqueID(row.getInteger("ZPREVIOUSACTIVITY_"));
            nextTask.addPredecessor(new Relation.Builder().predecessorTask(prevTask).type(row.getRelationType("ZTYPE")).lag(row.getDuration("ZLAG_")).uniqueID(row.getInteger("Z_PK")));
        }
    }

    /*
     * Exception decompiling
     */
    private List<Row> getRows(String sql, Integer ... values) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private NodeList getNodeList(String document, XPathExpression expression) throws Exception {
        Document doc = this.m_documentBuilder.parse(new InputSource(new StringReader(document)));
        return (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
    }
}

