/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpd;

import org.mpxj.CurrencySymbolPosition;
import org.mpxj.Duration;
import org.mpxj.ProjectFile;
import org.mpxj.TimeUnit;

public final class MPDUtility {
    private static final int DURATION_UNITS_MASK = 31;

    public static CurrencySymbolPosition getSymbolPosition(int value) {
        CurrencySymbolPosition result;
        switch (value) {
            case 1: {
                result = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                result = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                result = CurrencySymbolPosition.AFTER_WITH_SPACE;
                break;
            }
            default: {
                result = CurrencySymbolPosition.BEFORE;
            }
        }
        return result;
    }

    public static final TimeUnit getDurationTimeUnits(int type) {
        TimeUnit units;
        switch (type & 0x1F) {
            case 3: {
                units = TimeUnit.MINUTES;
                break;
            }
            case 4: {
                units = TimeUnit.ELAPSED_MINUTES;
                break;
            }
            case 5: {
                units = TimeUnit.HOURS;
                break;
            }
            case 6: {
                units = TimeUnit.ELAPSED_HOURS;
                break;
            }
            case 8: {
                units = TimeUnit.ELAPSED_DAYS;
                break;
            }
            case 9: {
                units = TimeUnit.WEEKS;
                break;
            }
            case 10: {
                units = TimeUnit.ELAPSED_WEEKS;
                break;
            }
            case 11: {
                units = TimeUnit.MONTHS;
                break;
            }
            case 12: {
                units = TimeUnit.ELAPSED_MONTHS;
                break;
            }
            default: {
                units = TimeUnit.DAYS;
            }
        }
        return units;
    }

    public static Duration getAdjustedDuration(ProjectFile file, int duration, TimeUnit timeUnit) {
        Duration result;
        switch (timeUnit) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                double totalMinutes = (double)duration / 10.0;
                result = Duration.getInstance(totalMinutes, timeUnit);
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                double totalHours = (double)duration / 600.0;
                result = Duration.getInstance(totalHours, timeUnit);
                break;
            }
            case DAYS: {
                double unitsPerDay = file.getProjectProperties().getMinutesPerDay().doubleValue() * 10.0;
                double totalDays = 0.0;
                if (unitsPerDay != 0.0) {
                    totalDays = (double)duration / unitsPerDay;
                }
                result = Duration.getInstance(totalDays, timeUnit);
                break;
            }
            case ELAPSED_DAYS: {
                double unitsPerDay = 14400.0;
                double totalDays = (double)duration / unitsPerDay;
                result = Duration.getInstance(totalDays, timeUnit);
                break;
            }
            case WEEKS: {
                double unitsPerWeek = file.getProjectProperties().getMinutesPerWeek().doubleValue() * 10.0;
                double totalWeeks = 0.0;
                if (unitsPerWeek != 0.0) {
                    totalWeeks = (double)duration / unitsPerWeek;
                }
                result = Duration.getInstance(totalWeeks, timeUnit);
                break;
            }
            case ELAPSED_WEEKS: {
                double unitsPerWeek = 100800.0;
                double totalWeeks = (double)duration / unitsPerWeek;
                result = Duration.getInstance(totalWeeks, timeUnit);
                break;
            }
            case ELAPSED_MONTHS: {
                double unitsPerMonth = 432000.0;
                double totalMonths = (double)duration / unitsPerMonth;
                result = Duration.getInstance(totalMonths, timeUnit);
                break;
            }
            case MONTHS: {
                double totalMonths = (double)duration / 96000.0;
                result = Duration.getInstance(totalMonths, timeUnit);
                break;
            }
            default: {
                result = Duration.getInstance(duration, timeUnit);
            }
        }
        return result;
    }

    public static final Duration getDuration(double value, TimeUnit type) {
        double duration;
        switch (type) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                duration = value / 10.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                duration = value / 600.0;
                break;
            }
            case DAYS: {
                duration = value / 4800.0;
                break;
            }
            case ELAPSED_DAYS: {
                duration = value / 14400.0;
                break;
            }
            case WEEKS: {
                duration = value / 24000.0;
                break;
            }
            case ELAPSED_WEEKS: {
                duration = value / 100800.0;
                break;
            }
            case MONTHS: {
                duration = value / 96000.0;
                break;
            }
            case ELAPSED_MONTHS: {
                duration = value / 432000.0;
                break;
            }
            default: {
                duration = value;
            }
        }
        return Duration.getInstance(duration, type);
    }
}

