/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.time.LocalDateTime;
import java.util.Collections;
import org.mpxj.Availability;
import org.mpxj.AvailabilityTable;
import org.mpxj.Resource;
import org.mpxj.ResourceField;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.mpp.MPPUtility;

final class AvailabilityFactory {
    AvailabilityFactory() {
    }

    public void process(Resource resource, byte[] data) {
        AvailabilityTable table = resource.getAvailability();
        if (data == null) {
            LocalDateTime availableFrom = (LocalDateTime)resource.getCachedValue(ResourceField.AVAILABLE_FROM);
            LocalDateTime availableTo = (LocalDateTime)resource.getCachedValue(ResourceField.AVAILABLE_TO);
            availableFrom = availableFrom == null ? LocalDateTimeHelper.START_DATE_NA : availableFrom;
            availableTo = availableTo == null ? LocalDateTimeHelper.END_DATE_NA : availableTo;
            table.add(new Availability(availableFrom, availableTo, (Number)resource.getCachedValue(ResourceField.MAX_UNITS)));
        } else {
            int items = ByteArrayHelper.getShort(data, 0);
            int offset = 12;
            for (int loop = 0; loop < items; ++loop) {
                double unitsValue = MPPUtility.getDouble(data, offset + 4);
                if (unitsValue != 0.0) {
                    LocalDateTime startDate = MPPUtility.getTimestampFromTenths(data, offset);
                    LocalDateTime endDate = MPPUtility.getTimestampFromTenths(data, offset + 20);
                    endDate = endDate.minusMinutes(1L);
                    Double units = NumberHelper.getDouble(unitsValue / 100.0);
                    if (startDate.isBefore(LocalDateTimeHelper.START_DATE_NA)) {
                        startDate = LocalDateTimeHelper.START_DATE_NA;
                    }
                    if (endDate.isAfter(LocalDateTimeHelper.END_DATE_NA)) {
                        endDate = LocalDateTimeHelper.END_DATE_NA;
                    }
                    Availability item = new Availability(startDate, endDate, units);
                    table.add(item);
                }
                offset += 20;
            }
            Collections.sort(table);
        }
    }
}

