/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.util.HashMap;
import org.mpxj.CustomFieldContainer;
import org.mpxj.DataType;
import org.mpxj.ProjectFile;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.FieldTypeHelper;
import org.mpxj.mpp.EnterpriseCustomFieldDataType;
import org.mpxj.mpp.MPPUtility;

class CustomFieldReader12 {
    private final ProjectFile m_file;
    private final CustomFieldContainer m_fields;
    private final byte[] m_data;

    public CustomFieldReader12(ProjectFile file, byte[] data) {
        this.m_file = file;
        this.m_fields = file.getCustomFields();
        this.m_data = data;
    }

    public void process() {
        int blockSize;
        int definitionIndex;
        if (this.m_data == null) {
            return;
        }
        HashMap<Integer, String> aliasMap = new HashMap<Integer, String>();
        int offset = 0;
        int aliasBlockSize = ByteArrayHelper.getInt(this.m_data, offset);
        int numberOfAliases = ByteArrayHelper.getInt(this.m_data, offset += 8);
        offset += 4;
        for (int index = 0; index < numberOfAliases && offset < aliasBlockSize; ++index) {
            String alias;
            int fieldID = ByteArrayHelper.getInt(this.m_data, offset);
            int aliasOffset = ByteArrayHelper.getInt(this.m_data, offset += 4) + 4;
            offset += 4;
            if (aliasOffset >= this.m_data.length || (alias = MPPUtility.getUnicodeString(this.m_data, aliasOffset)).isEmpty()) continue;
            aliasMap.put(fieldID, alias);
        }
        offset = 4 + aliasBlockSize;
        int unknownBlock1Size = ByteArrayHelper.getInt(this.m_data, offset);
        offset += 4;
        int unknownBlock2Size = ByteArrayHelper.getInt(this.m_data, offset += unknownBlock1Size);
        offset += 4;
        offset += unknownBlock2Size;
        int numberOfDefinitions = ByteArrayHelper.getInt(this.m_data, offset += 8);
        offset += 4;
        for (definitionIndex = 0; definitionIndex < numberOfDefinitions; ++definitionIndex) {
            offset += 8;
        }
        for (definitionIndex = 0; definitionIndex < numberOfDefinitions && offset + 2 <= this.m_data.length && offset + (blockSize = ByteArrayHelper.getShort(this.m_data, offset)) <= this.m_data.length; ++definitionIndex) {
            DataType customFieldDataType = EnterpriseCustomFieldDataType.getDataTypeFromID(ByteArrayHelper.getShort(this.m_data, offset + 12));
            FieldTypeHelper.getInstance(this.m_file, ByteArrayHelper.getInt(this.m_data, offset + 4), customFieldDataType);
            offset += blockSize;
        }
        aliasMap.forEach((k, v) -> this.m_fields.getOrCreate(FieldTypeHelper.getInstance(this.m_file, k)).setAlias((String)v));
    }
}

