/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.util.HashMap;
import org.mpxj.CustomFieldContainer;
import org.mpxj.DataType;
import org.mpxj.ProjectFile;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.FieldTypeHelper;
import org.mpxj.mpp.EnterpriseCustomFieldDataType;
import org.mpxj.mpp.MPPUtility;

class CustomFieldReader14 {
    private final ProjectFile m_file;
    private final CustomFieldContainer m_fields;
    private final byte[] m_data;

    public CustomFieldReader14(ProjectFile file, byte[] data) {
        this.m_file = file;
        this.m_fields = file.getCustomFields();
        this.m_data = data;
    }

    public void process() {
        if (this.m_data == null) {
            return;
        }
        HashMap<Integer, String> aliasMap = new HashMap<Integer, String>();
        int offset = 0;
        int aliasBlockSize = ByteArrayHelper.getInt(this.m_data, offset);
        int numberOfAliases = ByteArrayHelper.getInt(this.m_data, offset += 8);
        offset += 4;
        for (int index = 0; index < numberOfAliases && offset < aliasBlockSize; ++index) {
            String alias;
            int fieldID = ByteArrayHelper.getInt(this.m_data, offset);
            int aliasOffset = ByteArrayHelper.getInt(this.m_data, offset += 4) + 4;
            offset += 4;
            if (aliasOffset >= this.m_data.length || (alias = MPPUtility.getUnicodeString(this.m_data, aliasOffset)).isEmpty()) continue;
            aliasMap.put(fieldID, alias);
        }
        offset = 4 + aliasBlockSize;
        if (offset + 4 > this.m_data.length) {
            return;
        }
        int unknownBlock1Size = ByteArrayHelper.getInt(this.m_data, offset);
        offset += 4;
        if ((offset += unknownBlock1Size) > this.m_data.length) {
            return;
        }
        if (offset + 4 > this.m_data.length) {
            return;
        }
        int unknownBlock2Size = ByteArrayHelper.getInt(this.m_data, offset);
        offset += 4;
        if ((offset += unknownBlock2Size) > this.m_data.length) {
            return;
        }
        if (offset + 8 > this.m_data.length) {
            return;
        }
        int numberOfDefinitions = ByteArrayHelper.getInt(this.m_data, offset);
        offset += 4;
        offset += 4;
        for (int definitionIndex = 0; definitionIndex < numberOfDefinitions && offset + 88 <= this.m_data.length; ++definitionIndex) {
            DataType customFieldDataType = EnterpriseCustomFieldDataType.getDataTypeFromID(ByteArrayHelper.getShort(this.m_data, offset + 12));
            FieldTypeHelper.getInstance(this.m_file, ByteArrayHelper.getInt(this.m_data, offset), customFieldDataType);
            offset += 88;
        }
        aliasMap.forEach((k, v) -> this.m_fields.getOrCreate(FieldTypeHelper.getInstance(this.m_file, k)).setAlias((String)v));
    }
}

