/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.util.ArrayList;
import org.mpxj.Filter;
import org.mpxj.GenericCriteriaPrompt;
import org.mpxj.ProjectFile;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.mpp.CriteriaReader;
import org.mpxj.mpp.FixedData;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.Var2Data;

public abstract class FilterReader {
    protected abstract Integer getVarDataType();

    protected abstract CriteriaReader getCriteriaReader();

    public void process(ProjectFile file, FixedData fixedData, Var2Data varData) {
        int filterCount = fixedData.getItemCount();
        boolean[] criteriaType = new boolean[2];
        CriteriaReader criteriaReader = this.getCriteriaReader();
        for (int filterLoop = 0; filterLoop < filterCount; ++filterLoop) {
            byte[] filterFixedData = fixedData.getByteArrayValue(filterLoop);
            if (filterFixedData == null || filterFixedData.length < 4) continue;
            Filter filter = new Filter();
            filter.setID(ByteArrayHelper.getInt(filterFixedData, 0));
            filter.setName(MPPUtility.removeAmpersands(MPPUtility.getUnicodeString(filterFixedData, 4)));
            byte[] filterVarData = varData.getByteArray(filter.getID(), this.getVarDataType());
            if (filterVarData == null) continue;
            ArrayList<GenericCriteriaPrompt> prompts = new ArrayList<GenericCriteriaPrompt>();
            filter.setShowRelatedSummaryRows(MPPUtility.getByte(filterVarData, 4) != 0);
            filter.setCriteria(criteriaReader.process(file, filterVarData, 0, -1, prompts, null, criteriaType));
            filter.setIsTaskFilter(criteriaType[0]);
            filter.setIsResourceFilter(criteriaType[1]);
            filter.setPrompts(prompts);
            file.getFilters().addFilter(filter);
        }
    }
}

