/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.mpp.FixedData;
import org.mpxj.mpp.FixedMetaItemSizeProvider;
import org.mpxj.mpp.MPPComponent;

final class FixedMeta
extends MPPComponent {
    private final int m_itemCount;
    private final int m_adjustedItemCount;
    private final Object[] m_array;
    private static final int MAGIC = -86004294;
    private static final int HEADER_SIZE = 16;

    FixedMeta(InputStream is, int itemSize) throws IOException {
        this(is, (fileSize, itemCount) -> itemSize);
    }

    FixedMeta(InputStream is, FixedMetaItemSizeProvider itemSizeProvider) throws IOException {
        int fileSize = is.available();
        int magic = this.readInt(is);
        if (magic != -86004294) {
            throw new IOException("Bad magic number: " + magic);
        }
        this.readInt(is);
        this.m_itemCount = this.readInt(is);
        this.readInt(is);
        int itemSize = itemSizeProvider.getItemSize(fileSize, this.m_itemCount);
        this.m_adjustedItemCount = (fileSize - 16) / itemSize;
        this.m_array = new Object[this.m_adjustedItemCount];
        for (int loop = 0; loop < this.m_adjustedItemCount; ++loop) {
            this.m_array[loop] = this.readByteArray(is, itemSize);
        }
    }

    FixedMeta(InputStream is, FixedData otherFixedBlock, int ... itemSizes) throws IOException {
        this(is, (fileSize, itemCount) -> {
            int itemSize = itemSizes[0];
            int available = fileSize - 16;
            int distance = Integer.MIN_VALUE;
            int otherFixedBlockCount = otherFixedBlock.getItemCount();
            for (int testItemSize : itemSizes) {
                if (available % testItemSize != 0) continue;
                if (available / testItemSize == otherFixedBlockCount) {
                    itemSize = testItemSize;
                    break;
                }
                int testDistance = itemCount * testItemSize - available;
                if (testDistance > 0 || testDistance <= distance) continue;
                itemSize = testItemSize;
                distance = testDistance;
            }
            return itemSize;
        });
    }

    public int getItemCount() {
        return this.m_itemCount;
    }

    public int getAdjustedItemCount() {
        return this.m_adjustedItemCount;
    }

    public byte[] getByteArrayValue(int index) {
        byte[] result = null;
        if (index >= 0 && index < this.m_array.length && this.m_array[index] != null) {
            result = (byte[])this.m_array[index];
        }
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN: FixedMeta");
        pw.println("   Adjusted Item count: " + this.m_adjustedItemCount);
        for (int loop = 0; loop < this.m_adjustedItemCount; ++loop) {
            pw.println("   Data at index: " + loop);
            pw.println("  " + ByteArrayHelper.hexdump((byte[])this.m_array[loop], true));
        }
        pw.println("END: FixedMeta");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

