/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import org.mpxj.FieldType;
import org.mpxj.ProjectFile;
import org.mpxj.TaskField;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.FieldTypeHelper;
import org.mpxj.mpp.ChartPattern;
import org.mpxj.mpp.GanttBarMiddleShape;
import org.mpxj.mpp.GanttBarShowForTasks;
import org.mpxj.mpp.GanttBarStartEndShape;
import org.mpxj.mpp.GanttBarStartEndType;
import org.mpxj.mpp.GanttBarStyle;
import org.mpxj.mpp.GanttBarStyleException;
import org.mpxj.mpp.GanttBarStyleFactory;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.Props;

public class GanttBarStyleFactory14
implements GanttBarStyleFactory {
    private static final Integer DEFAULT_PROPERTIES = 574619656;
    private static final Integer EXCEPTION_PROPERTIES = 574619661;
    private static final GanttBarStyle[] EMPTY_STYLES = new GanttBarStyle[0];
    private static final GanttBarStyleException[] EMPTY_EXCEPTIONS = new GanttBarStyleException[0];

    @Override
    public GanttBarStyle[] processDefaultStyles(ProjectFile file, Props props) {
        byte[] barStyleData = props.getByteArray(DEFAULT_PROPERTIES);
        if (barStyleData == null || barStyleData.length <= 2240) {
            return EMPTY_STYLES;
        }
        int barStyleCount = MPPUtility.getByte(barStyleData, 2243);
        if (barStyleCount <= 0) {
            return EMPTY_STYLES;
        }
        GanttBarStyle[] barStyles = new GanttBarStyle[barStyleCount];
        int styleOffset = 2255;
        for (int loop = 0; loop < barStyleCount; ++loop) {
            GanttBarStyle style;
            barStyles[loop] = style = new GanttBarStyle();
            style.setID(ByteArrayHelper.getShort(barStyleData, styleOffset + 89));
            style.setName(MPPUtility.getUnicodeString(barStyleData, styleOffset + 91));
            style.setLeftText(this.getTaskField(file, ByteArrayHelper.getInt(barStyleData, styleOffset + 67)));
            style.setRightText(this.getTaskField(file, ByteArrayHelper.getInt(barStyleData, styleOffset + 71)));
            style.setTopText(this.getTaskField(file, ByteArrayHelper.getInt(barStyleData, styleOffset + 75)));
            style.setBottomText(this.getTaskField(file, ByteArrayHelper.getInt(barStyleData, styleOffset + 79)));
            style.setInsideText(this.getTaskField(file, ByteArrayHelper.getInt(barStyleData, styleOffset + 83)));
            style.setStartShape(GanttBarStartEndShape.getInstance(barStyleData[styleOffset + 15] % 25));
            style.setStartType(GanttBarStartEndType.getInstance(barStyleData[styleOffset + 15] / 25));
            style.setStartColor(MPPUtility.getColor(barStyleData, styleOffset + 16));
            style.setMiddleShape(GanttBarMiddleShape.getInstance(barStyleData[styleOffset]));
            style.setMiddlePattern(ChartPattern.getInstance(barStyleData[styleOffset + 1]));
            style.setMiddleColor(MPPUtility.getColor(barStyleData, styleOffset + 2));
            style.setEndShape(GanttBarStartEndShape.getInstance(barStyleData[styleOffset + 28] % 25));
            style.setEndType(GanttBarStartEndType.getInstance(barStyleData[styleOffset + 28] / 25));
            style.setEndColor(MPPUtility.getColor(barStyleData, styleOffset + 29));
            style.setFromField(this.getTaskField(file, ByteArrayHelper.getInt(barStyleData, styleOffset + 41)));
            style.setToField(this.getTaskField(file, ByteArrayHelper.getInt(barStyleData, styleOffset + 45)));
            this.extractFlags(style, GanttBarShowForTasks.NORMAL, ByteArrayHelper.getLong(barStyleData, styleOffset + 49));
            this.extractFlags(style, GanttBarShowForTasks.NOT_NORMAL, ByteArrayHelper.getLong(barStyleData, styleOffset + 57));
            style.setRow(ByteArrayHelper.getShort(barStyleData, styleOffset + 65) + 1);
            styleOffset += 195;
        }
        return barStyles;
    }

    @Override
    public GanttBarStyleException[] processExceptionStyles(ProjectFile file, Props props) {
        byte[] barData = props.getByteArray(EXCEPTION_PROPERTIES);
        if (barData == null) {
            return EMPTY_EXCEPTIONS;
        }
        GanttBarStyleException[] barStyle = new GanttBarStyleException[barData.length / 71];
        int offset = 0;
        for (int loop = 0; loop < barStyle.length; ++loop) {
            GanttBarStyleException style;
            barStyle[loop] = style = new GanttBarStyleException();
            style.setTaskUniqueID(ByteArrayHelper.getInt(barData, offset));
            style.setGanttBarStyleID(ByteArrayHelper.getShort(barData, offset + 4));
            style.setBarStyleIndex(ByteArrayHelper.getShort(barData, offset + 4) - 1);
            style.setStartShape(GanttBarStartEndShape.getInstance(barData[offset + 20] % 25));
            style.setStartType(GanttBarStartEndType.getInstance(barData[offset + 20] / 25));
            style.setStartColor(MPPUtility.getColor(barData, offset + 21));
            style.setMiddleShape(GanttBarMiddleShape.getInstance(barData[offset + 6]));
            style.setMiddlePattern(ChartPattern.getInstance(barData[offset + 7]));
            style.setMiddleColor(MPPUtility.getColor(barData, offset + 8));
            style.setEndShape(GanttBarStartEndShape.getInstance(barData[offset + 33] % 25));
            style.setEndType(GanttBarStartEndType.getInstance(barData[offset + 33] / 25));
            style.setEndColor(MPPUtility.getColor(barData, offset + 34));
            style.setLeftText(this.getTaskField(file, ByteArrayHelper.getInt(barData, offset + 49)));
            style.setRightText(this.getTaskField(file, ByteArrayHelper.getInt(barData, offset + 53)));
            style.setTopText(this.getTaskField(file, ByteArrayHelper.getInt(barData, offset + 57)));
            style.setBottomText(this.getTaskField(file, ByteArrayHelper.getInt(barData, offset + 61)));
            style.setInsideText(this.getTaskField(file, ByteArrayHelper.getInt(barData, offset + 65)));
            offset += 71;
        }
        return barStyle;
    }

    private void extractFlags(GanttBarStyle style, GanttBarShowForTasks baseCriteria, long flagValue) {
        long flag = 1L;
        for (int index = 0; index < 64; ++index) {
            GanttBarShowForTasks enumValue;
            if ((flagValue & flag) != 0L && (enumValue = GanttBarShowForTasks.getInstance(baseCriteria.getValue() + index)) != null) {
                style.addShowForTasks(enumValue);
            }
            flag <<= 1;
        }
    }

    private FieldType getTaskField(ProjectFile file, int field) {
        FieldType result = FieldTypeHelper.getInstance(file, field);
        if (!(result instanceof TaskField)) {
            return result;
        }
        switch ((TaskField)result) {
            case START_TEXT: {
                result = TaskField.START;
                break;
            }
            case FINISH_TEXT: {
                result = TaskField.FINISH;
                break;
            }
            case DURATION_TEXT: {
                result = TaskField.DURATION;
                break;
            }
        }
        return result;
    }
}

