/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import org.mpxj.MpxjEnum;
import org.mpxj.common.EnumHelper;
import org.mpxj.common.NumberHelper;

public enum LinkStyle implements MpxjEnum
{
    NONE(0, "None"),
    END_TOP(1, "End Top"),
    END_START(2, "End Start");

    private static final LinkStyle[] TYPE_VALUES;
    private final int m_value;
    private final String m_name;

    private LinkStyle(int type, String name) {
        this.m_value = type;
        this.m_name = name;
    }

    public static LinkStyle getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = END_TOP.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static LinkStyle getInstance(Number type) {
        int value = type == null ? -1 : NumberHelper.getInt(type);
        return LinkStyle.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = (LinkStyle[])EnumHelper.createTypeArray(LinkStyle.class);
    }
}

