/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectFile;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.mpp.AbstractCalendarFactory;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.VarMeta;
import org.mpxj.mpp.VarMeta9;

class MPP9CalendarFactory
extends AbstractCalendarFactory {
    private static final Integer CALENDAR_NAME = 1;
    private static final Integer CALENDAR_DATA = 3;

    public MPP9CalendarFactory(ProjectFile file) {
        super(file);
    }

    @Override
    protected int getCalendarIDOffset() {
        return 0;
    }

    @Override
    protected int getBaseIDOffset() {
        return 4;
    }

    @Override
    protected int getResourceIDOffset() {
        return 8;
    }

    @Override
    protected int getCalendarHoursOffset() {
        return 4;
    }

    @Override
    protected Integer getCalendarNameVarDataType() {
        return CALENDAR_NAME;
    }

    @Override
    protected Integer getCalendarDataVarDataType() {
        return CALENDAR_DATA;
    }

    @Override
    protected VarMeta getCalendarVarMeta(DirectoryEntry directory) throws IOException {
        return new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)directory.getEntry("VarMeta")));
    }

    @Override
    protected void processCalendarExceptions(byte[] data, ProjectCalendar cal) {
        int exceptionCount = ByteArrayHelper.getShort(data, 0);
        if (exceptionCount != 0) {
            for (int index = 0; index < exceptionCount; ++index) {
                int offset = 424 + index * 64;
                LocalDate fromDate = LocalDateHelper.getLocalDate(MPPUtility.getDate(data, offset));
                LocalDate toDate = LocalDateHelper.getLocalDate(MPPUtility.getDate(data, offset + 2));
                ProjectCalendarException exception = cal.addCalendarException(fromDate, toDate);
                int periodCount = ByteArrayHelper.getShort(data, offset + 6);
                if (periodCount == 0) continue;
                for (int exceptionPeriodIndex = 0; exceptionPeriodIndex < periodCount; ++exceptionPeriodIndex) {
                    LocalTime start = MPPUtility.getTime(data, offset + 12 + exceptionPeriodIndex * 2);
                    long duration = MPPUtility.getDuration(data, offset + 24 + exceptionPeriodIndex * 4);
                    LocalTime end = start.plus(duration, ChronoUnit.MILLIS);
                    exception.add(new LocalTimeRange(start, end));
                }
            }
        }
    }
}

