/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.Duration;
import org.mpxj.ProjectCalendar;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedItem;
import org.mpxj.TimephasedWork;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.mpp.MPPAbstractTimephasedWorkNormaliser;

public final class MPPTimephasedBaselineWorkNormaliser
extends MPPAbstractTimephasedWorkNormaliser {
    public static final MPPTimephasedBaselineWorkNormaliser INSTANCE = new MPPTimephasedBaselineWorkNormaliser();

    private MPPTimephasedBaselineWorkNormaliser() {
    }

    @Override
    protected void mergeSameDay(ProjectCalendar calendar, List<TimephasedWork> list) {
        ArrayList<TimephasedWork> result = new ArrayList<TimephasedWork>();
        TimephasedItem previousItem = null;
        for (TimephasedWork item : list) {
            LocalDateTime itemStart;
            LocalDateTime itemStartDay;
            LocalDateTime previousItemStart;
            LocalDateTime previousItemStartDay;
            if (previousItem != null && (previousItemStartDay = LocalDateTimeHelper.getDayStartDate(previousItemStart = previousItem.getStart())).equals(itemStartDay = LocalDateTimeHelper.getDayStartDate(itemStart = item.getStart()))) {
                result.remove(result.size() - 1);
                double work = ((Duration)previousItem.getTotalAmount()).getDuration();
                Duration totalWork = Duration.getInstance(work += ((Duration)item.getTotalAmount()).getDuration(), TimeUnit.MINUTES);
                TimephasedWork merged = new TimephasedWork();
                merged.setStart(previousItem.getStart());
                merged.setFinish(item.getFinish());
                merged.setTotalAmount(totalWork);
                item = merged;
            }
            item.setAmountPerDay(item.getTotalAmount());
            result.add(item);
            previousItem = item;
        }
        list.clear();
        list.addAll(result);
    }
}

