/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.util.TreeMap;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.mpp.Props;

final class PropsBlock
extends Props {
    PropsBlock(byte[] data) {
        int dataSize = ByteArrayHelper.getInt(data, 0);
        int itemCount = ByteArrayHelper.getInt(data, 4);
        int offset = 8;
        TreeMap<Integer, Integer> offsetMap = new TreeMap<Integer, Integer>();
        for (int loop = 0; loop < itemCount; ++loop) {
            int itemKey = ByteArrayHelper.getInt(data, offset);
            int itemOffset = ByteArrayHelper.getInt(data, offset += 4);
            offset += 4;
            offsetMap.put(itemOffset, itemKey);
        }
        Integer previousItemOffset = null;
        Integer previousItemKey = null;
        for (Integer itemOffset : offsetMap.keySet()) {
            this.populateMap(data, previousItemOffset, previousItemKey, itemOffset);
            previousItemOffset = itemOffset;
            previousItemKey = (Integer)offsetMap.get(previousItemOffset);
        }
        if (previousItemOffset != null) {
            Integer itemOffset = dataSize;
            this.populateMap(data, previousItemOffset, previousItemKey, itemOffset);
        }
    }

    private void populateMap(byte[] data, Integer previousItemOffset, Integer previousItemKey, Integer itemOffset) {
        if (previousItemOffset != null) {
            int itemSize = itemOffset - previousItemOffset;
            byte[] itemData = new byte[itemSize];
            System.arraycopy(data, previousItemOffset, itemData, 0, itemSize);
            this.m_map.put(previousItemKey, itemData);
        }
    }
}

