/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.time.DayOfWeek;
import org.mpxj.ProjectProperties;
import org.mpxj.RecurrenceType;
import org.mpxj.RecurringTask;
import org.mpxj.Task;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.mpp.MPPUtility;

final class RecurringTaskReader {
    private final ProjectProperties m_properties;

    public RecurringTaskReader(ProjectProperties properties) {
        this.m_properties = properties;
    }

    public void processRecurringTask(Task task, byte[] data) {
        RecurringTask rt = task.addRecurringTask();
        rt.setStartDate(LocalDateHelper.getLocalDate(MPPUtility.getDate(data, 6)));
        rt.setFinishDate(LocalDateHelper.getLocalDate(MPPUtility.getDate(data, 10)));
        rt.setDuration(MPPUtility.getAdjustedDuration(this.m_properties, ByteArrayHelper.getInt(data, 12), MPPUtility.getDurationTimeUnits(ByteArrayHelper.getShort(data, 16))));
        rt.setOccurrences(ByteArrayHelper.getShort(data, 18));
        rt.setRecurrenceType(RecurrenceType.getInstance(ByteArrayHelper.getShort(data, 20)));
        rt.setUseEndDate(ByteArrayHelper.getShort(data, 24) == 1);
        rt.setWorkingDaysOnly(ByteArrayHelper.getShort(data, 26) == 1);
        rt.setWeeklyDay(DayOfWeek.SUNDAY, ByteArrayHelper.getShort(data, 28) == 1);
        rt.setWeeklyDay(DayOfWeek.MONDAY, ByteArrayHelper.getShort(data, 30) == 1);
        rt.setWeeklyDay(DayOfWeek.TUESDAY, ByteArrayHelper.getShort(data, 32) == 1);
        rt.setWeeklyDay(DayOfWeek.WEDNESDAY, ByteArrayHelper.getShort(data, 34) == 1);
        rt.setWeeklyDay(DayOfWeek.THURSDAY, ByteArrayHelper.getShort(data, 36) == 1);
        rt.setWeeklyDay(DayOfWeek.FRIDAY, ByteArrayHelper.getShort(data, 38) == 1);
        rt.setWeeklyDay(DayOfWeek.SATURDAY, ByteArrayHelper.getShort(data, 40) == 1);
        int frequencyOffset = 0;
        int dayOfWeekOffset = 0;
        int dayNumberOffset = 0;
        int monthNumberOffset = 0;
        int dateOffset = 0;
        switch (rt.getRecurrenceType()) {
            case DAILY: {
                frequencyOffset = 46;
                break;
            }
            case WEEKLY: {
                frequencyOffset = 48;
                break;
            }
            case MONTHLY: {
                rt.setRelative(ByteArrayHelper.getShort(data, 42) == 1);
                if (rt.getRelative()) {
                    frequencyOffset = 58;
                    dayNumberOffset = 50;
                    dayOfWeekOffset = 52;
                    break;
                }
                frequencyOffset = 54;
                dayNumberOffset = 56;
                break;
            }
            case YEARLY: {
                rt.setRelative(ByteArrayHelper.getShort(data, 44) != 1);
                if (rt.getRelative()) {
                    dayNumberOffset = 60;
                    dayOfWeekOffset = 62;
                    monthNumberOffset = 64;
                    break;
                }
                dateOffset = 70;
            }
        }
        if (frequencyOffset != 0) {
            rt.setFrequency(ByteArrayHelper.getShort(data, frequencyOffset));
        }
        if (dayOfWeekOffset != 0) {
            rt.setDayOfWeek(DayOfWeekHelper.getInstance(ByteArrayHelper.getShort(data, dayOfWeekOffset) + 1));
        }
        if (dayNumberOffset != 0) {
            rt.setDayNumber(ByteArrayHelper.getShort(data, dayNumberOffset));
        }
        if (monthNumberOffset != 0) {
            rt.setMonthNumber(ByteArrayHelper.getShort(data, monthNumberOffset));
        }
        if (dateOffset != 0) {
            rt.setYearlyAbsoluteFromDate(LocalDateHelper.getLocalDate(MPPUtility.getDate(data, dateOffset)));
        }
    }
}

