/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.mpxj.AssignmentField;
import org.mpxj.Duration;
import org.mpxj.FieldTypeClass;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectFile;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceType;
import org.mpxj.Task;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedWork;
import org.mpxj.WorkContour;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.DefaultTimephasedWorkContainer;
import org.mpxj.common.MicrosoftProjectConstants;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.SplitTaskFactory;
import org.mpxj.mpp.FieldMap;
import org.mpxj.mpp.FixedData;
import org.mpxj.mpp.FixedMeta;
import org.mpxj.mpp.HyperlinkReader;
import org.mpxj.mpp.MPPTimephasedBaselineCostNormaliser;
import org.mpxj.mpp.MPPTimephasedBaselineWorkNormaliser;
import org.mpxj.mpp.MPPTimephasedWorkNormaliser;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.MppBitFlag;
import org.mpxj.mpp.TimephasedDataFactory;
import org.mpxj.mpp.Var2Data;
import org.mpxj.mpp.VarMeta;
import org.mpxj.mpp.WorkContourHelper;

public class ResourceAssignmentFactory {
    private static final Integer MPP9_CREATION_DATA = 138;
    private static final MppBitFlag[] ASSIGNMENT_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(AssignmentField.FLAG1, 28, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG2, 28, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG3, 28, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG4, 28, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG5, 28, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG6, 28, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG7, 28, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG8, 28, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG9, 28, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG10, 28, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG11, 28, 65536, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG12, 28, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG13, 28, 262144, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG14, 28, 524288, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG15, 28, 0x100000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG16, 28, 0x200000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG17, 28, 0x400000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG18, 28, 0x800000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG19, 28, 0x1000000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG20, 28, 0x2000000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.LINKED_FIELDS, 8, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.WORK_CONTOUR, 8, 16, WorkContour.FLAT, WorkContour.CONTOURED), new MppBitFlag(AssignmentField.CONFIRMED, 8, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.TEAM_STATUS_PENDING, 8, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.RESPONSE_PENDING, 8, 256, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT_2010_ASSIGNMENT_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(AssignmentField.FLAG10, 28, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG1, 28, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG2, 28, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG3, 28, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG4, 28, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG5, 28, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG6, 28, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG7, 28, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG8, 28, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG9, 28, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG11, 28, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG12, 28, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG13, 28, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG14, 28, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG15, 28, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG16, 28, 65536, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG17, 28, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG18, 28, 262144, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG19, 28, 524288, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG20, 28, 0x100000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.LINKED_FIELDS, 8, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.WORK_CONTOUR, 8, 16, WorkContour.FLAT, WorkContour.CONTOURED), new MppBitFlag(AssignmentField.CONFIRMED, 8, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.TEAM_STATUS_PENDING, 8, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.RESPONSE_PENDING, 8, 256, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT_2013_ASSIGNMENT_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(AssignmentField.FLAG1, 20, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG2, 20, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG3, 20, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG4, 20, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG5, 20, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG6, 20, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG7, 20, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG8, 20, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG9, 20, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.LINKED_FIELDS, 20, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG10, 20, 1, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG11, 25, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG12, 25, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG13, 25, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG14, 25, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG15, 25, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG16, 25, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG17, 25, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG18, 25, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG19, 25, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.FLAG20, 25, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.WORK_CONTOUR, 8, 262144, WorkContour.FLAT, WorkContour.CONTOURED), new MppBitFlag(AssignmentField.CONFIRMED, 8, 0x800000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.TEAM_STATUS_PENDING, 8, 0x2000000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(AssignmentField.RESPONSE_PENDING, 8, 0x1000000, Boolean.FALSE, Boolean.TRUE)};
    private static final AssignmentField[] TIMEPHASED_BASELINE_WORK = new AssignmentField[]{AssignmentField.TIMEPHASED_BASELINE_WORK, AssignmentField.TIMEPHASED_BASELINE1_WORK, AssignmentField.TIMEPHASED_BASELINE2_WORK, AssignmentField.TIMEPHASED_BASELINE3_WORK, AssignmentField.TIMEPHASED_BASELINE4_WORK, AssignmentField.TIMEPHASED_BASELINE5_WORK, AssignmentField.TIMEPHASED_BASELINE6_WORK, AssignmentField.TIMEPHASED_BASELINE7_WORK, AssignmentField.TIMEPHASED_BASELINE8_WORK, AssignmentField.TIMEPHASED_BASELINE9_WORK, AssignmentField.TIMEPHASED_BASELINE10_WORK};
    private static final AssignmentField[] TIMEPHASED_BASELINE_COST = new AssignmentField[]{AssignmentField.TIMEPHASED_BASELINE_COST, AssignmentField.TIMEPHASED_BASELINE1_COST, AssignmentField.TIMEPHASED_BASELINE2_COST, AssignmentField.TIMEPHASED_BASELINE3_COST, AssignmentField.TIMEPHASED_BASELINE4_COST, AssignmentField.TIMEPHASED_BASELINE5_COST, AssignmentField.TIMEPHASED_BASELINE6_COST, AssignmentField.TIMEPHASED_BASELINE7_COST, AssignmentField.TIMEPHASED_BASELINE8_COST, AssignmentField.TIMEPHASED_BASELINE9_COST, AssignmentField.TIMEPHASED_BASELINE10_COST};
    private static final Duration DEFAULT_NORMALIZER_WORK_PER_DAY = Duration.getInstance(480, TimeUnit.MINUTES);

    public void process(ProjectFile file, FieldMap fieldMap, FieldMap enterpriseCustomFieldMap, boolean useRawTimephasedData, VarMeta assnVarMeta, Var2Data assnVarData, FixedMeta assnFixedMeta, FixedData assnFixedData, FixedData assnFixedData2, int count) {
        Set<Integer> set = assnVarMeta.getUniqueIdentifierSet();
        TimephasedDataFactory timephasedFactory = new TimephasedDataFactory();
        HyperlinkReader hyperlinkReader = new HyperlinkReader();
        MppBitFlag[] metaDataBitFlags = NumberHelper.getInt(file.getProjectProperties().getMppFileType()) == 14 ? (NumberHelper.getInt(file.getProjectProperties().getApplicationVersion()) > 14 ? PROJECT_2013_ASSIGNMENT_META_DATA_BIT_FLAGS : PROJECT_2010_ASSIGNMENT_META_DATA_BIT_FLAGS) : ASSIGNMENT_META_DATA_BIT_FLAGS;
        HashSet<Task> processedSplits = new HashSet<Task>();
        for (int loop = 0; loop < count; ++loop) {
            Task task;
            byte[] creationData;
            int id;
            Integer varDataId;
            int offset;
            byte[] data;
            byte[] meta = assnFixedMeta.getByteArrayValue(loop);
            if (meta == null || meta[0] != 0 || (data = assnFixedData.getByteArrayValue(assnFixedData.getIndexFromOffset(offset = ByteArrayHelper.getInt(meta, 4)))) == null) continue;
            if (data.length < fieldMap.getMaxFixedDataSize(0)) {
                byte[] newData = new byte[fieldMap.getMaxFixedDataSize(0)];
                System.arraycopy(data, 0, newData, 0, data.length);
                data = newData;
            }
            if (!set.contains(varDataId = Integer.valueOf(id = ByteArrayHelper.getInt(data, fieldMap.getFixedDataOffset(AssignmentField.UNIQUE_ID))))) continue;
            byte[] data2 = null;
            if (assnFixedData2 != null) {
                data2 = assnFixedData2.getByteArrayValue(assnFixedData.getIndexFromOffset(offset));
            }
            ResourceAssignment assignment = new ResourceAssignment(file, null);
            assignment.disableEvents();
            fieldMap.populateContainer(FieldTypeClass.ASSIGNMENT, assignment, varDataId, new byte[][]{data, data2}, assnVarData);
            if (enterpriseCustomFieldMap != null) {
                enterpriseCustomFieldMap.populateContainer(FieldTypeClass.ASSIGNMENT, assignment, varDataId, null, assnVarData);
            }
            assignment.enableEvents();
            Stream.of(metaDataBitFlags).forEach(f -> f.setValue(assignment, meta));
            if (NumberHelper.equals(assignment.getResourceUniqueID(), MicrosoftProjectConstants.ASSIGNMENT_NULL_RESOURCE_ID)) {
                assignment.setResourceUniqueID(null);
            }
            hyperlinkReader.read(assignment, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.HYPERLINK_DATA)));
            if (NumberHelper.getInt(file.getProjectProperties().getMppFileType()) == 9 && assignment.getCreateDate() == null && (creationData = assnVarData.getByteArray(varDataId, MPP9_CREATION_DATA)) != null && creationData.length >= 28) {
                assignment.setCreateDate(MPPUtility.getTimestamp(creationData, 24));
            }
            if ((task = file.getTaskByUniqueID(assignment.getTaskUniqueID())) == null || task.getExistingResourceAssignment(assignment.getResource()) != null) continue;
            task.addResourceAssignment(assignment);
            Resource resource = file.getResourceByUniqueID(assignment.getResourceUniqueID());
            ResourceType resourceType = resource == null ? ResourceType.WORK : resource.getType();
            ProjectCalendar calendar = assignment.getEffectiveCalendar();
            for (int index = 0; index < TIMEPHASED_BASELINE_WORK.length; ++index) {
                assignment.setTimephasedBaselineWork(index, timephasedFactory.getBaselineWork(calendar, assignment, MPPTimephasedBaselineWorkNormaliser.INSTANCE, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(TIMEPHASED_BASELINE_WORK[index])), !useRawTimephasedData));
                assignment.setTimephasedBaselineCost(index, timephasedFactory.getBaselineCost(assignment, MPPTimephasedBaselineCostNormaliser.INSTANCE, assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(TIMEPHASED_BASELINE_COST[index])), !useRawTimephasedData));
            }
            byte[] timephasedActualWorkData = assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_ACTUAL_WORK));
            byte[] timephasedWorkData = assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_WORK));
            byte[] timephasedActualOvertimeWorkData = assnVarData.getByteArray(varDataId, fieldMap.getVarDataKey(AssignmentField.TIMEPHASED_ACTUAL_OVERTIME_WORK));
            List<TimephasedWork> timephasedActualWork = timephasedFactory.getCompleteWork(calendar, assignment, timephasedActualWorkData);
            List<TimephasedWork> timephasedWork = timephasedFactory.getPlannedWork(calendar, assignment, timephasedWorkData, timephasedActualWork, resourceType);
            List<TimephasedWork> timephasedActualOvertimeWork = timephasedFactory.getCompleteWork(calendar, assignment, timephasedActualOvertimeWorkData);
            if (task.getDuration() == null || task.getDuration().getDuration() == 0.0) {
                assignment.setActualStart(task.getActualStart() != null ? assignment.getStart() : null);
                assignment.setActualFinish(task.getActualFinish() != null ? assignment.getFinish() : null);
            } else {
                assignment.setActualFinish(task.getActualStart() != null && assignment.getRemainingWork().getDuration() == 0.0 && resource != null ? assignment.getFinish() : null);
                assignment.setActualStart(assignment.getActualFinish() != null || !timephasedActualWork.isEmpty() ? assignment.getStart() : null);
            }
            if (!task.getMilestone() && !processedSplits.contains(task)) {
                processedSplits.add(task);
                SplitTaskFactory.processSplitData(assignment, timephasedActualWork, timephasedWork);
            }
            this.createTimephasedData(file, assignment, timephasedWork, timephasedActualWork);
            assignment.setTimephasedWork(new DefaultTimephasedWorkContainer(assignment, MPPTimephasedWorkNormaliser.INSTANCE, timephasedWork, !useRawTimephasedData));
            assignment.setTimephasedActualWork(new DefaultTimephasedWorkContainer(assignment, MPPTimephasedWorkNormaliser.INSTANCE, timephasedActualWork, !useRawTimephasedData));
            assignment.setTimephasedActualOvertimeWork(new DefaultTimephasedWorkContainer(assignment, MPPTimephasedWorkNormaliser.INSTANCE, timephasedActualOvertimeWork, !useRawTimephasedData));
            if (timephasedWorkData != null && assignment.getWorkContour() == WorkContour.FLAT && timephasedWorkData.length >= 30) {
                assignment.setWorkContour(WorkContourHelper.getInstance(file, ByteArrayHelper.getShort(timephasedWorkData, 28)));
            }
            file.getEventManager().fireAssignmentReadEvent(assignment);
        }
    }

    private void createTimephasedData(ProjectFile file, ResourceAssignment assignment, List<TimephasedWork> timephasedPlanned, List<TimephasedWork> timephasedComplete) {
        Duration workPerDay;
        if (!timephasedPlanned.isEmpty() || !timephasedComplete.isEmpty() || assignment.getTask().getDuration() == null || assignment.getTask().getDuration().getDuration() == 0.0) {
            return;
        }
        Duration totalMinutes = assignment.getWork().convertUnits(TimeUnit.MINUTES, file.getProjectProperties());
        if (assignment.getResource() == null || assignment.getResource().getType() == ResourceType.WORK) {
            workPerDay = totalMinutes.getDuration() == 0.0 ? totalMinutes : DEFAULT_NORMALIZER_WORK_PER_DAY;
            int units = NumberHelper.getInt(assignment.getUnits());
            if (units != 100) {
                workPerDay = Duration.getInstance(workPerDay.getDuration() * (double)units / 100.0, workPerDay.getUnits());
            }
        } else if (assignment.getVariableRateUnits() == null) {
            Duration workingDays = assignment.getEffectiveCalendar().getWork(assignment.getStart(), assignment.getFinish(), TimeUnit.DAYS);
            double units = NumberHelper.getDouble(assignment.getUnits());
            double unitsPerDayAsMinutes = units * 60.0 / (workingDays.getDuration() * 100.0);
            workPerDay = Duration.getInstance(unitsPerDayAsMinutes, TimeUnit.MINUTES);
        } else {
            double unitsPerHour = NumberHelper.getDouble(assignment.getUnits());
            workPerDay = DEFAULT_NORMALIZER_WORK_PER_DAY;
            Duration hoursPerDay = workPerDay.convertUnits(TimeUnit.HOURS, file.getProjectProperties());
            double unitsPerDayAsHours = unitsPerHour * hoursPerDay.getDuration() / 100.0;
            double unitsPerDayAsMinutes = unitsPerDayAsHours * 60.0;
            workPerDay = Duration.getInstance(unitsPerDayAsMinutes, TimeUnit.MINUTES);
        }
        Duration overtimeWork = assignment.getOvertimeWork();
        if (overtimeWork != null && overtimeWork.getDuration() != 0.0) {
            Duration totalOvertimeMinutes = overtimeWork.convertUnits(TimeUnit.MINUTES, file.getProjectProperties());
            totalMinutes = Duration.getInstance(totalMinutes.getDuration() - totalOvertimeMinutes.getDuration(), TimeUnit.MINUTES);
        }
        TimephasedWork tra = new TimephasedWork();
        tra.setStart(assignment.getStart());
        tra.setAmountPerDay(workPerDay);
        tra.setModified(false);
        tra.setFinish(assignment.getFinish());
        tra.setTotalAmount(totalMinutes);
        timephasedPlanned.add(tra);
    }
}

