/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import org.mpxj.Column;
import org.mpxj.ProjectFile;
import org.mpxj.Table;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.FieldTypeHelper;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.Var2Data;
import org.mpxj.mpp.VarMeta;

final class TableFactory14 {
    private final Integer m_tableColumnDataStandard;
    private final Integer m_tableColumnDataEnterprise;
    private final Integer m_tableColumnDataBaseline;

    public TableFactory14(Integer tableColumnDataStandard, Integer tableColumnDataEnterprise, Integer tableColumnDataBaseline) {
        this.m_tableColumnDataStandard = tableColumnDataStandard;
        this.m_tableColumnDataEnterprise = tableColumnDataEnterprise;
        this.m_tableColumnDataBaseline = tableColumnDataBaseline;
    }

    public Table createTable(ProjectFile file, byte[] data, VarMeta varMeta, Var2Data varData) {
        Table table = new Table();
        table.setID(ByteArrayHelper.getInt(data, 0));
        table.setResourceFlag(ByteArrayHelper.getShort(data, 108) == 1);
        table.setName(MPPUtility.removeAmpersands(MPPUtility.getUnicodeString(data, 4)));
        byte[] columnData = null;
        Integer tableID = table.getID();
        if (this.m_tableColumnDataBaseline != null) {
            columnData = varData.getByteArray(varMeta.getOffset(tableID, this.m_tableColumnDataBaseline));
        }
        if (columnData == null && (columnData = varData.getByteArray(varMeta.getOffset(tableID, this.m_tableColumnDataEnterprise))) == null) {
            columnData = varData.getByteArray(varMeta.getOffset(tableID, this.m_tableColumnDataStandard));
        }
        this.processColumnData(file, table, columnData);
        return table;
    }

    private void processColumnData(ProjectFile file, Table table, byte[] data) {
        if (data != null && data.length > 6) {
            int columnCount = ByteArrayHelper.getShort(data, 4) + 1;
            int index = 12;
            for (int loop = 0; loop < columnCount; ++loop) {
                int alignment;
                Column column = new Column(file);
                column.setFieldType(FieldTypeHelper.getInstance(file, ByteArrayHelper.getInt(data, index)));
                column.setWidth(MPPUtility.getByte(data, index + 4));
                String columnTitle = MPPUtility.getUnicodeString(data, index + 13);
                if (!columnTitle.isEmpty()) {
                    column.setTitle(columnTitle);
                }
                if (((alignment = MPPUtility.getByte(data, index + 5)) & 0xF) == 0) {
                    column.setAlignTitle(1);
                } else if ((alignment & 0xF) == 1) {
                    column.setAlignTitle(2);
                } else {
                    column.setAlignTitle(3);
                }
                alignment = MPPUtility.getByte(data, index + 7);
                if ((alignment & 0xF) == 0) {
                    column.setAlignData(1);
                } else if ((alignment & 0xF) == 1) {
                    column.setAlignData(2);
                } else {
                    column.setAlignData(3);
                }
                table.addColumn(column);
                index += 115;
            }
        }
    }
}

