/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.Duration;
import org.mpxj.ProjectCalendar;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceType;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedCost;
import org.mpxj.TimephasedCostContainer;
import org.mpxj.TimephasedItem;
import org.mpxj.TimephasedWork;
import org.mpxj.TimephasedWorkContainer;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.DefaultTimephasedCostContainer;
import org.mpxj.common.DefaultTimephasedWorkContainer;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.TimephasedNormaliser;
import org.mpxj.mpp.MPPUtility;

final class TimephasedDataFactory {
    TimephasedDataFactory() {
    }

    public List<TimephasedWork> getCompleteWork(ProjectCalendar calendar, ResourceAssignment resourceAssignment, byte[] data) {
        ArrayList<TimephasedWork> list = new ArrayList<TimephasedWork>();
        if (calendar == null || data == null || data.length <= 26 || ByteArrayHelper.getShort(data, 0) == 0 || resourceAssignment.getTask().getDuration() == null || resourceAssignment.getTask().getDuration().getDuration() == 0.0) {
            return list;
        }
        LocalDateTime startDate = resourceAssignment.getStart();
        double finishTime = ByteArrayHelper.getInt(data, 24);
        int blockCount = ByteArrayHelper.getShort(data, 0);
        double previousCumulativeWork = 0.0;
        TimephasedItem previousAssignment = null;
        int index = 32;
        for (int currentBlock = 0; currentBlock < blockCount && index + 20 <= data.length; ++currentBlock) {
            double time = ByteArrayHelper.getInt(data, index);
            time = time < 0.0 || time > finishTime ? 0.0 : (time /= 80.0);
            Duration startWork = Duration.getInstance(time, TimeUnit.MINUTES);
            double currentCumulativeWork = (long)MPPUtility.getDouble(data, index + 4);
            double assignmentDuration = currentCumulativeWork - previousCumulativeWork;
            previousCumulativeWork = currentCumulativeWork;
            Duration totalWork = Duration.getInstance(assignmentDuration /= 1000.0, TimeUnit.MINUTES);
            LocalDateTime start = startWork.getDuration() == 0.0 ? startDate : calendar.getNextWorkStart(calendar.getDate(startDate, startWork));
            TimephasedWork assignment = new TimephasedWork();
            assignment.setStart(start);
            assignment.setTotalAmount(totalWork);
            if (previousAssignment != null) {
                LocalDateTime finish = calendar.getDate(startDate, startWork);
                previousAssignment.setFinish(finish);
                if (previousAssignment.getStart().equals(previousAssignment.getFinish())) {
                    list.remove(list.size() - 1);
                }
            }
            list.add(assignment);
            previousAssignment = assignment;
            index += 20;
        }
        if (previousAssignment != null) {
            Duration finishWork = Duration.getInstance(finishTime / 80.0, TimeUnit.MINUTES);
            LocalDateTime finish = calendar.getDate(startDate, finishWork);
            previousAssignment.setFinish(finish);
            if (previousAssignment.getStart().equals(previousAssignment.getFinish())) {
                list.remove(list.size() - 1);
            }
        }
        this.calculateAmountPerDay(calendar, list);
        return list;
    }

    public List<TimephasedWork> getPlannedWork(ProjectCalendar calendar, ResourceAssignment assignment, byte[] data, List<TimephasedWork> timephasedComplete, ResourceType resourceType) {
        ArrayList<TimephasedWork> list = new ArrayList<TimephasedWork>();
        if (data == null || data.length == 0 || assignment.getTask().getDuration() == null || assignment.getTask().getDuration().getDuration() == 0.0) {
            return list;
        }
        int blockCount = ByteArrayHelper.getShort(data, 0);
        if (blockCount == 0) {
            double time;
            if (data.length >= 24 && (time = MPPUtility.getDouble(data, 16)) != 0.0) {
                Duration totalWork = Duration.getInstance(time /= 1000.0, TimeUnit.MINUTES);
                TimephasedWork work = new TimephasedWork();
                work.setStart(timephasedComplete.isEmpty() ? assignment.getStart() : assignment.getResume());
                work.setFinish(assignment.getFinish());
                work.setTotalAmount(totalWork);
                list.add(work);
            }
        } else {
            Duration blockDuration;
            double time;
            LocalDateTime offset = timephasedComplete.isEmpty() ? assignment.getStart() : assignment.getResume();
            int index = 40;
            double previousCumulativeWork = 0.0;
            TimephasedItem previousAssignment = null;
            int previousModifiedFlag = 0;
            for (int currentBlock = 0; currentBlock < blockCount && index + 28 <= data.length; ++currentBlock) {
                time = ByteArrayHelper.getInt(data, index);
                blockDuration = Duration.getInstance(time /= 80.0, TimeUnit.MINUTES);
                LocalDateTime start = blockDuration.getDuration() == 0.0 ? offset : calendar.getNextWorkStart(calendar.getDate(offset, blockDuration));
                double currentCumulativeWork = MPPUtility.getDouble(data, index + 4);
                double assignmentDuration = currentCumulativeWork - previousCumulativeWork;
                Duration totalWork = Duration.getInstance(assignmentDuration /= 1000.0, TimeUnit.MINUTES);
                previousCumulativeWork = currentCumulativeWork;
                int currentModifiedFlag = ByteArrayHelper.getShort(data, index + 22);
                boolean modified = currentBlock > 0 && previousModifiedFlag != 0 && currentModifiedFlag == 0 || (currentModifiedFlag & 0x3000) != 0;
                previousModifiedFlag = currentModifiedFlag;
                TimephasedWork work = new TimephasedWork();
                work.setStart(start);
                work.setModified(modified);
                work.setTotalAmount(totalWork);
                if (previousAssignment != null) {
                    LocalDateTime finish = calendar.getDate(offset, blockDuration);
                    previousAssignment.setFinish(finish);
                    if (previousAssignment.getStart().equals(previousAssignment.getFinish())) {
                        list.remove(list.size() - 1);
                    }
                }
                list.add(work);
                previousAssignment = work;
                index += 28;
            }
            if (previousAssignment != null) {
                time = ByteArrayHelper.getInt(data, 24);
                blockDuration = Duration.getInstance(time /= 80.0, TimeUnit.MINUTES);
                LocalDateTime finish = calendar.getDate(offset, blockDuration);
                previousAssignment.setFinish(finish);
                if (previousAssignment.getStart().equals(previousAssignment.getFinish())) {
                    list.remove(list.size() - 1);
                }
            }
        }
        this.calculateAmountPerDay(calendar, list);
        return list;
    }

    public TimephasedWorkContainer getBaselineWork(ProjectCalendar calendar, ResourceAssignment assignment, TimephasedNormaliser<TimephasedWork> normaliser, byte[] data, boolean raw) {
        if (data == null || data.length == 0) {
            return null;
        }
        int blockCount = ByteArrayHelper.getShort(data, 0);
        int offset = ByteArrayHelper.getShort(data, 4);
        if (blockCount < 3) {
            return null;
        }
        LocalDateTime blockEndDate = null;
        long previousTotalWorkInMinutes = 0L;
        ArrayList<TimephasedWork> list = new ArrayList<TimephasedWork>();
        long totalWork = 0L;
        for (int blockIndex = 0; blockIndex < blockCount - 1 && offset + 20 <= data.length; ++blockIndex) {
            if (blockIndex == 0) {
                blockEndDate = MPPUtility.getTimestampFromTenths(data, offset + 16);
            } else {
                LocalDateTime blockStartDate = blockEndDate;
                long currentCumulativeWorkInMinutes = (long)(MPPUtility.getDouble(data, offset) / 1000.0);
                int expectedWorkThisPeriodInMinutes = ByteArrayHelper.getInt(data, offset + 8) / 10;
                blockEndDate = MPPUtility.getTimestampFromTenths(data, offset + 16);
                long workThisPeriodInMinutes = currentCumulativeWorkInMinutes - previousTotalWorkInMinutes;
                totalWork += workThisPeriodInMinutes;
                TimephasedWork work = new TimephasedWork();
                work.setStart(blockStartDate);
                work.setFinish(blockEndDate);
                work.setTotalAmount(Duration.getInstance(workThisPeriodInMinutes, TimeUnit.MINUTES));
                work.setModified(workThisPeriodInMinutes != (long)expectedWorkThisPeriodInMinutes);
                list.add(work);
                previousTotalWorkInMinutes = currentCumulativeWorkInMinutes;
            }
            offset += 20;
        }
        if (totalWork == 0L) {
            return null;
        }
        this.calculateAmountPerDay(calendar, list);
        return new DefaultTimephasedWorkContainer(assignment, normaliser, list, true);
    }

    public TimephasedCostContainer getBaselineCost(ResourceAssignment assignment, TimephasedNormaliser<TimephasedCost> normaliser, byte[] data, boolean raw) {
        DefaultTimephasedCostContainer result = null;
        if (data == null || data.length == 0) {
            return result;
        }
        ArrayList<TimephasedCost> list = null;
        int index = 16;
        int blockSize = 20;
        double previousTotalCost = 0.0;
        LocalDateTime blockStartDate = MPPUtility.getTimestampFromTenths(data, index + 16);
        index += blockSize;
        while (index + blockSize <= data.length) {
            LocalDateTime blockEndDate = MPPUtility.getTimestampFromTenths(data, index + 16);
            double currentTotalCost = (double)((long)MPPUtility.getDouble(data, index + 8)) / 100.0;
            if (!this.costEquals(previousTotalCost, currentTotalCost)) {
                TimephasedCost cost = new TimephasedCost();
                cost.setStart(blockStartDate);
                cost.setFinish(blockEndDate);
                cost.setTotalAmount(currentTotalCost - previousTotalCost);
                if (list == null) {
                    list = new ArrayList<TimephasedCost>();
                }
                list.add(cost);
                previousTotalCost = currentTotalCost;
            }
            blockStartDate = blockEndDate;
            index += blockSize;
        }
        if (list != null) {
            result = new DefaultTimephasedCostContainer(assignment, normaliser, list, raw);
        }
        return result;
    }

    private boolean costEquals(double lhs, double rhs) {
        return NumberHelper.equals(lhs, rhs, 1.0E-5);
    }

    private void calculateAmountPerDay(ProjectCalendar calendar, List<TimephasedWork> list) {
        for (TimephasedWork work : list) {
            Duration amountPerDay;
            if (((Duration)work.getTotalAmount()).getDuration() == 0.0) {
                amountPerDay = Duration.getInstance(0, TimeUnit.MINUTES);
            } else {
                Duration totalWorkInMinutes = (Duration)work.getTotalAmount();
                Duration calculatedTotalWorkInMinutes = calendar.getWork(work.getStart(), work.getFinish(), TimeUnit.MINUTES);
                double minutesPerDay = 480.0;
                double calculatedAmountPerDay = minutesPerDay * totalWorkInMinutes.getDuration() / calculatedTotalWorkInMinutes.getDuration();
                amountPerDay = Duration.getInstance(calculatedAmountPerDay, TimeUnit.MINUTES);
            }
            work.setAmountPerDay(amountPerDay);
        }
    }
}

