/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import org.mpxj.MpxjEnum;
import org.mpxj.common.EnumHelper;
import org.mpxj.common.NumberHelper;

public enum TimescaleUnits implements MpxjEnum
{
    NONE(-1, "None"),
    MINUTES(0, "Minutes"),
    HOURS(1, "Hours"),
    DAYS(2, "Days"),
    WEEKS(3, "Weeks"),
    THIRDS_OF_MONTHS(4, "Thirds of Months"),
    MONTHS(5, "Months"),
    QUARTERS(6, "Quarters"),
    HALF_YEARS(7, "Half Years"),
    YEARS(8, "Years");

    private static final TimescaleUnits[] TYPE_VALUES;
    private final int m_value;
    private final String m_name;

    private TimescaleUnits(int type, String name) {
        this.m_value = type;
        this.m_name = name;
    }

    public static TimescaleUnits getInstance(int type) {
        TimescaleUnits result = type < 0 || type >= TYPE_VALUES.length ? NONE : TYPE_VALUES[type];
        return result;
    }

    public static TimescaleUnits getInstance(Number type) {
        int value = type == null ? -1 : NumberHelper.getInt(type);
        return TimescaleUnits.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = (TimescaleUnits[])EnumHelper.createTypeArray(TimescaleUnits.class, (int)-1);
    }
}

