/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mpxj.DataType;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.ProjectFile;

public class UserDefinedFieldMap {
    private final Map<FieldType, FieldType> m_targetMap = new HashMap<FieldType, FieldType>();
    private final Map<FieldType, FieldType> m_sourceMap = new HashMap<FieldType, FieldType>();
    private final Map<FieldTypeClass, Map<DataType, List<FieldType>>> m_fields = new HashMap<FieldTypeClass, Map<DataType, List<FieldType>>>();

    public UserDefinedFieldMap(ProjectFile file, List<FieldType> targetFieldList) {
        if (file == null || file.getUserDefinedFields().isEmpty()) {
            return;
        }
        HashSet<FieldType> populated = new HashSet<FieldType>();
        populated.addAll(file.getTasks().getPopulatedFields());
        populated.addAll(file.getResources().getPopulatedFields());
        populated.addAll(file.getResourceAssignments().getPopulatedFields());
        targetFieldList.stream().filter(f -> !populated.contains(f)).forEach(f -> this.getFieldList((FieldType)f).add((FieldType)f));
    }

    public FieldType getTarget(FieldType source) {
        FieldType target = this.m_targetMap.get(source);
        return target == null ? source : target;
    }

    public FieldType getSource(FieldType target) {
        FieldType source = this.m_sourceMap.get(target);
        return source == null ? target : source;
    }

    public FieldType generateMapping(FieldType source) {
        FieldType target;
        List<FieldType> fieldList = this.getFieldList(source);
        if (fieldList.isEmpty()) {
            fieldList = this.getFieldList(source.getFieldTypeClass(), DataType.STRING);
        }
        FieldType fieldType = target = fieldList.isEmpty() ? null : fieldList.remove(0);
        if (target != null) {
            this.m_targetMap.put(source, target);
            this.m_sourceMap.put(target, source);
        }
        return target;
    }

    private List<FieldType> getFieldList(FieldType field) {
        return this.getFieldList(field.getFieldTypeClass(), this.normaliseDataType(field.getDataType()));
    }

    private List<FieldType> getFieldList(FieldTypeClass fieldTypeClass, DataType dataType) {
        Map typeMap = this.m_fields.computeIfAbsent(fieldTypeClass, c -> new HashMap());
        return typeMap.computeIfAbsent(dataType, f -> new ArrayList());
    }

    private DataType normaliseDataType(DataType type) {
        switch (type) {
            case STRING: 
            case DATE: 
            case CURRENCY: 
            case BOOLEAN: 
            case NUMERIC: 
            case DURATION: {
                break;
            }
            case PERCENTAGE: 
            case INTEGER: 
            case SHORT: {
                type = DataType.NUMERIC;
                break;
            }
            case WORK: {
                type = DataType.DURATION;
                break;
            }
            case DELAY: {
                type = DataType.DURATION;
                break;
            }
            default: {
                type = DataType.STRING;
            }
        }
        return type;
    }
}

