/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.util.UUID;
import org.mpxj.CustomFieldContainer;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.mpp.CustomFieldValueItem;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.Var2Data;

abstract class VarDataFieldReader {
    private final CustomFieldContainer m_customFields;
    private static final int VALUE_LIST_WITH_ID_MASK = 1793;
    private static final int VALUE_LIST_WITHOUT_ID_MASK = 1025;

    public VarDataFieldReader(CustomFieldContainer customFields) {
        this.m_customFields = customFields;
    }

    public Object getValue(Var2Data varData, Integer id, Integer type) {
        byte[] data;
        int flag = varData.getShort(id, type);
        Object result = flag == 1793 || flag == 1025 ? ((data = varData.getByteArray(id, type)).length == 4 ? MPPUtility.getDate(data, 2) : this.getValueByID(data)) : this.readValue(varData, id, type);
        return result;
    }

    private Object getValueByID(byte[] data) {
        CustomFieldValueItem item;
        int uniqueId = ByteArrayHelper.getInt(data, 2);
        UUID guid = MPPUtility.getGUID(data, 6);
        if (uniqueId == -1) {
            item = this.m_customFields.getCustomFieldValueItemByGuid(guid);
        } else {
            item = this.m_customFields.getCustomFieldValueItemByUniqueID(uniqueId);
            if (item == null) {
                item = this.m_customFields.getCustomFieldValueItemByGuid(guid);
            }
        }
        return item == null ? guid : this.coerceValue(item.getValue());
    }

    protected abstract Object readValue(Var2Data var1, Integer var2, Integer var3);

    protected abstract Object coerceValue(Object var1);
}

