/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpx;

import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.HashMap;
import java.util.Locale;
import org.mpxj.DateOrder;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.ProjectTimeFormat;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.mpx.MPXJNumberFormat;

public final class MPXJFormats {
    private final Locale m_locale;
    private final String m_nullText;
    private final ProjectFile m_projectFile;
    private final MPXJNumberFormat m_unitsDecimalFormat = new MPXJNumberFormat();
    private final MPXJNumberFormat m_decimalFormat = new MPXJNumberFormat();
    private final MPXJNumberFormat m_currencyFormat = new MPXJNumberFormat();
    private final MPXJNumberFormat m_durationDecimalFormat = new MPXJNumberFormat();
    private final MPXJNumberFormat m_percentageDecimalFormat = new MPXJNumberFormat();
    private boolean m_parseDateTimeSkipDayName;
    private DateTimeFormatter m_parseDateTimeFormat;
    private DateTimeFormatter m_printDateTimeFormat;
    private DateTimeFormatter m_parseDateFormat;
    private DateTimeFormatter m_printDateFormat;
    private DateTimeFormatter m_parseTimeFormat;
    private DateTimeFormatter m_printTimeFormat;

    public MPXJFormats(Locale locale, String nullText, ProjectFile file) {
        this.m_locale = locale;
        this.m_nullText = nullText;
        this.m_projectFile = file;
        this.update();
    }

    public void update() {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        char decimalSeparator = properties.getDecimalSeparator();
        char thousandsSeparator = properties.getThousandsSeparator();
        this.updateNumericFormats(decimalSeparator, thousandsSeparator);
        this.updateCurrencyFormats(properties, decimalSeparator, thousandsSeparator);
        this.updateDateTimeFormats(properties);
    }

    private void updateNumericFormats(char decimalSeparator, char thousandsSeparator) {
        this.m_unitsDecimalFormat.applyPattern("#.##", null, decimalSeparator, thousandsSeparator);
        this.m_decimalFormat.applyPattern("0.00#", null, decimalSeparator, thousandsSeparator);
        this.m_durationDecimalFormat.applyPattern("#.##", null, decimalSeparator, thousandsSeparator);
        this.m_percentageDecimalFormat.applyPattern("##0.##", null, decimalSeparator, thousandsSeparator);
    }

    private void updateCurrencyFormats(ProjectProperties properties, char decimalSeparator, char thousandsSeparator) {
        String noSymbolSecondaryPattern;
        String noSymbolPrimaryPattern;
        String secondaryPattern;
        String prefix = "";
        String suffix = "";
        String currencySymbol = this.quoteFormatCharacters(properties.getCurrencySymbol());
        switch (properties.getSymbolPosition()) {
            case AFTER: {
                suffix = currencySymbol;
                break;
            }
            case BEFORE: {
                prefix = currencySymbol;
                break;
            }
            case AFTER_WITH_SPACE: {
                suffix = " " + currencySymbol;
                break;
            }
            case BEFORE_WITH_SPACE: {
                prefix = currencySymbol + " ";
            }
        }
        StringBuilder pattern = new StringBuilder(prefix);
        pattern.append("#0");
        int digits = properties.getCurrencyDigits();
        if (digits > 0) {
            pattern.append('.');
            for (int i = 0; i < digits; ++i) {
                pattern.append("0");
            }
        }
        pattern.append(suffix);
        String primaryPattern = pattern.toString();
        String[] alternativePatterns = new String[7];
        alternativePatterns[0] = primaryPattern + ";(" + primaryPattern + ")";
        pattern.insert(prefix.length(), "#,#");
        alternativePatterns[1] = secondaryPattern = pattern.toString();
        alternativePatterns[2] = secondaryPattern + ";(" + secondaryPattern + ")";
        pattern.setLength(0);
        pattern.append("#0");
        if (digits > 0) {
            pattern.append('.');
            for (int i = 0; i < digits; ++i) {
                pattern.append("0");
            }
        }
        alternativePatterns[3] = noSymbolPrimaryPattern = pattern.toString();
        alternativePatterns[4] = noSymbolPrimaryPattern + ";(" + noSymbolPrimaryPattern + ")";
        pattern.insert(0, "#,#");
        alternativePatterns[5] = noSymbolSecondaryPattern = pattern.toString();
        alternativePatterns[6] = noSymbolSecondaryPattern + ";(" + noSymbolSecondaryPattern + ")";
        this.m_currencyFormat.applyPattern(primaryPattern, alternativePatterns, decimalSeparator, thousandsSeparator);
    }

    private String quoteFormatCharacters(String literal) {
        StringBuilder sb = new StringBuilder();
        int length = literal.length();
        block3: for (int loop = 0; loop < length; ++loop) {
            char c = literal.charAt(loop);
            switch (c) {
                case '#': 
                case '%': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case ';': 
                case 'E': {
                    sb.append("'");
                    sb.append(c);
                    sb.append("'");
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private void updateDateTimeFormats(ProjectProperties properties) {
        this.populateTimePatterns(properties);
        this.populateDatePatterns(properties);
        this.populateDateTimePatterns(properties);
    }

    private DateTimeFormatterBuilder getPrintDateBuilder(ProjectProperties properties) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.parseCaseInsensitive();
        char datesep = properties.getDateSeparator();
        DateOrder dateOrder = properties.getDateOrder();
        switch (dateOrder) {
            case DMY: {
                builder.appendPattern("dd" + datesep + "MM" + datesep + "yy");
                break;
            }
            case MDY: {
                builder.appendPattern("MM" + datesep + "dd" + datesep + "yy");
                break;
            }
            case YMD: {
                builder.appendPattern("yy" + datesep + "MM" + datesep + "dd");
            }
        }
        return builder;
    }

    private DateTimeFormatterBuilder getParseDateBuilder(ProjectProperties properties) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.parseCaseInsensitive();
        char datesep = properties.getDateSeparator();
        DateOrder dateOrder = properties.getDateOrder();
        switch (dateOrder) {
            case DMY: {
                builder.appendPattern("[dd][d]" + datesep + "[MM][M]" + datesep + "[yyyy]");
                builder.optionalStart();
                builder.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDateHelper.TWO_DIGIT_YEAR_BASE_DATE);
                builder.optionalEnd();
                break;
            }
            case MDY: {
                builder.appendPattern("[MM][M]" + datesep + "[dd][d]" + datesep + "[yyyy]");
                builder.optionalStart();
                builder.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDateHelper.TWO_DIGIT_YEAR_BASE_DATE);
                builder.optionalEnd();
                break;
            }
            case YMD: {
                builder.appendPattern("[yyyy]");
                builder.optionalStart();
                builder.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDateHelper.TWO_DIGIT_YEAR_BASE_DATE);
                builder.optionalEnd();
                builder.appendPattern(datesep + "[MM][M]" + datesep + "[dd][d]");
            }
        }
        return builder;
    }

    private void populateDateTimePatterns(ProjectProperties properties) {
        char datesep = properties.getDateSeparator();
        DateOrder dateOrder = properties.getDateOrder();
        block0 : switch (properties.getDateFormat()) {
            case DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "dd" + datesep + "MM" + datesep, "yy");
                        this.m_printDateTimeFormat = this.createPrintFormatterWithTime(properties, "dd" + datesep + "MM" + datesep + "yy");
                        break;
                    }
                    case MDY: {
                        this.createParseFormatterWithTime(properties, "MM" + datesep + "dd" + datesep, "yy");
                        this.m_printDateTimeFormat = this.createPrintFormatterWithTime(properties, "MM" + datesep + "dd" + datesep + "yy");
                        break;
                    }
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "yy", datesep + "MM" + datesep + "dd");
                        this.m_printDateTimeFormat = this.createPrintFormatterWithTime(properties, "yy" + datesep + "MM" + datesep + "dd");
                    }
                }
                break;
            }
            case DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "dd" + datesep + "MM" + datesep, "yy");
                        this.createPrintFormatter("dd" + datesep + "MM" + datesep + "yy");
                        break;
                    }
                    case MDY: {
                        this.createParseFormatterWithTime(properties, "MM" + datesep + "dd" + datesep, "yy");
                        this.createPrintFormatter("MM" + datesep + "dd" + datesep + "yy");
                        break;
                    }
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "yy", datesep + "MM" + datesep + "dd");
                        this.createPrintFormatter("yy" + datesep + "MM" + datesep + "dd");
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "dd MMMM yyyy");
                        this.m_printDateTimeFormat = this.createPrintFormatterWithTime(properties, "dd MMMM yyyy");
                        break;
                    }
                    case MDY: {
                        this.createParseFormatterWithTime(properties, "MMMM dd yyyy");
                        this.m_printDateTimeFormat = this.createPrintFormatterWithTime(properties, "MMMM dd yyyy");
                        break;
                    }
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "yyyy MMMM dd");
                        this.m_printDateTimeFormat = this.createPrintFormatterWithTime(properties, "yyyy MMMM dd");
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "dd MMMM yyyy");
                        this.createPrintFormatter("dd MMMM yyyy");
                        break;
                    }
                    case MDY: {
                        this.createParseFormatterWithTime(properties, "MMMM dd yyyy");
                        this.createPrintFormatter("MMMM dd yyyy");
                        break;
                    }
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "yyyy MMMM dd");
                        this.createPrintFormatter("yyyy MMMM dd");
                    }
                }
                break;
            }
            case DD_MMM_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "dd MMM");
                        this.createPrintFormatterWithTime(properties, "dd MMM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "MMM dd");
                        this.createPrintFormatterWithTime(properties, "MMM dd");
                    }
                }
                break;
            }
            case DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "dd MMM ''", "yy");
                        this.createPrintFormatter("dd MMM ''yy");
                        break;
                    }
                    case MDY: {
                        this.createParseFormatterWithTime(properties, "MMM dd ''", "yy");
                        this.createPrintFormatter("MMM dd ''yy");
                        break;
                    }
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "''", "yy", " MMM dd");
                        this.createPrintFormatter("''yy MMM dd");
                    }
                }
                break;
            }
            case DD_MMMMM: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "dd MMMM");
                        this.createPrintFormatter("dd MMMM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "MMMM dd");
                        this.createPrintFormatter("MMMM dd");
                    }
                }
                break;
            }
            case DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "dd MMM");
                        this.createPrintFormatter("dd MMM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "MMM dd");
                        this.createPrintFormatter("MMM dd");
                    }
                }
                break;
            }
            case EEE_DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "[EEE ]dd" + datesep + "MM" + datesep, "yy");
                        this.createPrintFormatterWithTime(properties, "EEE dd" + datesep + "MM" + datesep + "yy");
                        break;
                    }
                    case MDY: {
                        this.createParseFormatterWithTime(properties, "[EEE ]MM" + datesep + "dd" + datesep, "yy");
                        this.createPrintFormatterWithTime(properties, "EEE MM" + datesep + "dd" + datesep + "yy");
                        break;
                    }
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "[EEE ]", "yy", datesep + "MM" + datesep + "dd");
                        this.createPrintFormatterWithTime(properties, "EEE yy" + datesep + "MM" + datesep + "dd");
                    }
                }
                break;
            }
            case EEE_DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "[EEE ]dd" + datesep + "MM" + datesep, "yy");
                        this.createPrintFormatter("EEE dd" + datesep + "MM" + datesep + "yy");
                        break;
                    }
                    case MDY: {
                        this.createParseFormatterWithTime(properties, "[EEE ]MM" + datesep + "dd" + datesep, "yy");
                        this.createPrintFormatter("EEE MM" + datesep + "dd" + datesep + "yy");
                        break;
                    }
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "[EEE ]", "yy", datesep + "MM" + datesep + "dd");
                        this.createPrintFormatter("EEE yy" + datesep + "MM" + datesep + "dd");
                    }
                }
                break;
            }
            case EEE_DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "[EEE ]dd MMM ''", "yy");
                        this.createPrintFormatter("EEE dd MMM ''yy");
                        break;
                    }
                    case MDY: {
                        this.createParseFormatterWithTime(properties, "[EEE ]MMM dd ''", "yy");
                        this.createPrintFormatter("EEE MMM dd ''yy");
                        break;
                    }
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "[EEE ]''", "yy", " MMM dd");
                        this.createPrintFormatter("EEE ''yy MMM dd");
                    }
                }
                break;
            }
            case EEE_HH_MM: {
                this.createParseFormatterWithTime(properties, "[EEE ]");
                this.m_printDateTimeFormat = this.createPrintFormatterWithTime(properties, "EEE ");
                break;
            }
            case DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "dd" + datesep + "MM");
                        this.createPrintFormatter("dd" + datesep + "MM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "MM" + datesep + "dd");
                        this.createPrintFormatter("MM" + datesep + "dd");
                    }
                }
                break;
            }
            case DD: {
                this.createParseFormatterWithTime(properties, "dd");
                this.createPrintFormatter("dd");
                break;
            }
            case HH_MM: {
                DateTimeFormatterBuilder parseBuilder = new DateTimeFormatterBuilder();
                parseBuilder.parseCaseInsensitive();
                this.applyTimeParsePattern(properties, parseBuilder);
                this.m_parseDateTimeFormat = parseBuilder.toFormatter().withLocale(this.m_locale);
                parseBuilder = new DateTimeFormatterBuilder();
                parseBuilder.parseCaseInsensitive();
                this.applyTimePrintPattern(properties, parseBuilder);
                this.m_printDateTimeFormat = parseBuilder.toFormatter().withLocale(this.m_locale);
                break;
            }
            case EEE_DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "[EEE ]dd MMM");
                        this.createPrintFormatter("EEE dd MMM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "[EEE ]MMM dd");
                        this.createPrintFormatter("EEE MMM dd");
                    }
                }
                break;
            }
            case EEE_DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "[EEE ]dd" + datesep + "MM");
                        this.createPrintFormatter("EEE dd" + datesep + "MM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "[EEE ]MM" + datesep + "dd");
                        this.createPrintFormatter("EEE MM" + datesep + "dd");
                    }
                }
                break;
            }
            case EEE_DD: {
                this.createParseFormatterWithTime(properties, "[EEE ]dd");
                this.createPrintFormatter("EEE dd");
                break;
            }
            case DD_WWW: {
                this.createParseFormatterWithTime(properties, "F" + datesep + "'W'ww");
                this.createPrintFormatter("F" + datesep + "'W'ww");
                break;
            }
            case DD_WWW_YY_HH_MM: {
                this.createParseFormatterWithTime(properties, "F" + datesep + "'W'ww" + datesep, "yy");
                this.m_printDateTimeFormat = this.createPrintFormatterWithTime(properties, "F" + datesep + "'W'ww" + datesep + "yy");
                break;
            }
            case DD_MM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        this.createParseFormatterWithTime(properties, "dd" + datesep + "MM" + datesep + "yyyy");
                        this.createPrintFormatter("dd" + datesep + "MM" + datesep + "yyyy");
                        break block0;
                    }
                    case MDY: {
                        this.createParseFormatterWithTime(properties, "MM" + datesep + "dd" + datesep + "yyyy");
                        this.createPrintFormatter("MM" + datesep + "dd" + datesep + "yyyy");
                        break block0;
                    }
                    case YMD: {
                        this.createParseFormatterWithTime(properties, "yyyy" + datesep + "MM" + datesep + "dd");
                        this.createPrintFormatter("yyyy" + datesep + "MM" + datesep + "dd");
                    }
                }
            }
        }
    }

    private void createParseFormatterWithTime(ProjectProperties properties, String ... patterns) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.parseCaseInsensitive();
        builder.parseLenient();
        for (String pattern : patterns) {
            if (pattern.equals("yy")) {
                builder.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDateHelper.TWO_DIGIT_YEAR_BASE_DATE);
                continue;
            }
            builder.appendPattern(pattern);
        }
        builder.optionalStart();
        builder.appendPattern(" ");
        this.applyTimeParsePattern(properties, builder);
        builder.optionalEnd();
        this.m_parseDateTimeFormat = builder.toFormatter().withLocale(this.m_locale);
        if (patterns[0].startsWith("[EEE ]")) {
            this.m_parseDateTimeSkipDayName = true;
        }
    }

    private DateTimeFormatter createPrintFormatterWithTime(ProjectProperties properties, String pattern) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.appendPattern(pattern);
        builder.appendPattern(" ");
        this.applyTimePrintPattern(properties, builder);
        return builder.toFormatter().withLocale(this.m_locale);
    }

    private void createPrintFormatter(String pattern) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.appendPattern(pattern);
        this.m_printDateTimeFormat = builder.toFormatter().withLocale(this.m_locale);
    }

    private void populateTimePatterns(ProjectProperties properties) {
        DateTimeFormatterBuilder parseBuilder = new DateTimeFormatterBuilder();
        parseBuilder.parseCaseInsensitive();
        this.applyTimeParsePattern(properties, parseBuilder);
        this.m_parseTimeFormat = parseBuilder.toFormatter();
        DateTimeFormatterBuilder printBuilder = new DateTimeFormatterBuilder();
        this.applyTimePrintPattern(properties, printBuilder);
        this.m_printTimeFormat = printBuilder.toFormatter();
    }

    private void applyTimeParsePattern(ProjectProperties properties, DateTimeFormatterBuilder builder) {
        char timesep = properties.getTimeSeparator();
        ProjectTimeFormat format = properties.getTimeFormat();
        if (format == null || format == ProjectTimeFormat.TWELVE_HOUR) {
            HashMap<Long, String> ampmMap = new HashMap<Long, String>();
            ampmMap.put(0L, properties.getAMText());
            ampmMap.put(1L, properties.getPMText());
            builder.optionalStart();
            builder.appendPattern("[hh][h]" + timesep + "mm[ ]");
            builder.appendText((TemporalField)ChronoField.AMPM_OF_DAY, ampmMap);
            builder.optionalEnd();
            builder.appendPattern("[[HH][H]" + timesep + "mm]");
        } else {
            builder.appendPattern("[HH][H][" + timesep + "mm]");
        }
    }

    private void applyTimePrintPattern(ProjectProperties properties, DateTimeFormatterBuilder printBuilder) {
        char timesep = properties.getTimeSeparator();
        ProjectTimeFormat format = properties.getTimeFormat();
        if (format == null || format == ProjectTimeFormat.TWELVE_HOUR) {
            HashMap<Long, String> ampmMap = new HashMap<Long, String>();
            ampmMap.put(0L, properties.getAMText());
            ampmMap.put(1L, properties.getPMText());
            printBuilder.appendPattern("hh" + timesep + "mm ");
            printBuilder.appendText((TemporalField)ChronoField.AMPM_OF_DAY, ampmMap);
        } else {
            printBuilder.appendPattern("HH" + timesep + "mm");
        }
    }

    private void populateDatePatterns(ProjectProperties properties) {
        this.m_parseDateFormat = this.getParseDateBuilder(properties).toFormatter();
        this.m_printDateFormat = this.getPrintDateBuilder(properties).toFormatter();
    }

    public NumberFormat getUnitsDecimalFormat() {
        return this.m_unitsDecimalFormat;
    }

    public NumberFormat getDecimalFormat() {
        return this.m_decimalFormat;
    }

    public NumberFormat getCurrencyFormat() {
        return this.m_currencyFormat;
    }

    public NumberFormat getDurationDecimalFormat() {
        return this.m_durationDecimalFormat;
    }

    public NumberFormat getPercentageDecimalFormat() {
        return this.m_percentageDecimalFormat;
    }

    public LocalTime parseTime(String value) {
        return LocalTime.parse(value, this.m_parseTimeFormat);
    }

    public String printTime(LocalTime value) {
        return value == null ? null : this.m_printTimeFormat.format(value);
    }

    public LocalDateTime parseDate(String value) {
        if (this.m_nullText.equals(value)) {
            return null;
        }
        return LocalDate.parse(value, this.m_parseDateFormat).atStartOfDay();
    }

    public String printDate(LocalDate value) {
        return value == null ? null : this.m_printDateFormat.format(value);
    }

    public LocalDateTime parseDateTime(String value) {
        if (this.m_nullText.equals(value)) {
            return null;
        }
        if (this.m_parseDateTimeSkipDayName) {
            value = value.substring(value.indexOf(32) + 1);
        }
        return LocalDateTimeHelper.parseBest(this.m_parseDateTimeFormat, value);
    }

    public String printDateTime(TemporalAccessor value) {
        if (value == null) {
            return null;
        }
        return this.m_printDateTimeFormat.format(value);
    }

    public String getNullText() {
        return this.m_nullText;
    }
}

