/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpx;

import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.mpxj.AccrueType;
import org.mpxj.CodePage;
import org.mpxj.CurrencySymbolPosition;
import org.mpxj.DateOrder;
import org.mpxj.DayType;
import org.mpxj.Duration;
import org.mpxj.MPXJException;
import org.mpxj.ProjectDateFormat;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectTimeFormat;
import org.mpxj.Rate;
import org.mpxj.ScheduleFrom;
import org.mpxj.TimeUnit;
import org.mpxj.common.Tokenizer;
import org.mpxj.mpx.AccrueTypeUtility;
import org.mpxj.mpx.DurationUtility;
import org.mpxj.mpx.MPXJFormats;
import org.mpxj.mpx.TimeUnitUtility;

final class Record {
    private final Locale m_locale;
    private Integer m_recordNumber;
    private String[] m_fields;
    private final MPXJFormats m_formats;

    Record(ProjectFile file, Locale locale, Tokenizer tk, MPXJFormats formats) throws MPXJException {
        try {
            this.m_locale = locale;
            this.m_formats = formats;
            ArrayList<String> list = new ArrayList<String>();
            while (tk.nextToken() == -3) {
                list.add(tk.getToken());
            }
            if (!list.isEmpty()) {
                this.setRecordNumber(file, list);
                this.m_fields = list.toArray(new String[0]);
            }
        }
        catch (IOException ex) {
            throw new MPXJException("Invalid record", ex);
        }
    }

    private void setRecordNumber(ProjectFile file, List<String> list) {
        try {
            String number = list.remove(0);
            if (!"PX".equals(number)) {
                this.m_recordNumber = Integer.valueOf(number);
            }
        }
        catch (NumberFormatException ex) {
            file.addIgnoredError(ex);
        }
    }

    public Integer getRecordNumber() {
        return this.m_recordNumber;
    }

    public String getString(int field) {
        String result;
        if (field < this.m_fields.length) {
            result = this.m_fields[field];
            if (result != null) {
                result = result.replace('\u007f', '\n');
            }
        } else {
            result = null;
        }
        return result;
    }

    public Character getCharacter(int field) {
        Character result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? Character.valueOf(this.m_fields[field].charAt(0)) : null;
        return result;
    }

    public Number getFloat(int field) throws MPXJException {
        try {
            Number result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? (Number)this.m_formats.getDecimalFormat().parse(this.m_fields[field]) : (Number)null;
            return result;
        }
        catch (ParseException ex) {
            throw new MPXJException("Failed to parse float", ex);
        }
    }

    public Integer getInteger(int field) {
        Integer result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? Integer.valueOf(this.m_fields[field]) : null;
        return result;
    }

    public LocalDateTime getDateTime(int field) {
        LocalDateTime result = null;
        if (field < this.m_fields.length && !this.m_fields[field].isEmpty()) {
            result = this.m_formats.parseDateTime(this.m_fields[field]);
        }
        return result;
    }

    public LocalDateTime getDate(int field) {
        LocalDateTime result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? this.m_formats.parseDate(this.m_fields[field]) : null;
        return result;
    }

    public LocalTime getTime(int field) {
        LocalTime result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? this.m_formats.parseTime(this.m_fields[field]) : null;
        return result;
    }

    public boolean getNumericBoolean(int field) {
        boolean result = false;
        if (field < this.m_fields.length && !this.m_fields[field].isEmpty()) {
            result = Integer.parseInt(this.m_fields[field]) == 1;
        }
        return result;
    }

    public Rate getRate(int field) throws MPXJException {
        Rate result;
        if (field < this.m_fields.length && !this.m_fields[field].isEmpty()) {
            try {
                TimeUnit units;
                double amount;
                String rate = this.m_fields[field];
                int index = rate.indexOf(47);
                if (index == -1) {
                    amount = this.m_formats.getCurrencyFormat().parse(rate).doubleValue();
                    units = TimeUnit.HOURS;
                } else {
                    amount = this.m_formats.getCurrencyFormat().parse(rate.substring(0, index)).doubleValue();
                    units = TimeUnitUtility.getInstance(rate.substring(index + 1), this.m_locale);
                }
                result = new Rate(amount, units);
            }
            catch (ParseException ex) {
                throw new MPXJException("Failed to parse rate", ex);
            }
        } else {
            result = null;
        }
        return result;
    }

    public Number getCurrency(int field) throws MPXJException {
        Number result;
        if (field < this.m_fields.length && !this.m_fields[field].isEmpty()) {
            try {
                result = this.m_formats.getCurrencyFormat().parse(this.m_fields[field]);
            }
            catch (ParseException ex) {
                throw new MPXJException("Failed to parse currency", ex);
            }
        } else {
            result = null;
        }
        return result;
    }

    public Number getPercentage(int field) throws MPXJException {
        Number result;
        if (field < this.m_fields.length && !this.m_fields[field].isEmpty()) {
            try {
                result = this.m_formats.getPercentageDecimalFormat().parse(this.m_fields[field]);
            }
            catch (ParseException ex) {
                throw new MPXJException("Failed to parse percentage", ex);
            }
        } else {
            result = null;
        }
        return result;
    }

    public Duration getDuration(int field) throws MPXJException {
        Duration result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? DurationUtility.getInstance(this.m_fields[field], this.m_formats.getDurationDecimalFormat(), this.m_locale) : null;
        return result;
    }

    public Number getUnits(int field) throws MPXJException {
        Double result;
        if (field < this.m_fields.length && !this.m_fields[field].isEmpty()) {
            try {
                result = this.m_formats.getUnitsDecimalFormat().parse(this.m_fields[field]).doubleValue() * 100.0;
            }
            catch (ParseException ex) {
                throw new MPXJException("Failed to parse units", ex);
            }
        } else {
            result = null;
        }
        return result;
    }

    public TimeUnit getTimeUnit(int field) {
        TimeUnit result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? TimeUnit.getInstance(Integer.parseInt(this.m_fields[field])) : TimeUnit.DAYS;
        return result;
    }

    public ProjectTimeFormat getTimeFormat(int field) {
        ProjectTimeFormat result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? ProjectTimeFormat.getInstance(Integer.parseInt(this.m_fields[field])) : ProjectTimeFormat.TWELVE_HOUR;
        return result;
    }

    public ScheduleFrom getScheduleFrom(int field) {
        ScheduleFrom result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? ScheduleFrom.getInstance(Integer.parseInt(this.m_fields[field])) : ScheduleFrom.START;
        return result;
    }

    public DateOrder getDateOrder(int field) {
        DateOrder result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? DateOrder.getInstance(Integer.parseInt(this.m_fields[field])) : DateOrder.MDY;
        return result;
    }

    public CurrencySymbolPosition getCurrencySymbolPosition(int field) {
        CurrencySymbolPosition result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? CurrencySymbolPosition.getInstance(Integer.parseInt(this.m_fields[field])) : CurrencySymbolPosition.BEFORE;
        return result;
    }

    public ProjectDateFormat getDateFormat(int field) {
        ProjectDateFormat result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? ProjectDateFormat.getInstance(Integer.parseInt(this.m_fields[field])) : ProjectDateFormat.DD_MM_YY;
        return result;
    }

    public CodePage getCodePage(int field) {
        CodePage result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? CodePage.getInstance(this.m_fields[field]) : CodePage.getInstance(null);
        return result;
    }

    public AccrueType getAccrueType(int field) {
        AccrueType result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? AccrueTypeUtility.getInstance(this.m_fields[field], this.m_locale) : null;
        return result;
    }

    public Boolean getBoolean(int field, String falseText) {
        Boolean result;
        if (field < this.m_fields.length && !this.m_fields[field].isEmpty()) {
            String value = this.m_fields[field];
            if (value.equals("0")) {
                return Boolean.FALSE;
            }
            if (value.equals("1")) {
                return Boolean.TRUE;
            }
            result = !value.equalsIgnoreCase(falseText);
        } else {
            result = null;
        }
        return result;
    }

    public DayType getDayType(int field) {
        DayType result = field < this.m_fields.length && !this.m_fields[field].isEmpty() ? DayType.getInstance(Integer.parseInt(this.m_fields[field])) : DayType.DEFAULT;
        return result;
    }

    public int getLength() {
        return this.m_fields.length;
    }

    public String toString() {
        return Arrays.toString(this.m_fields);
    }
}

