/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpx;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.mpxj.Duration;
import org.mpxj.ProjectProperties;
import org.mpxj.RecurrenceType;
import org.mpxj.RecurringData;
import org.mpxj.RecurringTask;
import org.mpxj.TimeUnit;
import org.mpxj.common.DayOfWeekHelper;

final class RecurrenceUtility {
    private static final TimeUnit[] DURATION_UNITS = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.WEEKS, TimeUnit.HOURS, TimeUnit.MINUTES};
    private static final Map<TimeUnit, Integer> UNITS_MAP = new HashMap<TimeUnit, Integer>();
    private static final Map<Integer, RecurrenceType> RECURRENCE_TYPE_MAP;
    private static final Map<RecurrenceType, Integer> RECURRENCE_VALUE_MAP;
    private static final DayOfWeek[] DAY_ARRAY;
    private static final Map<DayOfWeek, Integer> DAY_MAP;
    public static final int[] RECURRING_TASK_DAY_MASKS;

    private RecurrenceUtility() {
    }

    public static Duration getDuration(ProjectProperties properties, Integer durationValue, Integer unitsValue) {
        Duration result;
        if (durationValue == null) {
            result = null;
        } else {
            result = Duration.getInstance(durationValue, TimeUnit.MINUTES);
            TimeUnit units = RecurrenceUtility.getDurationUnits(unitsValue);
            if (result.getUnits() != units) {
                result = result.convertUnits(units, properties);
            }
        }
        return result;
    }

    public static Integer getDurationValue(ProjectProperties properties, Duration duration) {
        Integer result;
        if (duration == null) {
            result = null;
        } else {
            if (duration.getUnits() != TimeUnit.MINUTES) {
                duration = duration.convertUnits(TimeUnit.MINUTES, properties);
            }
            result = (int)duration.getDuration();
        }
        return result;
    }

    public static Integer getDurationUnits(RecurringTask recurrence) {
        Duration duration = recurrence.getDuration();
        Integer result = null;
        if (duration != null) {
            result = UNITS_MAP.get(duration.getUnits());
        }
        return result;
    }

    private static TimeUnit getDurationUnits(Integer value) {
        int index;
        TimeUnit result = null;
        if (value != null && (index = value.intValue()) >= 0 && index < DURATION_UNITS.length) {
            result = DURATION_UNITS[index];
        }
        if (result == null) {
            result = TimeUnit.DAYS;
        }
        return result;
    }

    public static RecurrenceType getRecurrenceType(Integer value) {
        return RECURRENCE_TYPE_MAP.get(value);
    }

    public static Integer getRecurrenceValue(RecurrenceType value) {
        return RECURRENCE_VALUE_MAP.get(value);
    }

    public static Integer getDays(String days) {
        Integer result = null;
        if (days != null) {
            result = Integer.parseInt(days, 2);
        }
        return result;
    }

    public static String getDays(RecurringTask task) {
        StringBuilder sb = new StringBuilder();
        for (DayOfWeek day : DayOfWeekHelper.ORDERED_DAYS) {
            sb.append(task.getWeeklyDay(day) ? "1" : "0");
        }
        return sb.toString();
    }

    public static DayOfWeek getDay(Integer day) {
        DayOfWeek result = null;
        if (day != null) {
            result = DAY_ARRAY[day];
        }
        return result;
    }

    public static Integer getDay(DayOfWeek day) {
        Integer result = null;
        if (day != null) {
            result = DAY_MAP.get(day);
        }
        return result;
    }

    public static LocalDate getYearlyAbsoluteAsDate(RecurringData data) {
        Integer yearlyAbsoluteDay = data.getDayNumber();
        Integer yearlyAbsoluteMonth = data.getMonthNumber();
        LocalDate startDate = data.getStartDate();
        LocalDate result = yearlyAbsoluteDay == null || yearlyAbsoluteMonth == null || startDate == null ? null : LocalDate.of(startDate.getYear(), yearlyAbsoluteMonth, (int)yearlyAbsoluteDay);
        return result;
    }

    static {
        for (int loop = 0; loop < DURATION_UNITS.length; ++loop) {
            UNITS_MAP.put(DURATION_UNITS[loop], loop);
        }
        RECURRENCE_TYPE_MAP = new HashMap<Integer, RecurrenceType>();
        RECURRENCE_TYPE_MAP.put(1, RecurrenceType.DAILY);
        RECURRENCE_TYPE_MAP.put(4, RecurrenceType.WEEKLY);
        RECURRENCE_TYPE_MAP.put(8, RecurrenceType.MONTHLY);
        RECURRENCE_TYPE_MAP.put(16, RecurrenceType.YEARLY);
        RECURRENCE_VALUE_MAP = new HashMap<RecurrenceType, Integer>();
        RECURRENCE_VALUE_MAP.put(RecurrenceType.DAILY, 1);
        RECURRENCE_VALUE_MAP.put(RecurrenceType.WEEKLY, 4);
        RECURRENCE_VALUE_MAP.put(RecurrenceType.MONTHLY, 8);
        RECURRENCE_VALUE_MAP.put(RecurrenceType.YEARLY, 16);
        DAY_ARRAY = new DayOfWeek[]{null, DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY};
        DAY_MAP = new HashMap<DayOfWeek, Integer>();
        DAY_MAP.put(DayOfWeek.MONDAY, 1);
        DAY_MAP.put(DayOfWeek.TUESDAY, 2);
        DAY_MAP.put(DayOfWeek.WEDNESDAY, 3);
        DAY_MAP.put(DayOfWeek.THURSDAY, 4);
        DAY_MAP.put(DayOfWeek.FRIDAY, 5);
        DAY_MAP.put(DayOfWeek.SATURDAY, 6);
        DAY_MAP.put(DayOfWeek.SUNDAY, 7);
        RECURRING_TASK_DAY_MASKS = new int[]{0, 64, 32, 16, 8, 4, 2, 1};
    }
}

